/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.ceu.energy;

import com.tictim.ceu.enums.Energy;
import com.tictim.ceu.mte.MTECeu;
import com.tictim.ceu.util.Ratio;
import gregtech.api.capability.IElectricItem;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItemManager;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;

public class ElectricItemIC2EU
implements IElectricItem {
    private static Boolean isIc2Available;
    private final IElectricItemManager manager;
    private final ItemStack stack;
    private final Ratio ratio;

    @Nullable
    public static ElectricItemIC2EU fromItem(MTECeu ceu, ItemStack stack) {
        if (isIc2Available == null) {
            isIc2Available = Loader.isModLoaded((String)"ic2");
        }
        return isIc2Available != false ? new ElectricItemIC2EU(ceu, stack) : null;
    }

    private ElectricItemIC2EU(MTECeu ceu, ItemStack stack) {
        this(ceu, ElectricItem.manager, stack);
    }

    private ElectricItemIC2EU(MTECeu ceu, IElectricItemManager manager, ItemStack stack) {
        this.manager = manager;
        this.stack = stack;
        this.ratio = ceu.getType().getInput() == Energy.IC2EU ? ceu.ratio() : ceu.ratio().reverse();
    }

    public boolean canProvideChargeExternally() {
        return true;
    }

    public void addChargeListener(BiConsumer<ItemStack, Long> chargeListener) {
    }

    @Optional.Method(modid="ic2")
    public long charge(long amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        return this.ratio.convertToLong(this.manager.charge(this.stack, this.ratio.reverse().convertToDouble(amount), tier, ignoreTransferLimit, simulate));
    }

    @Optional.Method(modid="ic2")
    public long discharge(long amount, int tier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
        return this.ratio.convertToLong(this.manager.discharge(this.stack, this.ratio.reverse().convertToDouble(amount), tier, ignoreTransferLimit, externally, simulate));
    }

    @Optional.Method(modid="ic2")
    public long getCharge() {
        return this.ratio.convertToLong(this.manager.getCharge(this.stack));
    }

    @Optional.Method(modid="ic2")
    public long getMaxCharge() {
        return this.ratio.convertToLong(this.manager.getMaxCharge(this.stack));
    }

    @Optional.Method(modid="ic2")
    public boolean canUse(long amount) {
        return this.manager.canUse(this.stack, this.ratio.reverse().convertToDouble(amount));
    }

    @Optional.Method(modid="ic2")
    public int getTier() {
        return this.manager.getTier(this.stack);
    }
}

