/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.ceu.energy;

import com.tictim.ceu.enums.Energy;
import com.tictim.ceu.mte.MTECeu;
import com.tictim.ceu.util.Ratio;
import gregtech.api.capability.IElectricItem;
import java.util.function.BiConsumer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.energy.IEnergyStorage;

public class ElectricItemFE
implements IElectricItem {
    private final MTECeu ceu;
    private final IEnergyStorage storage;
    private final Ratio ratio;

    public ElectricItemFE(MTECeu ceu, IEnergyStorage storage) {
        this.ceu = ceu;
        this.storage = storage;
        this.ratio = ceu.getType().getInput() == Energy.FE ? ceu.ratio() : ceu.ratio().reverse();
    }

    public boolean canProvideChargeExternally() {
        return true;
    }

    public void addChargeListener(BiConsumer<ItemStack, Long> chargeListener) {
    }

    public long charge(long amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        return this.ratio.convertToLong(this.storage.receiveEnergy(this.ratio.reverse().convertToInt(amount), simulate));
    }

    public long discharge(long amount, int tier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
        return this.ratio.convertToLong(this.storage.extractEnergy(this.ratio.reverse().convertToInt(amount), simulate));
    }

    public long getCharge() {
        return this.ratio.convertToLong(this.storage.getEnergyStored());
    }

    public long getMaxCharge() {
        return this.ratio.convertToLong(this.storage.getMaxEnergyStored());
    }

    public boolean canUse(long amount) {
        return this.ratio.convertToLong(this.storage.getEnergyStored()) >= amount;
    }

    public int getTier() {
        return this.ceu.getTier();
    }
}

