/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.ceu.config;

import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.commons.lang3.Validate;

public final class PropertyHandler {
    public static final BiConsumer<Property, Property> DEFAULT_REPLACER = (p, pRetro) -> {
        if (p.isList()) {
            p.set(pRetro.getStringList());
        } else {
            p.set(pRetro.getString());
        }
    };
    @Nullable
    private final Configuration cfg;
    private final String category;
    private final Property pSample;

    public PropertyHandler(@Nullable Configuration cfg, String category, Property propertySample) {
        this.cfg = cfg;
        this.category = category;
        this.pSample = propertySample;
    }

    public PropertyHandler(@Nullable Configuration cfg, String category, String key, boolean defaultValue) {
        this(cfg, category, new Configuration().get(category, key, defaultValue));
    }

    public PropertyHandler(@Nullable Configuration cfg, String category, String key, boolean defaultValue, String comment) {
        this(cfg, category, new Configuration().get(category, key, defaultValue, comment));
    }

    public PropertyHandler(@Nullable Configuration cfg, String category, String key, boolean[] defaultValues) {
        this(cfg, category, new Configuration().get(category, key, defaultValues));
    }

    public PropertyHandler(@Nullable Configuration cfg, String category, String key, boolean[] defaultValues, String comment) {
        this(cfg, category, new Configuration().get(category, key, defaultValues, comment));
    }

    public PropertyHandler(@Nullable Configuration cfg, String category, String key, boolean[] defaultValues, String comment, boolean isListLengthFixed, int maxListLength) {
        this(cfg, category, new Configuration().get(category, key, defaultValues, comment, isListLengthFixed, maxListLength));
    }

    public PropertyHandler(@Nullable Configuration cfg, String category, String key, int defaultValue) {
        this(cfg, category, new Configuration().get(category, key, defaultValue));
    }

    public PropertyHandler(@Nullable Configuration cfg, String category, String key, int defaultValue, String comment) {
        this(cfg, category, new Configuration().get(category, key, defaultValue, comment));
    }

    public PropertyHandler(@Nullable Configuration cfg, String category, String key, int defaultValue, String comment, int minValue, int maxValue) {
        this(cfg, category, new Configuration().get(category, key, defaultValue, comment, minValue, maxValue));
    }

    public PropertyHandler(@Nullable Configuration cfg, String category, String key, int[] defaultValues) {
        this(cfg, category, new Configuration().get(category, key, defaultValues));
    }

    public PropertyHandler(@Nullable Configuration cfg, String category, String key, int[] defaultValues, String comment) {
        this(cfg, category, new Configuration().get(category, key, defaultValues, comment));
    }

    public PropertyHandler(@Nullable Configuration cfg, String category, String key, int[] defaultValues, String comment, int minValue, int maxValue) {
        this(cfg, category, new Configuration().get(category, key, defaultValues, comment, minValue, maxValue));
    }

    public PropertyHandler(@Nullable Configuration cfg, String category, String key, int[] defaultValues, String comment, int minValue, int maxValue, boolean isListLengthFixed, int maxListLength) {
        this(cfg, category, new Configuration().get(category, key, defaultValues, comment, minValue, maxValue, isListLengthFixed, maxListLength));
    }

    public PropertyHandler(@Nullable Configuration cfg, String category, String key, double defaultValue) {
        this(cfg, category, new Configuration().get(category, key, defaultValue));
    }

    public PropertyHandler(@Nullable Configuration cfg, String category, String key, double defaultValue, String comment) {
        this(cfg, category, new Configuration().get(category, key, defaultValue, comment));
    }

    public PropertyHandler(@Nullable Configuration cfg, String category, String key, double defaultValue, String comment, double minValue, double maxValue) {
        this(cfg, category, new Configuration().get(category, key, defaultValue, comment, minValue, maxValue));
    }

    public PropertyHandler(@Nullable Configuration cfg, String category, String key, double[] defaultValues) {
        this(cfg, category, new Configuration().get(category, key, defaultValues));
    }

    public PropertyHandler(@Nullable Configuration cfg, String category, String key, double[] defaultValues, String comment) {
        this(cfg, category, new Configuration().get(category, key, defaultValues, comment));
    }

    public PropertyHandler(@Nullable Configuration cfg, String category, String key, double[] defaultValues, String comment, double minValue, double maxValue) {
        this(cfg, category, new Configuration().get(category, key, defaultValues, comment, minValue, maxValue));
    }

    public PropertyHandler(@Nullable Configuration cfg, String category, String key, double[] defaultValues, String comment, double minValue, double maxValue, boolean isListLengthFixed, int maxListLength) {
        this(cfg, category, new Configuration().get(category, key, defaultValues, comment, minValue, maxValue, isListLengthFixed, maxListLength));
    }

    public PropertyHandler(@Nullable Configuration cfg, String category, String key, String defaultValue) {
        this(cfg, category, new Configuration().get(category, key, defaultValue));
    }

    public PropertyHandler(@Nullable Configuration cfg, String category, String key, String defaultValue, String comment) {
        this(cfg, category, new Configuration().get(category, key, defaultValue, comment));
    }

    public PropertyHandler(@Nullable Configuration cfg, String category, String key, String defaultValue, String comment, Pattern validationPattern) {
        this(cfg, category, new Configuration().get(category, key, defaultValue, comment, validationPattern));
    }

    public PropertyHandler(@Nullable Configuration cfg, String category, String key, String defaultValue, String comment, String[] validValues) {
        this(cfg, category, new Configuration().get(category, key, defaultValue, comment, validValues));
    }

    public PropertyHandler(@Nullable Configuration cfg, String category, String key, String[] defaultValues) {
        this(cfg, category, new Configuration().get(category, key, defaultValues));
    }

    public PropertyHandler(@Nullable Configuration cfg, String category, String key, String[] defaultValues, String comment) {
        this(cfg, category, new Configuration().get(category, key, defaultValues, comment));
    }

    public PropertyHandler(@Nullable Configuration cfg, String category, String key, String[] defaultValues, String comment, Pattern validationPattern) {
        this(cfg, category, new Configuration().get(category, key, defaultValues, comment, validationPattern));
    }

    public PropertyHandler(@Nullable Configuration cfg, String category, String key, String[] defaultValues, String comment, boolean isListLengthFixed, int maxListLength, Pattern validationPattern) {
        this(cfg, category, new Configuration().get(category, key, defaultValues, comment, isListLengthFixed, maxListLength, validationPattern));
    }

    public PropertyHandler(@Nullable Configuration cfg, String category, String key, String defaultValue, String comment, Property.Type type) {
        this(cfg, category, new Configuration().get(category, key, defaultValue, comment, type));
    }

    public PropertyHandler(@Nullable Configuration cfg, String category, String key, String[] defaultValues, String comment, Property.Type type) {
        this(cfg, category, new Configuration().get(category, key, defaultValues, comment, type));
    }

    public PropertyHandler requiresWorldRestart() {
        this.pSample.setRequiresWorldRestart(true);
        return this;
    }

    public PropertyHandler requiresMcRestart() {
        this.pSample.setRequiresMcRestart(true);
        return this;
    }

    public boolean has() {
        return this.cfg != null && this.cfg.hasKey(this.category, this.pSample.getName());
    }

    @Nullable
    public Property get() {
        if (this.cfg == null) {
            return null;
        }
        if (this.pSample.isList()) {
            Property p = this.cfg.get(this.category, this.pSample.getName(), this.pSample.getDefaults(), this.pSample.getComment(), this.pSample.getType());
            if (this.pSample.isListLengthFixed()) {
                p.setIsListLengthFixed(true);
                p.setMaxListLength(this.pSample.getMaxListLength());
            }
            if (this.pSample.requiresWorldRestart()) {
                p.setRequiresWorldRestart(true);
            }
            if (this.pSample.requiresMcRestart()) {
                p.setRequiresMcRestart(true);
            }
            return p;
        }
        return this.cfg.get(this.category, this.pSample.getName(), this.pSample.getDefault(), this.pSample.getComment(), this.pSample.getType());
    }

    public Property replace(PropertyHandler retro) {
        return this.replace(retro, DEFAULT_REPLACER);
    }

    public Property replace(PropertyHandler retro, BiConsumer<Property, Property> replacer) {
        Validate.notNull((Object)this.cfg);
        boolean overrideWithRetro = retro.has() && !this.has();
        Property p = this.get();
        if (overrideWithRetro) {
            replacer.accept(p, retro.get());
        }
        return p;
    }
}

