/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.ingredients;

import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.LittleTileBlock;
import com.creativemd.littletiles.common.tiles.vec.LittleTileSize;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.ingredients.IngredientUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class BlockIngredient {
    public Block block;
    public int meta;
    public double value;

    BlockIngredient(Block block, int meta, double value) {
        this.block = block;
        this.meta = meta;
        this.value = value;
    }

    public ItemStack getItemStack() {
        return new ItemStack(this.block, 1, this.meta);
    }

    public ItemStack getTileItemStack() {
        ItemStack stack = new ItemStack(LittleTiles.blockTileNoTicking);
        NBTTagCompound nbt = new NBTTagCompound();
        new LittleTileSize(1, 1, 1).writeToNBT("size", nbt);
        LittleTileBlock tile = new LittleTileBlock(this.block, this.meta);
        ((LittleTile)tile).saveTileExtra(nbt);
        nbt.func_74778_a("tID", "BlockTileBlock");
        stack.func_77982_d(nbt);
        int count = (int)(this.value / LittleGridContext.get().minimumTileSize);
        if (count == 0) {
            LittleGridContext.getMax().set(stack.func_77978_p());
            count = (int)(this.value / LittleGridContext.getMax().minimumTileSize);
        }
        stack.func_190920_e(count);
        return stack;
    }

    public int hashCode() {
        return this.block.hashCode() + this.meta;
    }

    public boolean equals(Object object) {
        return object instanceof BlockIngredient && ((BlockIngredient)object).block == this.block && ((BlockIngredient)object).meta == this.meta;
    }

    public IBlockState getState() {
        return this.block.func_176203_a(this.meta);
    }

    public boolean is(ItemStack stack) {
        return Block.func_149634_a((Item)stack.func_77973_b()) == this.block && stack.func_77952_i() == this.meta;
    }

    public BlockIngredient copy() {
        return new BlockIngredient(this.block, this.meta, this.value);
    }

    public BlockIngredient copy(double value) {
        return new BlockIngredient(this.block, this.meta, value);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("block", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.block)).toString());
        nbt.func_74768_a("meta", this.meta);
        nbt.func_74780_a("volume", this.value);
        return nbt;
    }

    public static class BlockIngredients {
        private List<BlockIngredient> content = new ArrayList<BlockIngredient>();

        public BlockIngredients() {
        }

        public BlockIngredients(List<BlockIngredient> ingredients) {
            this();
            this.addIngredients(ingredients);
        }

        public List<BlockIngredient> getIngredients() {
            return this.content;
        }

        public void addIngredients(BlockIngredients ingredients) {
            this.addIngredients(ingredients.content);
        }

        public void addIngredients(List<BlockIngredient> ingredients) {
            for (BlockIngredient ingredient : ingredients) {
                this.addIngredient(ingredient);
            }
        }

        public void addIngredient(BlockIngredient ingredient) {
            if (ingredient == null) {
                return;
            }
            int indexOf = this.content.indexOf(ingredient);
            if (indexOf != -1) {
                this.content.get((int)indexOf).value += ingredient.value;
            } else {
                this.content.add(ingredient.copy());
            }
        }

        public BlockIngredient drainItemStack(ItemStack stack) {
            BlockIngredient ingredient = IngredientUtils.getBlockIngredientOfBlockStack(stack);
            int indexOf = this.content.indexOf(ingredient);
            if (indexOf != -1) {
                BlockIngredient ownIngredient = this.content.get(indexOf);
                int amount = Math.min(stack.func_190916_E(), (int)Math.ceil(ownIngredient.value / ingredient.value));
                double volume = ingredient.value * (double)amount;
                stack.func_190918_g(amount);
                if (volume >= ownIngredient.value) {
                    this.content.remove(indexOf);
                    if (volume > ownIngredient.value) {
                        return new BlockIngredient(ingredient.block, ingredient.meta, volume - ownIngredient.value);
                    }
                } else {
                    ownIngredient.value -= volume;
                }
            }
            return null;
        }

        public void drainIngredient(BlockIngredient ingredient) {
            int indexOf = this.content.indexOf(ingredient);
            if (indexOf != -1) {
                BlockIngredient ownIngredient = this.content.get(indexOf);
                ownIngredient.value -= ingredient.value;
                if (ownIngredient.value <= 0.0) {
                    this.content.remove(indexOf);
                }
            }
        }

        public void drainIngredients(BlockIngredients ingredients) {
            for (BlockIngredient ingredient : ingredients.content) {
                this.drainIngredient(ingredient);
            }
        }

        public BlockIngredient getEqualIngredient(BlockIngredient ingredient) {
            int indexOf = this.content.indexOf(ingredient);
            if (indexOf != -1) {
                return this.content.get(indexOf);
            }
            return null;
        }

        public boolean isEmpty() {
            return this.content.isEmpty();
        }

        public BlockIngredients copy() {
            return new BlockIngredients(this.content);
        }

        public int size() {
            return this.content.size();
        }
    }
}

