/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.animation;

import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.creativecore.common.utils.type.PairList;
import com.creativemd.littletiles.common.utils.animation.Animation;
import com.creativemd.littletiles.common.utils.animation.AnimationController;
import com.creativemd.littletiles.common.utils.animation.AnimationState;
import com.creativemd.littletiles.common.utils.animation.OffsetAnimation;
import com.creativemd.littletiles.common.utils.animation.RotateAnimation;
import com.creativemd.littletiles.common.utils.animation.TimestampAnimation;
import com.creativemd.littletiles.common.utils.animation.transformation.OffsetTransformation;
import com.creativemd.littletiles.common.utils.animation.transformation.RotationTransformation;
import java.util.BitSet;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class AnimationTimeline
extends Animation {
    protected final AnimationState currentState;
    protected final PairList<Long, Animation> animations;
    protected BitSet activeAnimations;
    protected int animationIndex = 0;

    public AnimationTimeline(long duration, PairList<Long, Animation> animations) {
        super(duration);
        this.animations = animations;
        this.currentState = new AnimationState("ticking", new RotationTransformation(0.0, 0.0, 0.0), new OffsetTransformation(0.0, 0.0, 0.0));
        this.activeAnimations = new BitSet(animations.size());
    }

    public AnimationTimeline(NBTTagCompound nbt) {
        super(nbt.func_74763_f("duration"));
        this.animations = new PairList();
        this.currentState = new AnimationState("ticking", new RotationTransformation(0.0, 0.0, 0.0), new OffsetTransformation(0.0, 0.0, 0.0));
        this.activeAnimations = new BitSet(this.animations.size());
        NBTTagList list = nbt.func_150295_c("animations", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound animationNBT = list.func_150305_b(i);
            this.animations.add((Object)animationNBT.func_74763_f("time"), (Object)AnimationTimeline.getAnimation(animationNBT.func_74762_e("type"), animationNBT.func_74759_k("data")));
        }
    }

    public boolean tick(AnimationController controller) {
        return this.tick(this, this.currentState);
    }

    @Override
    public void tick(AnimationState currentState) {
        while (this.animationIndex < this.animations.size()) {
            Pair pair = (Pair)this.animations.get(this.animationIndex);
            if ((Long)pair.key > this.tick) break;
            this.activeAnimations.set(this.animationIndex);
            ++this.animationIndex;
        }
        int index = -1;
        while ((index = this.activeAnimations.nextSetBit(index + 1)) != -1) {
            if (((Animation)((Pair)this.animations.get((int)index)).value).tick(this, currentState)) continue;
            this.activeAnimations.set(index, false);
        }
    }

    @Override
    public void end(AnimationState currentState) {
        int index = 0;
        while ((index = this.activeAnimations.nextSetBit(index + 1)) != -1) {
            ((Animation)((Pair)this.animations.get((int)index)).value).end(currentState);
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74772_a("duration", this.duration);
        NBTTagList list = new NBTTagList();
        for (Pair pair : this.animations) {
            NBTTagCompound animationNBT = new NBTTagCompound();
            int type = AnimationTimeline.getAnimationType((Animation)pair.value);
            if (type == -1) {
                throw new RuntimeException("Invalid animation!");
            }
            animationNBT.func_74783_a("data", AnimationTimeline.getAnimationData((Animation)pair.value));
            animationNBT.func_74768_a("type", type);
            animationNBT.func_74772_a("time", ((Long)pair.key).longValue());
            list.func_74742_a((NBTBase)animationNBT);
        }
        nbt.func_74782_a("animations", (NBTBase)list);
        return nbt;
    }

    public static int getAnimationType(Animation animation) {
        if (animation instanceof OffsetAnimation) {
            return 0;
        }
        if (animation instanceof RotateAnimation) {
            return 1;
        }
        if (animation instanceof TimestampAnimation) {
            return 2;
        }
        return -1;
    }

    public static int[] getAnimationData(Animation animation) {
        if (animation instanceof OffsetAnimation) {
            return ((OffsetAnimation)animation).getArray();
        }
        if (animation instanceof RotateAnimation) {
            return ((RotateAnimation)animation).getArray();
        }
        if (animation instanceof TimestampAnimation) {
            return ((TimestampAnimation)animation).getArray();
        }
        return null;
    }

    public static Animation getAnimation(int type, int[] data) {
        switch (type) {
            case 0: {
                return new OffsetAnimation(data);
            }
            case 1: {
                return new RotateAnimation(data);
            }
            case 2: {
                return new TimestampAnimation(data);
            }
        }
        return null;
    }
}

