/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.type;

import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCheckBox;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.registry.LittleStructureGuiParser;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleNoClipStructure
extends LittleStructure {
    public boolean web = true;

    public LittleNoClipStructure(LittleStructureType type) {
        super(type);
    }

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        this.web = nbt.func_74767_n("web");
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        nbt.func_74757_a("web", this.web);
    }

    @Override
    public boolean shouldCheckForCollision() {
        return true;
    }

    @Override
    public void onEntityCollidedWithBlock(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (this.web) {
            entityIn.func_70110_aj();
        }
    }

    public static class LittleNoClipStructureParser
    extends LittleStructureGuiParser {
        public LittleNoClipStructureParser(GuiParent parent) {
            super(parent);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void createControls(ItemStack stack, LittleStructure structure) {
            boolean slowness = true;
            if (structure instanceof LittleNoClipStructure) {
                slowness = ((LittleNoClipStructure)structure).web;
            }
            this.parent.controls.add(new GuiCheckBox("web", "slowness (cobwebs)", 3, 0, slowness));
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public LittleNoClipStructure parseStructure(ItemStack stack) {
            LittleNoClipStructure structure = this.createStructure(LittleNoClipStructure.class);
            structure.web = ((GuiCheckBox)this.parent.get((String)"web")).value;
            return structure;
        }
    }
}

