/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.connection;

import com.creativemd.creativecore.common.world.SubWorld;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.attribute.LittleStructureAttribute;
import com.creativemd.littletiles.common.structure.connection.IStructureChildConnector;
import com.creativemd.littletiles.common.structure.connection.StructureLinkBaseAbsolute;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StructureLinkToSubWorld
extends StructureLinkBaseAbsolute<LittleStructure>
implements IStructureChildConnector<LittleStructure> {
    public final String entityUUID;
    public final int childID;

    public StructureLinkToSubWorld(LittleTile tile, LittleStructureAttribute attribute, LittleStructure parent, int childID, String entityUUID) {
        super(tile, attribute, parent);
        this.childID = childID;
        this.entityUUID = entityUUID;
    }

    public StructureLinkToSubWorld(TileEntity te, LittleGridContext context, int[] identifier, LittleStructureAttribute attribute, LittleStructure parent, int childID, String entityUUID) {
        super(te, context, identifier, attribute, parent);
        this.childID = childID;
        this.entityUUID = entityUUID;
    }

    public StructureLinkToSubWorld(BlockPos pos, LittleGridContext context, int[] identifier, LittleStructureAttribute attribute, LittleStructure parent, int childID, String entityUUID) {
        super(pos, context, identifier, attribute, parent);
        this.childID = childID;
        this.entityUUID = entityUUID;
    }

    public StructureLinkToSubWorld(NBTTagCompound nbt, LittleStructure parent) {
        super(nbt, parent);
        this.childID = nbt.func_74762_e("childID");
        this.entityUUID = nbt.func_74779_i("entity");
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt = super.writeToNBT(nbt);
        nbt.func_74768_a("childID", this.childID);
        nbt.func_74778_a("entity", this.entityUUID);
        return nbt;
    }

    @Override
    protected World getWorld(World world) {
        for (Entity entity : world.func_72910_y()) {
            if (!(entity instanceof EntityAnimation) || !entity.func_189512_bd().equals(this.entityUUID)) continue;
            return ((EntityAnimation)entity).fakeWorld;
        }
        return null;
    }

    @Override
    protected void connect(World world, LittleTile mainTile) {
        this.connectedStructure = mainTile.connection.getStructureWithoutLoading();
        this.connectedStructure.parent.setLoadedStructure((LittleStructure)this.parent, ((LittleStructure)this.parent).attribute);
    }

    @Override
    protected void failedConnect(World world) {
        new RuntimeException("Failed to connect to parent/ child structure! coord=" + this + "").printStackTrace();
    }

    public StructureLinkToSubWorld copy(LittleStructure parent) {
        return new StructureLinkToSubWorld(this.pos, this.context, (int[])this.identifier.clone(), this.attribute, parent, this.childID, this.entityUUID);
    }

    @Override
    public boolean isChild() {
        return false;
    }

    @Override
    public int getChildID() {
        return this.childID;
    }

    @Override
    public void destroyStructure() {
        for (Entity entity : ((SubWorld)this.connectedStructure.getWorld()).parentWorld.func_72910_y()) {
            if (!(entity instanceof EntityAnimation) || !entity.func_189512_bd().equals(this.entityUUID)) continue;
            entity.field_70128_L = true;
            break;
        }
        for (IStructureChildConnector child : this.connectedStructure.children.values()) {
            child.destroyStructure();
        }
    }

    @Override
    public boolean isLinkToAnotherWorld() {
        return true;
    }
}

