/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action.tool;

import com.creativemd.creativecore.common.utils.mc.InventoryUtils;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.LittleActionInteract;
import com.creativemd.littletiles.common.action.block.NotEnoughIngredientsException;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.vec.LittleTileIdentifierAbsolute;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class LittleActionGlowstone
extends LittleActionInteract {
    public LittleTile changedTile;

    public LittleActionGlowstone(BlockPos blockPos, EntityPlayer player) {
        super(blockPos, player);
    }

    public LittleActionGlowstone() {
    }

    @Override
    protected boolean isRightClick() {
        return true;
    }

    @Override
    protected boolean action(World world, TileEntityLittleTiles te, LittleTile tile, ItemStack stack, EntityPlayer player, RayTraceResult moving, BlockPos pos, boolean secondMode) throws LittleActionException {
        if (stack.func_77973_b() == Items.field_151114_aO && player.func_70093_af()) {
            if (LittleActionGlowstone.needIngredients(player)) {
                if (tile.glowing) {
                    if (!player.field_71071_by.func_70441_a(new ItemStack(Items.field_151114_aO))) {
                        player.func_71019_a(new ItemStack(Items.field_151114_aO), true);
                    }
                } else {
                    stack.func_190918_g(1);
                }
            }
            if (tile.glowing) {
                player.func_184185_a(SoundEvents.field_187629_cO, 1.0f, 1.0f);
            } else {
                player.func_184185_a(SoundEvents.field_187620_cL, 1.0f, 1.0f);
            }
            tile.glowing = !tile.glowing;
            te.updateBlock();
            te.updateLighting();
            this.changedTile = tile;
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeReverted() {
        return true;
    }

    @Override
    public LittleAction revert() throws LittleActionException {
        if (LittleActionGlowstone.isTileStillInPlace(this.changedTile)) {
            return new LittleActionGlowstoneRevert(this.changedTile);
        }
        throw new LittleActionException.TileNotThereException();
    }

    public static class LittleActionGlowstoneRevert
    extends LittleAction {
        public LittleTileIdentifierAbsolute coord;
        public LittleTile changedTile;

        public LittleActionGlowstoneRevert(LittleTile tile) {
            this.coord = new LittleTileIdentifierAbsolute(tile);
        }

        public LittleActionGlowstoneRevert() {
        }

        @Override
        public boolean canBeReverted() {
            return true;
        }

        @Override
        public LittleAction revert() throws LittleActionException {
            if (LittleActionGlowstoneRevert.isTileStillInPlace(this.changedTile)) {
                return new LittleActionGlowstoneRevert(this.changedTile);
            }
            throw new LittleActionException.TileNotThereException();
        }

        @Override
        protected boolean action(EntityPlayer player) throws LittleActionException {
            ItemStack stack;
            LittleTile tile = LittleActionGlowstoneRevert.getTile(player.field_70170_p, this.coord);
            if (LittleActionGlowstoneRevert.needIngredients(player) && !InventoryUtils.consumeItemStack((IInventory)player.field_71071_by, (ItemStack)(stack = new ItemStack(Items.field_151114_aO)))) {
                throw new NotEnoughIngredientsException.NotEnoughStackException(stack);
            }
            if (tile.glowing) {
                player.func_184185_a(SoundEvents.field_187629_cO, 1.0f, 1.0f);
            } else {
                player.func_184185_a(SoundEvents.field_187620_cL, 1.0f, 1.0f);
            }
            tile.glowing = !tile.glowing;
            tile.te.updateBlock();
            tile.te.updateLighting();
            this.changedTile = tile;
            return false;
        }

        public void writeBytes(ByteBuf buf) {
            LittleActionGlowstoneRevert.writeAbsoluteCoord(this.coord, buf);
        }

        public void readBytes(ByteBuf buf) {
            this.coord = LittleActionGlowstoneRevert.readAbsoluteCoord(buf);
        }
    }
}

