/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render;

import com.creativemd.creativecore.client.mods.optifine.OptifineHelper;
import com.creativemd.creativecore.client.rendering.RenderCubeObject;
import com.creativemd.creativecore.client.rendering.model.CreativeBakedModel;
import com.creativemd.creativecore.client.rendering.model.CreativeBakedQuad;
import com.creativemd.creativecore.client.rendering.model.CreativeCubeConsumer;
import com.creativemd.creativecore.common.world.IBlockAccessFake;
import com.creativemd.creativecore.common.world.SubWorld;
import com.creativemd.littletiles.LittleTilesConfig;
import com.creativemd.littletiles.client.render.BlockLayerRenderBuffer;
import com.creativemd.littletiles.client.render.IFakeRenderingBlock;
import com.creativemd.littletiles.client.render.LittleChunkDispatcher;
import com.creativemd.littletiles.client.render.RenderCubeLayerCache;
import com.creativemd.littletiles.client.render.RenderUploader;
import com.creativemd.littletiles.client.tiles.LittleRenderingCube;
import com.creativemd.littletiles.common.blocks.BlockTile;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.optifine.shaders.SVertexBuilder;
import org.apache.commons.lang3.ArrayUtils;

@SideOnly(value=Side.CLIENT)
public class RenderingThread
extends Thread {
    private static final String[] fakeWorldMods = new String[]{"chisel"};
    public static List<RenderingThread> threads;
    private static int threadIndex;
    public static HashMap<RenderChunk, AtomicInteger> chunks;
    public static Minecraft mc;
    public ConcurrentLinkedQueue<RenderingData> updateCoords = new ConcurrentLinkedQueue();
    final int index;
    private final IBlockAccessFake fakeAccess = new IBlockAccessFake();
    public boolean active = true;
    private CreativeCubeConsumer consumer = new CreativeCubeConsumer(DefaultVertexFormats.field_176600_a, mc.func_184125_al());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized RenderingThread getNextThread() {
        List<RenderingThread> list = threads;
        synchronized (list) {
            RenderingThread thread = threads.get(threadIndex);
            if (++threadIndex >= threads.size()) {
                threadIndex = 0;
            }
            return thread;
        }
    }

    public static void initThreads(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("count has to be at least equal or greater than one");
        }
        if (threads != null) {
            for (RenderingThread thread : threads) {
                thread.active = false;
            }
            for (RenderingThread thread : threads) {
                int i = 0;
                while (thread.isAlive() && i < 10000) {
                    ++i;
                    try {
                        RenderingThread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                while (thread.updateCoords.size() > 0) {
                    thread.updateCoords.poll().te.rendering.set(false);
                }
            }
        }
        threadIndex = 0;
        threads = new ArrayList<RenderingThread>();
        for (int i = 0; i < count; ++i) {
            threads.add(new RenderingThread(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCoordToUpdate(TileEntityLittleTiles te, double distanceSq, boolean requiresUpdate) {
        RenderingThread renderer = RenderingThread.getNextThread();
        if (!te.rendering.get()) {
            te.rendering.set(true);
            if (requiresUpdate) {
                RenderChunk chunk = te.lastRenderedChunk;
                if (chunk == null) {
                    te.lastRenderedChunk = chunk = RenderUploader.getRenderChunk(RenderUploader.getViewFrustum(), te.func_174877_v());
                }
                HashMap<RenderChunk, AtomicInteger> hashMap = chunks;
                synchronized (hashMap) {
                    AtomicInteger count = chunks.get(chunk);
                    if (count == null) {
                        count = new AtomicInteger(0);
                        chunks.put(chunk, count);
                    }
                    count.getAndIncrement();
                }
            }
            renderer.updateCoords.add(new RenderingData(te, BlockTile.getState(te.isTicking(), te.isRendered()), te.func_174877_v(), requiresUpdate));
        }
    }

    public static void addCoordToUpdate(TileEntityLittleTiles te) {
        try {
            if (!(te.func_145831_w() instanceof SubWorld)) {
                RenderingThread.addCoordToUpdate(te, mc.func_175606_aa().func_174818_b(te.func_174877_v()), true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public RenderingThread(int index) {
        this.start();
        this.index = index;
    }

    public int getThreadIndex() {
        return this.index;
    }

    @Override
    public void run() {
        while (this.active) {
            block35: {
                WorldClient world = RenderingThread.mc.field_71441_e;
                if (world != null && !this.updateCoords.isEmpty()) {
                    RenderingData data = this.updateCoords.poll();
                    try {
                        List<LittleRenderingCube> cubes;
                        BlockPos pos = data.pos;
                        RenderCubeLayerCache cubeCache = data.te.getCubeCache();
                        if (data.te.func_145831_w() == null || !data.te.hasLoaded()) {
                            throw new RenderingException("Tileentity is not loaded yet");
                        }
                        for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                            cubeCache.setCubesByLayer(BlockTile.getRenderingCubes(data.state, (TileEntity)data.te, null, layer), layer);
                            cubes = cubeCache.getCubesByLayer(layer);
                            for (int j = 0; j < cubes.size(); ++j) {
                                RenderCubeObject cube = cubes.get(j);
                                if (!cube.doesNeedQuadUpdate) continue;
                                if (ArrayUtils.contains((Object[])fakeWorldMods, (Object)cube.block.getRegistryName().func_110624_b())) {
                                    this.fakeAccess.set((IBlockAccess)data.te.func_145831_w(), pos, cube.getBlockState());
                                    world = this.fakeAccess;
                                } else {
                                    world = data.te.func_145831_w();
                                }
                                IBlockState modelState = cube.getBlockState().func_185899_b((IBlockAccess)world, pos);
                                IBakedModel blockModel = OptifineHelper.getRenderModel((IBakedModel)mc.func_175602_ab().func_184389_a(modelState), (IBlockAccess)world, (IBlockState)modelState, (BlockPos)pos);
                                modelState = cube.getModelState(modelState, (IBlockAccess)world, pos);
                                BlockPos offset = cube.getOffset();
                                for (int h = 0; h < EnumFacing.field_82609_l.length; ++h) {
                                    EnumFacing facing = EnumFacing.field_82609_l[h];
                                    if (cube.shouldSideBeRendered(facing)) {
                                        if (cube.getQuad(facing) != null) continue;
                                        cube.setQuad(facing, CreativeBakedModel.getBakedQuad((IBlockAccess)world, (RenderCubeObject)cube, (BlockPos)pos, (BlockPos)offset, (IBlockState)modelState, (IBakedModel)blockModel, (BlockRenderLayer)layer, (EnumFacing)facing, (long)MathHelper.func_180186_a((Vec3i)pos), (boolean)false));
                                        continue;
                                    }
                                    cube.setQuad(facing, null);
                                }
                                cube.doesNeedQuadUpdate = false;
                            }
                        }
                        cubeCache.sortCache();
                        world = RenderingThread.mc.field_71441_e;
                        BlockLayerRenderBuffer layerBuffer = new BlockLayerRenderBuffer();
                        if (!layerBuffer.isDrawing()) {
                            data.te.renderIndex = LittleChunkDispatcher.currentRenderIndex.get();
                            try {
                                World renderWorld;
                                layerBuffer.setDrawing();
                                if (!this.consumer.format.equals((Object)DefaultVertexFormats.field_176600_a)) {
                                    this.consumer = new CreativeCubeConsumer(DefaultVertexFormats.field_176600_a, mc.func_184125_al());
                                }
                                if ((renderWorld = data.te.func_145831_w()) instanceof SubWorld && !((SubWorld)renderWorld).shouldRender) {
                                    renderWorld = ((SubWorld)renderWorld).parentWorld;
                                }
                                this.consumer.setWorld((IBlockAccess)renderWorld);
                                this.consumer.setBlockPos(pos);
                                this.consumer.setState(data.state);
                                this.consumer.getBlockInfo().updateLightMatrix();
                                for (int i = 0; i < BlockRenderLayer.values().length; ++i) {
                                    BlockRenderLayer layer;
                                    layer = BlockRenderLayer.values()[i];
                                    cubes = cubeCache.getCubesByLayer(layer);
                                    BufferBuilder buffer = null;
                                    if (cubes != null && cubes.size() > 0) {
                                        buffer = layerBuffer.createVertexBuffer(cubes);
                                    }
                                    if (buffer == null) continue;
                                    this.consumer.buffer = buffer;
                                    this.consumer.layer = layer;
                                    buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                                    if (FMLClientHandler.instance().hasOptifine() && OptifineHelper.isRenderRegions() && data.requiresUpdate) {
                                        int bits = 8;
                                        int dx = data.te.lastRenderedChunk.func_178568_j().func_177958_n() >> bits << bits;
                                        int dy = data.te.lastRenderedChunk.func_178568_j().func_177956_o() >> bits << bits;
                                        int dz = data.te.lastRenderedChunk.func_178568_j().func_177952_p() >> bits << bits;
                                        dx = OptifineHelper.getRenderChunkRegionX((RenderChunk)data.te.lastRenderedChunk);
                                        dz = OptifineHelper.getRenderChunkRegionZ((RenderChunk)data.te.lastRenderedChunk);
                                        int chunkX = MathHelper.func_76137_a((int)pos.func_177958_n(), (int)16);
                                        int chunkY = MathHelper.func_76137_a((int)pos.func_177956_o(), (int)16);
                                        int chunkZ = MathHelper.func_76137_a((int)pos.func_177952_p(), (int)16);
                                        int offsetX = pos.func_177958_n() - dx;
                                        int offsetY = pos.func_177956_o() - dy;
                                        int offsetZ = pos.func_177952_p() - dz;
                                        buffer.func_178969_c((double)offsetX, (double)offsetY, (double)offsetZ);
                                    } else {
                                        int chunkX = MathHelper.func_76137_a((int)pos.func_177958_n(), (int)16);
                                        int chunkY = MathHelper.func_76137_a((int)pos.func_177956_o(), (int)16);
                                        int chunkZ = MathHelper.func_76137_a((int)pos.func_177952_p(), (int)16);
                                        int offsetX = pos.func_177958_n() - chunkX * 16;
                                        int offsetY = pos.func_177956_o() - chunkY * 16;
                                        int offsetZ = pos.func_177952_p() - chunkZ * 16;
                                        buffer.func_178969_c((double)offsetX, (double)offsetY, (double)offsetZ);
                                    }
                                    for (int j = 0; j < cubes.size(); ++j) {
                                        RenderCubeObject cube;
                                        this.consumer.cube = cube = (RenderCubeObject)cubes.get(j);
                                        IBlockState state = cube.getBlockState();
                                        if (FMLClientHandler.instance().hasOptifine() && OptifineHelper.isShaders()) {
                                            if (state.func_177230_c() instanceof IFakeRenderingBlock) {
                                                state = ((IFakeRenderingBlock)state.func_177230_c()).getFakeState(state);
                                            }
                                            SVertexBuilder.pushEntity((IBlockState)state, (BlockPos)pos, (IBlockAccess)data.te.func_145831_w(), (BufferBuilder)buffer);
                                        }
                                        this.consumer.setState(state);
                                        this.consumer.getBlockInfo().updateShift();
                                        for (int h = 0; h < EnumFacing.field_82609_l.length; ++h) {
                                            List quads = cube.getQuad(EnumFacing.field_82609_l[h]);
                                            if (quads == null || quads.isEmpty()) continue;
                                            for (int k = 0; k < quads.size(); ++k) {
                                                BakedQuad quad = (BakedQuad)quads.get(k);
                                                this.consumer.quad = (CreativeBakedQuad)quad;
                                                this.renderQuad(buffer, quad);
                                            }
                                        }
                                        if (!FMLClientHandler.instance().hasOptifine() || !OptifineHelper.isShaders()) continue;
                                        SVertexBuilder.popEntity((BufferBuilder)buffer);
                                    }
                                    this.consumer.quad = null;
                                    this.consumer.cube = null;
                                    if (FMLClientHandler.instance().hasOptifine() && OptifineHelper.isShaders()) {
                                        SVertexBuilder.calcNormalChunkLayer((BufferBuilder)buffer);
                                    }
                                    buffer.func_178977_d();
                                    this.consumer.buffer = null;
                                    layerBuffer.setBufferByLayer(buffer, layer);
                                }
                                layerBuffer.setFinishedDrawing();
                                this.setRendered(data, layerBuffer);
                            }
                            catch (BlockLayerRenderBuffer.RenderOverlapException e) {
                                this.updateCoords.add(data);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                this.updateCoords.add(data);
                                if (layerBuffer != null) {
                                    layerBuffer.setFinishedDrawing();
                                }
                                break block35;
                            }
                        }
                        this.updateCoords.add(data);
                    }
                    catch (Exception e) {
                        this.updateCoords.add(data);
                    }
                    catch (OutOfMemoryError error) {
                        this.updateCoords.add(data);
                        error.printStackTrace();
                    }
                } else if (!(world != null || this.updateCoords.isEmpty() && chunks.isEmpty())) {
                    this.updateCoords.clear();
                    chunks.clear();
                } else if (world == null || !chunks.isEmpty()) {
                    // empty if block
                }
            }
            try {
                RenderingThread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void renderQuad(BufferBuilder buffer, BakedQuad quad) {
        if (quad.func_178212_b()) {
            this.consumer.setQuadTint(quad.func_178211_c());
        }
        this.consumer.setApplyDiffuseLighting(quad.shouldApplyDiffuseLighting());
        float[] data = new float[4];
        VertexFormat formatFrom = this.consumer.format;
        VertexFormat formatTo = quad.getFormat();
        int countFrom = formatFrom.func_177345_h();
        int countTo = formatTo.func_177345_h();
        int[] eMap = LightUtil.mapFormats((VertexFormat)formatFrom, (VertexFormat)formatTo);
        for (int v = 0; v < 4; ++v) {
            for (int e = 0; e < countFrom; ++e) {
                if (eMap[e] != countTo) {
                    LightUtil.unpack((int[])quad.func_178209_a(), (float[])data, (VertexFormat)quad.getFormat(), (int)v, (int)eMap[e]);
                    this.consumer.put(e, data);
                    continue;
                }
                this.consumer.put(e, new float[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setRendered(RenderingData data, BlockLayerRenderBuffer buffer) {
        TileEntityLittleTiles te = data.te;
        te.rendering.set(false);
        if (data.requiresUpdate) {
            RenderChunk chunk = te.lastRenderedChunk;
            if (chunk == null) {
                chunks.clear();
                te.setBuffer(buffer);
                return;
            }
            HashMap<RenderChunk, AtomicInteger> hashMap = chunks;
            synchronized (hashMap) {
                AtomicInteger count = chunks.get(chunk);
                if (count != null) {
                    count.getAndDecrement();
                }
                boolean uploadDirectly = te.getBuffer() == null;
                uploadDirectly = false;
                te.setBuffer(buffer);
                if (count == null || count.intValue() <= 0) {
                    chunks.remove(chunk);
                    chunk.func_178575_a(false);
                }
                boolean finished = true;
                for (RenderingThread thread : threads) {
                    if (thread.updateCoords.isEmpty()) continue;
                    finished = false;
                    break;
                }
                if (finished) {
                    chunks.clear();
                }
            }
        } else {
            te.setBuffer(buffer);
        }
    }

    static {
        chunks = new HashMap();
        mc = Minecraft.func_71410_x();
        RenderingThread.initThreads(LittleTilesConfig.rendering.renderingThreadCount);
    }

    private static class RenderingData {
        public TileEntityLittleTiles te;
        public IBlockState state;
        public BlockPos pos;
        public boolean requiresUpdate;

        public RenderingData(TileEntityLittleTiles te, IBlockState state, BlockPos pos, boolean requiresUpdate) {
            this.te = te;
            this.state = state;
            this.pos = pos;
            this.requiresUpdate = requiresUpdate;
        }
    }

    public static class RenderingException
    extends Exception {
        public RenderingException(String arg0) {
            super(arg0);
        }
    }
}

