/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityCockatrice;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityHippogryph;
import com.github.alexthe666.iceandfire.entity.EntitySeaSerpent;
import com.github.alexthe666.iceandfire.entity.EntityStymphalianBird;
import com.github.alexthe666.iceandfire.entity.IDeadMob;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.INpc;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class DragonUtils {
    public static BlockPos getBlockInView(EntityDragonBase dragon) {
        BlockPos pos;
        double extraZ;
        float angle;
        double extraX;
        BlockPos ground;
        int distFromGround;
        BlockPos radialPos;
        float radius = 0.75f * (0.7f * dragon.getRenderSize() / 3.0f) * -7.0f - (float)dragon.func_70681_au().nextInt(dragon.getDragonStage() * 6);
        float neg = dragon.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = dragon.field_70761_aq;
        if (dragon.hasHomePosition && dragon.homePos != null) {
            BlockPos dragonPos = new BlockPos((Entity)dragon);
            BlockPos ground2 = dragon.field_70170_p.func_175645_m(dragonPos);
            int distFromGround2 = (int)dragon.field_70163_u - ground2.func_177956_o();
            for (int i = 0; i < 10; ++i) {
                BlockPos pos2 = new BlockPos(dragon.homePos.func_177958_n() + dragon.func_70681_au().nextInt(IceAndFire.CONFIG.dragonWanderFromHomeDistance) - IceAndFire.CONFIG.dragonWanderFromHomeDistance, distFromGround2 > 16 ? (int)Math.min((double)IceAndFire.CONFIG.maxDragonFlight, dragon.field_70163_u + (double)dragon.func_70681_au().nextInt(16) - 8.0) : (int)dragon.field_70163_u + dragon.func_70681_au().nextInt(16) + 1, dragon.homePos.func_177952_p() + dragon.func_70681_au().nextInt(IceAndFire.CONFIG.dragonWanderFromHomeDistance * 2) - IceAndFire.CONFIG.dragonWanderFromHomeDistance);
                if (dragon.isTargetBlocked(new Vec3d((Vec3i)pos2)) || !(dragon.func_174831_c(pos2) > 6.0)) continue;
                return pos2;
            }
        }
        BlockPos newPos = radialPos.func_177981_b((distFromGround = (int)dragon.field_70163_u - (ground = dragon.field_70170_p.func_175645_m(radialPos = new BlockPos(dragon.field_70165_t + (extraX = (double)(radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)(angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + dragon.func_70681_au().nextFloat() * neg)))))), 0.0, dragon.field_70161_v + (extraZ = (double)(radius * MathHelper.func_76134_b((float)angle)))))).func_177956_o()) > 16 ? (int)Math.min((double)IceAndFire.CONFIG.maxDragonFlight, dragon.field_70163_u + (double)dragon.func_70681_au().nextInt(16) - 8.0) : (int)dragon.field_70163_u + dragon.func_70681_au().nextInt(16) + 1);
        BlockPos blockPos = pos = dragon.doesWantToLand() ? ground : newPos;
        if (!dragon.isTargetBlocked(new Vec3d((Vec3i)newPos)) && dragon.func_174831_c(newPos) > 6.0) {
            return newPos;
        }
        return null;
    }

    public static BlockPos getWaterBlockInView(EntityDragonBase dragon) {
        BlockPos surface;
        float radius = 0.75f * (0.7f * dragon.getRenderSize() / 3.0f) * -7.0f - (float)dragon.func_70681_au().nextInt(dragon.getDragonStage() * 6);
        float neg = dragon.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
        float angle = (float)Math.PI / 180 * dragon.field_70761_aq + 3.15f + dragon.func_70681_au().nextFloat() * neg;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        BlockPos radialPos = new BlockPos(dragon.field_70165_t + extraX, 0.0, dragon.field_70161_v + extraZ);
        BlockPos ground = dragon.field_70170_p.func_175645_m(radialPos);
        int distFromGround = (int)dragon.field_70163_u - ground.func_177956_o();
        BlockPos newPos = radialPos.func_177981_b(distFromGround > 16 ? (int)Math.min((double)IceAndFire.CONFIG.maxDragonFlight, dragon.field_70163_u + (double)dragon.func_70681_au().nextInt(16) - 8.0) : (int)dragon.field_70163_u + dragon.func_70681_au().nextInt(16) + 1);
        BlockPos pos = dragon.doesWantToLand() ? ground : newPos;
        BlockPos blockPos = surface = dragon.field_70170_p.func_180495_p(newPos.func_177979_c(2)).func_185904_a() != Material.field_151586_h ? newPos.func_177979_c(dragon.func_70681_au().nextInt(10) + 1) : newPos;
        if (dragon.func_174831_c(surface) > 6.0 && dragon.field_70170_p.func_180495_p(surface).func_185904_a() == Material.field_151586_h) {
            return surface;
        }
        return null;
    }

    public static EntityLivingBase riderLookingAtEntity(final EntityLivingBase dragon, EntityLivingBase rider, double dist) {
        Vec3d vec3d = rider.func_174824_e(1.0f);
        Vec3d vec3d1 = rider.func_70676_i(1.0f);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * dist, vec3d1.field_72448_b * dist, vec3d1.field_72449_c * dist);
        double d1 = dist;
        Entity pointedEntity = null;
        List list = rider.field_70170_p.func_175674_a((Entity)rider, rider.func_174813_aQ().func_72321_a(vec3d1.field_72450_a * dist, vec3d1.field_72448_b * dist, vec3d1.field_72449_c * dist).func_72314_b(1.0, 1.0, 1.0), Predicates.and((Predicate)EntitySelectors.field_180132_d, (Predicate)new Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                return entity != null && entity.func_70067_L() && entity instanceof EntityLivingBase && !entity.func_70028_i((Entity)dragon) && !entity.func_184191_r((Entity)dragon) && (!(entity instanceof IDeadMob) || !((IDeadMob)entity).isMobDead());
            }
        }));
        double d2 = d1;
        for (int j = 0; j < list.size(); ++j) {
            double d3;
            Entity entity1 = (Entity)list.get(j);
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)entity1.func_70111_Y() + 2.0);
            RayTraceResult raytraceresult = axisalignedbb.func_72327_a(vec3d, vec3d2);
            if (axisalignedbb.func_72318_a(vec3d)) {
                if (!(d2 >= 0.0)) continue;
                pointedEntity = entity1;
                d2 = 0.0;
                continue;
            }
            if (raytraceresult == null || !((d3 = vec3d.func_72438_d(raytraceresult.field_72307_f)) < d2) && d2 != 0.0) continue;
            if (entity1.func_184208_bv() == rider.func_184208_bv() && !rider.canRiderInteract()) {
                if (d2 != 0.0) continue;
                pointedEntity = entity1;
                continue;
            }
            pointedEntity = entity1;
            d2 = d3;
        }
        return (EntityLivingBase)pointedEntity;
    }

    public static BlockPos getBlockInViewHippogryph(EntityHippogryph hippo) {
        BlockPos radialPos;
        BlockPos pos;
        int distFromGround;
        BlockPos ground;
        float radius = -12.599999f - (float)hippo.func_70681_au().nextInt(48);
        float neg = hippo.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
        float angle = (float)Math.PI / 180 * hippo.field_70761_aq + 3.15f + hippo.func_70681_au().nextFloat() * neg;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        if (hippo.hasHomePosition && hippo.homePos != null) {
            BlockPos dragonPos = new BlockPos((Entity)hippo);
            ground = hippo.field_70170_p.func_175645_m(dragonPos);
            distFromGround = (int)hippo.field_70163_u - ground.func_177956_o();
            for (int i = 0; i < 10; ++i) {
                pos = new BlockPos(hippo.homePos.func_177958_n() + hippo.func_70681_au().nextInt(IceAndFire.CONFIG.dragonWanderFromHomeDistance) - IceAndFire.CONFIG.dragonWanderFromHomeDistance, distFromGround > 16 ? (int)Math.min((double)IceAndFire.CONFIG.maxDragonFlight, hippo.field_70163_u + (double)hippo.func_70681_au().nextInt(16) - 8.0) : (int)hippo.field_70163_u + hippo.func_70681_au().nextInt(16) + 1, hippo.homePos.func_177952_p() + hippo.func_70681_au().nextInt(IceAndFire.CONFIG.dragonWanderFromHomeDistance * 2) - IceAndFire.CONFIG.dragonWanderFromHomeDistance);
                if (hippo.isTargetBlocked(new Vec3d((Vec3i)pos)) || !(hippo.func_174831_c(pos) > 6.0)) continue;
                return pos;
            }
        }
        BlockPos newPos = radialPos.func_177981_b((distFromGround = (int)hippo.field_70163_u - (ground = hippo.field_70170_p.func_175645_m(radialPos = new BlockPos(hippo.field_70165_t + extraX, 0.0, hippo.field_70161_v + extraZ))).func_177956_o()) > 16 ? (int)Math.min((double)IceAndFire.CONFIG.maxDragonFlight, hippo.field_70163_u + (double)hippo.func_70681_au().nextInt(16) - 8.0) : (int)hippo.field_70163_u + hippo.func_70681_au().nextInt(16) + 1);
        BlockPos blockPos = pos = hippo.doesWantToLand() ? ground : newPos;
        if (!hippo.isTargetBlocked(new Vec3d((Vec3i)newPos)) && hippo.func_174831_c(newPos) > 6.0) {
            return newPos;
        }
        return null;
    }

    public static BlockPos getBlockInViewStymphalian(EntityStymphalianBird bird) {
        BlockPos pos;
        float radius = -9.45f - (float)bird.func_70681_au().nextInt(24);
        float neg = bird.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = bird.flock != null && !bird.flock.isLeader(bird) ? DragonUtils.getStymphalianFlockDirection(bird) : bird.field_70761_aq;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + bird.func_70681_au().nextFloat() * neg;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        BlockPos radialPos = DragonUtils.getStymphalianFearPos(bird, new BlockPos(bird.field_70165_t + extraX, 0.0, bird.field_70161_v + extraZ));
        BlockPos ground = bird.field_70170_p.func_175645_m(radialPos);
        int distFromGround = (int)bird.field_70163_u - ground.func_177956_o();
        int flightHeight = Math.min(IceAndFire.CONFIG.stymphalianBirdFlightHeight, bird.flock != null && !bird.flock.isLeader(bird) ? ground.func_177956_o() + bird.func_70681_au().nextInt(16) : ground.func_177956_o() + bird.func_70681_au().nextInt(16));
        BlockPos newPos = radialPos.func_177981_b(distFromGround > 16 ? flightHeight : (int)bird.field_70163_u + bird.func_70681_au().nextInt(16) + 1);
        BlockPos blockPos = pos = bird.doesWantToLand() ? ground : newPos;
        if (!bird.isTargetBlocked(new Vec3d((Vec3i)newPos)) && bird.func_174831_c(newPos) > 6.0) {
            return newPos;
        }
        return null;
    }

    private static BlockPos getStymphalianFearPos(EntityStymphalianBird bird, BlockPos fallback) {
        Vec3d vec3d;
        if (bird.getVictor() != null && bird.getVictor() instanceof EntityCreature && (vec3d = RandomPositionGenerator.func_75461_b((EntityCreature)((EntityCreature)bird.getVictor()), (int)16, (int)IceAndFire.CONFIG.stymphalianBirdFlightHeight, (Vec3d)new Vec3d(bird.getVictor().field_70165_t, bird.getVictor().field_70163_u, bird.getVictor().field_70161_v))) != null) {
            BlockPos pos = new BlockPos(vec3d);
            return new BlockPos(pos.func_177958_n(), 0, pos.func_177952_p());
        }
        return fallback;
    }

    private static float getStymphalianFlockDirection(EntityStymphalianBird bird) {
        EntityStymphalianBird leader = bird.flock.getLeader();
        if (bird.func_70068_e((Entity)leader) > 2.0) {
            double d0 = leader.field_70165_t - bird.field_70165_t;
            double d2 = leader.field_70161_v - bird.field_70161_v;
            double d1 = leader.field_70163_u + (double)leader.func_70047_e() - (bird.field_70163_u + (double)bird.func_70047_e());
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
            float degrees = MathHelper.func_76142_g((float)(f - bird.field_70177_z));
            return bird.field_70177_z + degrees;
        }
        return leader.field_70761_aq;
    }

    public static BlockPos getBlockInTargetsViewCockatrice(EntityCockatrice cockatrice, EntityLivingBase target) {
        double extraZ;
        float radius = 10 + cockatrice.func_70681_au().nextInt(10);
        float neg = cockatrice.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
        float angle = (float)Math.PI / 180 * target.field_70759_as;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        BlockPos radialPos = new BlockPos(target.field_70165_t + extraX, 0.0, target.field_70161_v + (extraZ = (double)(radius * MathHelper.func_76134_b((float)angle))));
        BlockPos ground = target.field_70170_p.func_175645_m(radialPos);
        if (!cockatrice.isTargetBlocked(new Vec3d((Vec3i)ground)) && cockatrice.func_174831_c(ground) > 30.0) {
            return ground;
        }
        return target.func_180425_c();
    }

    public static BlockPos getBlockInTargetsViewSeaSerpent(EntitySeaSerpent serpent, EntityLivingBase target) {
        double extraZ;
        float radius = 10.0f * serpent.getSeaSerpentScale() + (float)serpent.func_70681_au().nextInt(10);
        float neg = serpent.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
        float angle = (float)Math.PI / 180 * target.field_70759_as;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        BlockPos radialPos = new BlockPos(target.field_70165_t + extraX, 0.0, target.field_70161_v + (extraZ = (double)(radius * MathHelper.func_76134_b((float)angle))));
        BlockPos ground = target.field_70170_p.func_175645_m(radialPos);
        if (serpent.func_174831_c(ground) > 30.0) {
            return ground;
        }
        return target.func_180425_c();
    }

    public static boolean canTameDragonAttack(EntityTameable dragon, Entity entity) {
        String className = entity.getClass().getSimpleName();
        if (className.contains("VillagerMCA") || className.contains("MillVillager") || className.contains("Citizen")) {
            return false;
        }
        if (entity instanceof EntityVillager || entity instanceof EntityGolem || entity instanceof EntityPlayer) {
            return false;
        }
        if (entity instanceof EntityTameable) {
            return !((EntityTameable)entity).func_70909_n();
        }
        return true;
    }

    public static boolean isVillager(Entity entity) {
        String className = entity.getClass().getSimpleName();
        return entity instanceof INpc || className.contains("VillagerMCA") || className.contains("MillVillager") || className.contains("Citizen");
    }

    public static boolean isAnimaniaMob(Entity entity) {
        String className = entity.getClass().getCanonicalName().toLowerCase();
        return className.contains("animania");
    }

    public static boolean isLivestock(Entity entity) {
        String className = entity.getClass().getSimpleName();
        return entity instanceof EntityCow || entity instanceof EntitySheep || entity instanceof EntityPig || entity instanceof EntityChicken || entity instanceof EntityRabbit || entity instanceof AbstractHorse || className.contains("Cow") || className.contains("Sheep") || className.contains("Pig") || className.contains("Chicken") || className.contains("Rabbit") || className.contains("Peacock") || className.contains("Goat") || className.contains("Ferret") || className.contains("Hedgehog") || className.contains("Peahen") || className.contains("Peafowl") || className.contains("Sow") || className.contains("Hog") || className.contains("Hog");
    }

    public static boolean canDragonBreak(Block block) {
        return block != Blocks.field_180401_cv && block != Blocks.field_150343_Z && block != Blocks.field_150377_bs && block != Blocks.field_150357_h && block != Blocks.field_150384_bq && block != Blocks.field_150378_br && block != Blocks.field_150483_bI && block != Blocks.field_185776_dc && block != Blocks.field_185777_dd && block != Blocks.field_150411_aY && block != Blocks.field_185775_db;
    }

    public static boolean hasSameOwner(EntityTameable cockatrice, Entity entity) {
        EntityTameable tameable;
        return entity instanceof EntityTameable && (tameable = (EntityTameable)entity).func_184753_b() != null && cockatrice.func_184753_b() != null && tameable.func_184753_b().equals(cockatrice.func_184753_b());
    }

    public static boolean isAlive(EntityLivingBase entity) {
        return !(entity instanceof IDeadMob) || !((IDeadMob)entity).isMobDead();
    }
}

