/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.modifier;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import hellfirepvp.modularmachinery.common.machine.MachineLoader;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.BlockArray;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import hellfirepvp.modularmachinery.common.util.nbt.NBTJsonDeserializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;

public class ModifierReplacement {
    private final BlockArray.BlockInformation info;
    private final RecipeModifier modifier;
    private final List<String> description;

    public ModifierReplacement(BlockArray.BlockInformation info, RecipeModifier modifier, String description) {
        this.info = info;
        this.modifier = modifier;
        this.description = MiscUtils.splitStringBy(description, "\n");
    }

    public BlockArray.BlockInformation getBlockInformation() {
        return this.info;
    }

    public RecipeModifier getModifier() {
        return this.modifier;
    }

    public List<String> getDescriptionLines() {
        return this.description;
    }

    public static class Deserializer
    implements JsonDeserializer<ModifierReplacement> {
        public ModifierReplacement deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            BlockArray.BlockInformation blockInfo;
            NBTTagCompound match = null;
            JsonObject part = json.getAsJsonObject();
            if (part.has("nbt")) {
                JsonElement je = part.get("nbt");
                if (!je.isJsonObject()) {
                    throw new JsonParseException("The ComponentType 'nbt' expects a json compound that defines the NBT tag to match the tileentity's nbt against!");
                }
                String jsonStr = je.toString();
                try {
                    match = NBTJsonDeserializer.deserialize(jsonStr);
                }
                catch (NBTException exc) {
                    throw new JsonParseException("Error trying to parse NBTTag! Rethrowing exception...", (Throwable)exc);
                }
            }
            if (!part.has("elements")) {
                throw new JsonParseException("Modifier-tag contained no element!");
            }
            JsonElement partElement = part.get("elements");
            if (partElement.isJsonPrimitive() && partElement.getAsJsonPrimitive().isString()) {
                String strDesc = partElement.getAsString();
                blockInfo = MachineLoader.variableContext.get(strDesc);
                blockInfo = blockInfo == null ? new BlockArray.BlockInformation(Lists.newArrayList((Object[])new BlockArray.IBlockStateDescriptor[]{BlockArray.BlockInformation.getDescriptor(partElement.getAsString())})) : blockInfo.copy();
                if (match != null) {
                    blockInfo.setMatchingTag(match);
                }
            } else if (partElement.isJsonArray()) {
                JsonArray elementArray = partElement.getAsJsonArray();
                ArrayList descriptors = Lists.newArrayList();
                for (int xx = 0; xx < elementArray.size(); ++xx) {
                    JsonElement p = elementArray.get(xx);
                    if (!p.isJsonPrimitive() || !p.getAsJsonPrimitive().isString()) {
                        throw new JsonParseException("Part elements of 'elements' have to be blockstate descriptions!");
                    }
                    String prim = p.getAsString();
                    BlockArray.BlockInformation descr = MachineLoader.variableContext.get(prim);
                    if (descr != null) {
                        descriptors.addAll(descr.copy().matchingStates);
                        continue;
                    }
                    descriptors.add(BlockArray.BlockInformation.getDescriptor(prim));
                }
                if (descriptors.isEmpty()) {
                    throw new JsonParseException("'elements' array didn't contain any blockstate descriptors!");
                }
                blockInfo = new BlockArray.BlockInformation(descriptors);
                if (match != null) {
                    blockInfo.setMatchingTag(match);
                }
            } else {
                throw new JsonParseException("'elements' has to either be a blockstate description, variable or array of blockstate descriptions!");
            }
            if (!part.has("modifier") || !part.get("modifier").isJsonObject()) {
                throw new JsonParseException("'modifier' tag not found or not a json-object!");
            }
            if (!(part.has("description") && part.get("description").isJsonPrimitive() && part.getAsJsonPrimitive("description").isString())) {
                throw new JsonParseException("'description' tag not found or not a string!");
            }
            String description = part.getAsJsonPrimitive("description").getAsString();
            return new ModifierReplacement(blockInfo, (RecipeModifier)context.deserialize(part.get("modifier"), RecipeModifier.class), description);
        }
    }
}

