/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.tile;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigNull;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.IConfigCallback;
import com.feed_the_beast.ftblib.lib.data.FTBLibAPI;
import com.feed_the_beast.ftblib.lib.tile.EnumSaveType;
import com.feed_the_beast.ftblib.lib.util.BlockUtils;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.tile.TileWithTeam;
import com.feed_the_beast.ftbquests.util.ConfigQuestObject;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class TileProgressDetector
extends TileWithTeam
implements ITickable,
IConfigCallback {
    public int object = 0;
    public boolean level = false;
    public int redstoneOutput = 0;
    private QuestObject cObject;

    @Override
    protected void writeData(NBTTagCompound nbt, EnumSaveType type) {
        super.writeData(nbt, type);
        this.cObject = this.getObject();
        if (this.cObject != null) {
            this.object = this.cObject.id;
        }
        if (this.object != 0) {
            nbt.func_74768_a("Object", this.object);
        }
        if (this.level) {
            nbt.func_74757_a("Level", true);
        }
        if (this.redstoneOutput > 0 && !type.item) {
            nbt.func_74774_a("RedstoneOutput", (byte)this.redstoneOutput);
        }
    }

    @Override
    protected void readData(NBTTagCompound nbt, EnumSaveType type) {
        super.readData(nbt, type);
        this.object = nbt.func_74762_e("Object");
        this.level = nbt.func_74767_n("Level");
        if (!type.item) {
            this.redstoneOutput = nbt.func_74771_c("RedstoneOutput");
        }
        this.func_145836_u();
    }

    @Override
    public void func_145836_u() {
        super.func_145836_u();
        this.cObject = null;
    }

    @Nullable
    public QuestObject getObject() {
        if (this.object == 0) {
            return null;
        }
        if (this.cObject == null || this.cObject.invalid) {
            QuestFile file = FTBQuests.PROXY.getQuestFile(this.field_145850_b);
            if (file == null) {
                return null;
            }
            this.cObject = file.get(this.object);
        }
        return this.cObject;
    }

    public void onConfigSaved(ConfigGroup group, ICommandSender sender) {
        this.func_145836_u();
        this.func_70296_d();
        this.updateRedstoneOutput();
        BlockUtils.notifyBlockUpdate((World)this.field_145850_b, (BlockPos)this.field_174879_c, (IBlockState)this.getBlockState());
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_82737_E() % 7L == 0L) {
            this.updateRedstoneOutput();
        }
        this.checkIfDirty();
    }

    public void updateRedstoneOutput() {
        int rout = this.redstoneOutput;
        this.redstoneOutput = 0;
        this.cTeam = this.getTeam();
        this.cObject = this.getObject();
        if (this.cTeam != null && this.cObject != null) {
            int rel = this.cObject.getRelativeProgress(this.cTeam);
            if (rel >= 100) {
                this.redstoneOutput = 15;
            } else if (rel > 0 && this.level) {
                this.redstoneOutput = 1 + (int)((double)rel * 14.0 / 100.0);
            }
        }
        if (rout != this.redstoneOutput) {
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
            this.func_70296_d();
        }
    }

    public void editConfig(EntityPlayerMP player) {
        if (!player.func_70093_af()) {
            return;
        }
        boolean editor = FTBQuests.canEdit(player);
        if (!editor && !this.isOwner((EntityPlayer)player)) {
            return;
        }
        this.cObject = this.getObject();
        ConfigGroup group0 = ConfigGroup.newGroup((String)"tile");
        group0.setDisplayName((ITextComponent)new TextComponentTranslation("tile.ftbquests.progress_detector.name", new Object[0]));
        ConfigGroup config = group0.getGroup("ftbquests.progress_detector");
        config.add("team", (ConfigValue)this.createTeamConfig(), (ConfigValue)ConfigNull.INSTANCE).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.team", new Object[0])).setCanEdit(editor);
        config.add("object", (ConfigValue)new ConfigQuestObject(ServerQuestFile.INSTANCE, this.cObject, QuestObjectType.ALL_PROGRESSING){

            @Override
            public void setObject(@Nullable QuestObjectBase v) {
                TileProgressDetector.this.cObject = (QuestObject)v;
                TileProgressDetector.this.object = TileProgressDetector.this.cObject == null ? 0 : ((TileProgressDetector)TileProgressDetector.this).cObject.id;
            }
        }, (ConfigValue)new ConfigQuestObject((QuestFile)ServerQuestFile.INSTANCE, (QuestObjectBase)ServerQuestFile.INSTANCE, QuestObjectType.ALL_PROGRESSING));
        config.addBool("level", () -> this.level, v -> {
            this.level = v;
        }, false);
        FTBLibAPI.editServerConfig((EntityPlayerMP)player, (ConfigGroup)group0, (IConfigCallback)this);
    }
}

