/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.reward;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.net.MessageDisplayRewardToast;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.reward.FTBQuestsRewards;
import com.feed_the_beast.ftbquests.quest.reward.QuestReward;
import com.feed_the_beast.ftbquests.quest.reward.QuestRewardType;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class XPReward
extends QuestReward {
    public int xp = 100;

    public XPReward(QuestObjectBase parent) {
        super(parent);
    }

    @Override
    public QuestRewardType getType() {
        return FTBQuestsRewards.XP;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74768_a("xp", this.xp);
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.xp = nbt.func_74762_e("xp");
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeVarInt(this.xp);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.xp = data.readVarInt();
    }

    @Override
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addInt("xp", () -> this.xp, v -> {
            this.xp = v;
        }, 100, 1, Integer.MAX_VALUE).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.reward.ftbquests.xp", new Object[0]));
    }

    @Override
    public void claim(EntityPlayerMP player) {
        player.func_71023_q(this.xp);
        if (MessageDisplayRewardToast.ENABLED) {
            new MessageDisplayRewardToast(this.getAltDisplayName(), this.getIcon()).sendTo(player);
        }
    }

    @Override
    public ITextComponent getAltDisplayName() {
        TextComponentString text = new TextComponentString("+" + this.xp);
        text.func_150256_b().func_150238_a(TextFormatting.GREEN);
        return new TextComponentTranslation("ftbquests.reward.ftbquests.xp", new Object[0]).func_150258_a(": ").func_150257_a((ITextComponent)text);
    }
}

