/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tinkerstages;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.darkhax.bookshelf.lib.LoggingHelper;
import net.darkhax.bookshelf.util.StackUtils;
import net.darkhax.gamestages.GameStageHelper;
import net.darkhax.gamestages.GameStages;
import net.darkhax.gamestages.data.IStageData;
import net.darkhax.tinkerstages.commands.CommandTconDump;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.events.TinkerCraftingEvent;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

@Mod(modid="tinkerstages", name="Tinker Stages", version="2.0.17", dependencies="required-after:tconstruct;required-after:bookshelf;required-after:gamestages@[2.0.89,);required-after:crafttweaker", certificateFingerprint="d476d1b22b218a10d845928d1665d45fce301b27", acceptedMinecraftVersions="[1.12.2]")
public class TinkerStages {
    public static final LoggingHelper LOG = new LoggingHelper("Tinker Stages");
    public static Set<String> GENERAL_CRAFTING_STAGES = new HashSet<String>();
    public static Set<String> GENERAL_PART_REPLACING_STAGES = new HashSet<String>();
    public static Set<String> GENERAL_PART_BUILDING_STAGES = new HashSet<String>();
    public static Set<String> GENERAL_MODIFIER_STAGES = new HashSet<String>();
    public static Multimap<String, String> TOOL_CRAFTING_STAGES = HashMultimap.create();
    public static Multimap<String, String> TOOL_MATERIAL_STAGES = HashMultimap.create();
    public static Multimap<String, String> TOOL_MODIFIER_STAGES = HashMultimap.create();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        GameStages.COMMAND.addSubcommand((ICommand)new CommandTconDump());
    }

    @SubscribeEvent
    public void onToolCrafted(TinkerCraftingEvent.ToolCraftingEvent event) {
        String itemId = StackUtils.getStackIdentifier((ItemStack)event.getItemStack());
        if (!GENERAL_CRAFTING_STAGES.isEmpty() && !GameStageHelper.hasAnyOf((EntityPlayer)event.getPlayer(), GENERAL_CRAFTING_STAGES)) {
            event.setCanceled("You can not craft any Tinkers Construct tools at this time. Further progression is needed.");
            return;
        }
        if (TOOL_CRAFTING_STAGES.containsKey((Object)itemId) && !GameStageHelper.hasAnyOf((EntityPlayer)event.getPlayer(), (Collection)TOOL_CRAFTING_STAGES.get((Object)itemId))) {
            event.setCanceled("You can not craft the " + event.getItemStack().func_82833_r() + " at this time. Further progression is needed.");
            return;
        }
        for (ItemStack part : event.getToolParts()) {
            if (part.func_190926_b()) continue;
            Material material = TinkerUtil.getMaterialFromStack((ItemStack)part);
            if (!TOOL_MATERIAL_STAGES.containsKey((Object)material.identifier) || GameStageHelper.hasAnyOf((EntityPlayer)event.getPlayer(), (Collection)TOOL_MATERIAL_STAGES.get((Object)material.identifier))) continue;
            event.setCanceled("You can not use the " + part.func_82833_r() + " in tools yet. Further progression is needed for " + material.getLocalizedName() + " tools.");
            return;
        }
    }

    @SubscribeEvent
    public void onToolPartSwap(TinkerCraftingEvent.ToolPartReplaceEvent event) {
        if (!GENERAL_PART_REPLACING_STAGES.isEmpty() && !GameStageHelper.hasAnyOf((EntityPlayer)event.getPlayer(), GENERAL_PART_REPLACING_STAGES)) {
            event.setCanceled("You can not swap any tool parts at this time. Further progression is needed.");
            return;
        }
        for (ItemStack part : event.getToolParts()) {
            if (part.func_190926_b()) continue;
            Material material = TinkerUtil.getMaterialFromStack((ItemStack)part);
            if (!TOOL_MATERIAL_STAGES.containsKey((Object)material.identifier) || GameStageHelper.hasAnyOf((EntityPlayer)event.getPlayer(), (Collection)TOOL_MATERIAL_STAGES.get((Object)material.identifier))) continue;
            event.setCanceled("You can not use the " + part.func_82833_r() + " for tools yet. Further progression is needed.");
            return;
        }
    }

    @SubscribeEvent
    public void onToolPartCrafted(TinkerCraftingEvent.ToolPartCraftingEvent event) {
        Material material = TinkerUtil.getMaterialFromStack((ItemStack)event.getItemStack());
        if (!GENERAL_PART_BUILDING_STAGES.isEmpty() && !GameStageHelper.hasAnyOf((EntityPlayer)event.getPlayer(), GENERAL_PART_BUILDING_STAGES)) {
            event.setCanceled("You can not build any tool parts at this time. Further progression is needed.");
            return;
        }
        if (TOOL_MATERIAL_STAGES.containsKey((Object)material.identifier) && !GameStageHelper.hasAnyOf((EntityPlayer)event.getPlayer(), (Collection)TOOL_MATERIAL_STAGES.get((Object)material.identifier))) {
            event.setCanceled("You can not make parts from " + material.getLocalizedName() + " yet. Further progression is needed.");
            return;
        }
    }

    @SubscribeEvent
    public void onToolModified(TinkerCraftingEvent.ToolModifyEvent event) {
        if (!GENERAL_MODIFIER_STAGES.isEmpty() && !GameStageHelper.hasAnyOf((EntityPlayer)event.getPlayer(), GENERAL_MODIFIER_STAGES)) {
            event.setCanceled("You can not apply any tool modifiers at this time. Further progression is needed.");
            return;
        }
        for (IModifier modifier : event.getModifiers()) {
            if (!TOOL_MODIFIER_STAGES.containsKey((Object)modifier.getIdentifier()) || GameStageHelper.hasAnyOf((EntityPlayer)event.getPlayer(), (Collection)TOOL_MODIFIER_STAGES.get((Object)modifier.getIdentifier()))) continue;
            event.setCanceled("You can not apply the " + modifier.getLocalizedName() + " modifier at this time. Further progression is needed.");
            return;
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer && !event.getEntityLiving().field_70170_p.field_72995_K) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            IStageData stageData = GameStageHelper.getPlayerData((EntityPlayer)player);
            ItemStack stack = player.func_184614_ca();
            String itemId = StackUtils.getStackIdentifier((ItemStack)stack);
            if (stageData != null && !stack.func_190926_b()) {
                if (TOOL_CRAFTING_STAGES.containsKey((Object)itemId) && !GameStageHelper.hasAnyOf((EntityPlayer)player, (IStageData)stageData, (Collection)TOOL_CRAFTING_STAGES.get((Object)itemId))) {
                    player.func_145747_a((ITextComponent)new TextComponentString("You dropped the " + stack.func_82833_r() + "! Further progression is needed to wield this type of tool."));
                    player.func_71040_bB(true);
                    return;
                }
                for (Material material : TinkerUtil.getMaterialsFromTagList((NBTTagList)TagUtil.getBaseMaterialsTagList((ItemStack)stack))) {
                    if (!TOOL_MATERIAL_STAGES.containsKey((Object)material.identifier) || GameStageHelper.hasAnyOf((EntityPlayer)player, (IStageData)stageData, (Collection)TOOL_MATERIAL_STAGES.get((Object)material.identifier))) continue;
                    player.func_145747_a((ITextComponent)new TextComponentString("You dropped the " + stack.func_82833_r() + "! Further progression is needed to wield " + material.getLocalizedName() + " tools."));
                    player.func_71040_bB(true);
                    return;
                }
                for (IModifier modifier : TinkerUtil.getModifiers((ItemStack)stack)) {
                    if (!TOOL_MODIFIER_STAGES.containsKey((Object)modifier.getIdentifier()) || GameStageHelper.hasAnyOf((EntityPlayer)player, (IStageData)stageData, (Collection)TOOL_MODIFIER_STAGES.get((Object)modifier.getIdentifier()))) continue;
                    player.func_145747_a((ITextComponent)new TextComponentString("You dropped the " + stack.func_82833_r() + "! Further progression is needed to use the " + modifier.getLocalizedName() + " modifier."));
                    player.func_71040_bB(true);
                    return;
                }
            }
        }
    }
}

