/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearningbm.util;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import xt9.deepmoblearning.DeepConstants;
import xt9.deepmoblearning.common.Registry;
import xt9.deepmoblearningbm.ModConfig;

public class Catalyst {
    public static NonNullList<Catalyst> catalysts = NonNullList.func_191196_a();
    private ItemStack stack;
    private double multiplier;
    private int operations;

    private Catalyst(Item item, double multiplier, int operations) {
        this.stack = new ItemStack(item);
        this.multiplier = multiplier;
        this.operations = operations;
    }

    public static void init() {
        Catalyst.addCatalyst((Item)Registry.livingMatterOverworldian, ModConfig.essenceMultiplierSubCat.getOverworldianCatalystMultiplier(), 10);
        Catalyst.addCatalyst((Item)Registry.livingMatterHellish, ModConfig.essenceMultiplierSubCat.getHellishCatalystMultiplier(), 10);
        Catalyst.addCatalyst((Item)Registry.livingMatterExtraterrestrial, ModConfig.essenceMultiplierSubCat.getExtraterrestrialCatalystMultiplier(), 10);
        Catalyst.addCatalyst((Item)Registry.glitchHeart, ModConfig.essenceMultiplierSubCat.getHeartCatalystMultiplier(), 100);
        if (DeepConstants.MOD_TWILIGHT_LOADED) {
            Catalyst.addCatalyst((Item)Registry.livingMatterTwilight, ModConfig.essenceMultiplierSubCat.getTwilightCatalystMultiplier(), 10);
        }
    }

    public static void addCatalyst(Item item, double multiplier, int operations) {
        catalysts.add((Object)new Catalyst(item, multiplier, operations));
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public int getOperations() {
        return this.operations;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public static Catalyst getCatalyst(ItemStack stack) {
        for (Catalyst catalyst : catalysts) {
            if (!ItemStack.func_179545_c((ItemStack)catalyst.stack, (ItemStack)stack)) continue;
            return catalyst;
        }
        return null;
    }

    public static boolean isValidCatalyst(ItemStack stack) {
        for (Catalyst catalyst : catalysts) {
            if (!ItemStack.func_179545_c((ItemStack)catalyst.stack, (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }
}

