/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearningbm.common.tile;

import WayofTime.bloodmagic.altar.AltarUpgrade;
import WayofTime.bloodmagic.altar.BloodAltar;
import WayofTime.bloodmagic.block.enums.BloodRuneType;
import WayofTime.bloodmagic.tile.TileAltar;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import xt9.deepmoblearning.common.energy.DeepEnergyStorage;
import xt9.deepmoblearning.common.handlers.BaseItemHandler;
import xt9.deepmoblearning.common.handlers.DataModelHandler;
import xt9.deepmoblearning.common.items.ItemDataModel;
import xt9.deepmoblearning.common.util.DataModel;
import xt9.deepmoblearningbm.DeepMobLearningBM;
import xt9.deepmoblearningbm.ModConfig;
import xt9.deepmoblearningbm.client.gui.DigitalAgonizerGui;
import xt9.deepmoblearningbm.common.inventory.CatalystInputHandler;
import xt9.deepmoblearningbm.common.inventory.ContainerDigitalAgonizer;
import xt9.deepmoblearningbm.common.tile.IContainerProvider;
import xt9.deepmoblearningbm.util.Catalyst;
import xt9.deepmoblearningbm.util.EssenceHelper;

public class TileEntityDigitalAgonizer
extends TileEntity
implements ITickable,
IContainerProvider {
    public static final int GUI_ID = 1;
    private BaseItemHandler dataModel = new DataModelHandler();
    private BaseItemHandler input = new CatalystInputHandler();
    private DeepEnergyStorage energyCap = new DeepEnergyStorage(100000, 25600, 0, 0);
    private int highlightingTicks = 0;
    private int catalystOperations = 0;
    private int catalystOperationsMax = 0;
    private int saveTicks = 0;
    private int progress = 0;
    private BlockPos altarPos = BlockPos.func_177969_a((long)0L);
    private int numOfSacrificeRunes = 0;
    private double multiplier = 1.0;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.saveTicks;
            if (this.highlightingTicks > 0) {
                --this.highlightingTicks;
                if (this.highlightingTicks == 0) {
                    this.updateState(true);
                }
            }
            if (this.catalystOperations == 0) {
                this.consumeCatalyst();
            }
            if (this.canContinueCraft()) {
                if (this.progress == 0) {
                    this.updateSacrificeRuneCount();
                }
                ++this.progress;
                this.energyCap.voidEnergy(ModConfig.getAgonizerRFCost());
                if (this.progress % 60 == 0) {
                    this.fillAltarTank();
                    this.progress = 0;
                }
            } else if (!this.hasDataModel() || !this.isValidDataModelTier()) {
                this.progress = 0;
            } else if (this.getAltarTank() == null) {
                this.setAltarPos(BlockPos.func_177969_a((long)0L));
                this.numOfSacrificeRunes = 0;
                this.progress = 0;
            }
            this.doStaggeredDiskSave(100);
        } else if (this.highlightingTicks > 0) {
            ThreadLocalRandom rand = ThreadLocalRandom.current();
            if (this.getAltarTank() != null) {
                DeepMobLearningBM.proxy.spawnParticle(this.field_145850_b, (double)this.getAltarPos().func_177958_n() + 0.5 + rand.nextDouble(-0.33, 0.33), (double)this.getAltarPos().func_177956_o() + 1.2, (double)this.getAltarPos().func_177952_p() + 0.5 + rand.nextDouble(-0.33, 0.33), rand.nextDouble(-0.02, 0.02), 0.0, rand.nextDouble(-0.02, 0.02));
            }
        }
    }

    public double getSacrificeMultiplier() {
        BloodAltar altar = this.getAltarTank();
        if (altar != null) {
            return altar.getSacrificeMultiplier();
        }
        return 0.0;
    }

    public void updateSacrificeRuneCount() {
        AltarUpgrade altarUpgrade;
        BloodAltar altar = this.getAltarTank();
        this.numOfSacrificeRunes = altar != null ? ((altarUpgrade = altar.getUpgrade()) != null ? altarUpgrade.getLevel(BloodRuneType.SACRIFICE) : 0) : 0;
    }

    private void fillAltarTank() {
        BloodAltar altar = this.getAltarTank();
        if (altar != null) {
            altar.fillMainTank(this.getFillAmount());
        }
        if (this.catalystOperations > 0) {
            --this.catalystOperations;
        } else {
            this.multiplier = 1.0;
        }
    }

    private void consumeCatalyst() {
        Catalyst catalyst = Catalyst.getCatalyst(this.getCatalystStack());
        if (catalyst != null) {
            this.catalystOperations = catalyst.getOperations();
            this.catalystOperationsMax = catalyst.getOperations();
            this.multiplier = catalyst.getMultiplier();
            this.getCatalystStack().func_190918_g(1);
        }
    }

    private boolean canContinueCraft() {
        return this.energyCap.getEnergyStored() > ModConfig.getAgonizerRFCost() && !this.altarIsFull() && this.hasDataModel() && this.isValidDataModelTier();
    }

    public BlockPos getAltarPos() {
        return this.altarPos;
    }

    public void setAltarPos(BlockPos pos) {
        this.altarPos = pos;
    }

    public BloodAltar getAltarTank() {
        if (this.altarPos != null) {
            TileEntity tile = this.field_145850_b.func_175625_s(this.altarPos);
            if (tile instanceof TileAltar) {
                return (BloodAltar)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
            }
            return null;
        }
        return null;
    }

    private boolean altarIsFull() {
        return this.getAltarTank() == null || this.getAltarTank().getFluidAmount() + this.getFillAmount() >= this.getAltarTank().getCapacity();
    }

    public void setHighlightingTicks(int highlightingTicks) {
        this.highlightingTicks = highlightingTicks;
        this.updateState(true);
    }

    public int getNumOfSacrificeRunes() {
        return this.numOfSacrificeRunes;
    }

    private ItemStack getCatalystStack() {
        return this.input.getStackInSlot(0);
    }

    private ItemStack getDataModelStack() {
        return this.dataModel.getStackInSlot(0);
    }

    public boolean hasDataModel() {
        return this.getDataModelStack().func_77973_b() instanceof ItemDataModel;
    }

    public boolean isValidDataModelTier() {
        return DataModel.getTier((ItemStack)this.getDataModelStack()) != 0;
    }

    public boolean hasValidCatalyst() {
        return Catalyst.isValidCatalyst(this.getCatalystStack());
    }

    public int getFillAmount() {
        return EssenceHelper.getFillAmount(this.getDataModelStack(), this.getMultiplier() + this.getSacrificeMultiplier());
    }

    public int getCatalystOperations() {
        return this.catalystOperations;
    }

    public int getCatalystOperationsMax() {
        return this.catalystOperationsMax;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public int getProgress() {
        return this.progress;
    }

    private void doStaggeredDiskSave(int divisor) {
        if (this.saveTicks % divisor == 0) {
            this.func_70296_d();
            this.saveTicks = 0;
        }
    }

    public void updateState(boolean markDirty) {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
        if (markDirty) {
            this.func_70296_d();
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 3, this.func_189515_b(new NBTTagCompound()));
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("highlightingTicks", this.highlightingTicks);
        compound.func_74768_a("catalystOperations", this.catalystOperations);
        compound.func_74768_a("catalystOperationsMax", this.catalystOperationsMax);
        compound.func_74768_a("progress", this.progress);
        compound.func_74780_a("mutliplier", this.multiplier);
        compound.func_74772_a("altarPos", this.altarPos.func_177986_g());
        compound.func_74768_a("numOfSacrificeRunes", this.numOfSacrificeRunes);
        compound.func_74782_a("dataModel", (NBTBase)this.dataModel.serializeNBT());
        compound.func_74782_a("input", (NBTBase)this.input.serializeNBT());
        this.energyCap.writeEnergy(compound);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.highlightingTicks = compound.func_150297_b("highlightingTicks", 3) ? compound.func_74762_e("highlightingTicks") : 0;
        this.catalystOperations = compound.func_150297_b("catalystOperations", 3) ? compound.func_74762_e("catalystOperations") : 0;
        this.catalystOperationsMax = compound.func_150297_b("catalystOperationsMax", 3) ? compound.func_74762_e("catalystOperationsMax") : 0;
        this.progress = compound.func_150297_b("progress", 3) ? compound.func_74762_e("progress") : 0;
        this.multiplier = compound.func_150297_b("mutliplier", 6) ? compound.func_74769_h("mutliplier") : 1.0;
        this.numOfSacrificeRunes = compound.func_150297_b("numOfSacrificeRunes", 3) ? compound.func_74762_e("numOfSacrificeRunes") : 0;
        this.altarPos = compound.func_150297_b("altarPos", 4) ? BlockPos.func_177969_a((long)compound.func_74763_f("altarPos")) : null;
        this.dataModel.deserializeNBT(compound.func_74775_l("dataModel"));
        this.input.deserializeNBT(compound.func_74775_l("input"));
        this.energyCap.readEnergy(compound);
        super.func_145839_a(compound);
    }

    public boolean hasCapability(Capability capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new CombinedInvWrapper(new IItemHandlerModifiable[]{this.dataModel, this.input}));
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.energyCap);
        }
        return (T)super.getCapability(capability, facing);
    }

    public ContainerDigitalAgonizer getContainer(TileEntity entity, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerDigitalAgonizer((TileEntityDigitalAgonizer)world.func_175625_s(new BlockPos(x, y, z)), player.field_71071_by, world);
    }

    public DigitalAgonizerGui getGui(TileEntity entity, EntityPlayer player, World world, int x, int y, int z) {
        return new DigitalAgonizerGui((TileEntityDigitalAgonizer)world.func_175625_s(new BlockPos(x, y, z)), player.field_71071_by, world);
    }
}

