/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearningbm;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import xt9.deepmoblearningbm.util.MathHelper;

@Mod.EventBusSubscriber
@Config(modid="deepmoblearningbm")
public class ModConfig {
    @Config.Name(value="Essence Multiplier Settings")
    public static CatalystMultiplierSubCategory essenceMultiplierSubCat = new CatalystMultiplierSubCategory();
    @Config.Name(value="Essence Base Amounts")
    public static EssenceBaseAmountsSubCategory essenceAmountSubCat = new EssenceBaseAmountsSubCategory();
    @Config.Comment(value={"Max: 10,000", "Default: 128"})
    @Config.Name(value="RF tick cost of the Digital Agonizer")
    @Config.RangeInt(min=1, max=10000)
    public static int agonizerRFCost = 128;
    @Config.Comment(value={"Default: false"})
    @Config.Name(value="Allow multiple agonizers linked with one Altar")
    public static boolean isMultipleAgonizersAllowed = false;

    @SubscribeEvent
    public static void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("deepmoblearningbm")) {
            ConfigManager.sync((String)"deepmoblearningbm", (Config.Type)Config.Type.INSTANCE);
        }
    }

    public static int getAgonizerRFCost() {
        return MathHelper.ensureRange(agonizerRFCost, 1, 10000);
    }

    public static class CatalystMultiplierSubCategory {
        @Config.Comment(value={"Default: 5.0"})
        @Config.Name(value="#1 Multiplier of Corrupted Glitch Heart")
        @Config.RangeDouble(min=1.0, max=10.0)
        public double heartCatalystMultiplier = 5.0;
        @Config.Comment(value={"Default: 2.2"})
        @Config.Name(value="#2 Multiplier of Overworldian Living matter")
        @Config.RangeDouble(min=1.0, max=10.0)
        public double overworldianCatalystMultiplier = 2.2;
        @Config.Comment(value={"Default: 2.4"})
        @Config.Name(value="#3 Multiplier of Hellish Living matter")
        @Config.RangeDouble(min=1.0, max=10.0)
        public double hellishCatalystMultiplier = 2.4;
        @Config.Comment(value={"Default: 2.7"})
        @Config.Name(value="#4 Multiplier of Extraterrestrial Living matter")
        @Config.RangeDouble(min=1.0, max=10.0)
        public double extraterrestrialCatalystMultiplier = 2.7;
        @Config.Comment(value={"Default: 2.5"})
        @Config.Name(value="#5 Multiplier of Twilight Living matter")
        @Config.RangeDouble(min=1.0, max=10.0)
        public double twilightCatalystMultiplier = 2.5;

        public double getHeartCatalystMultiplier() {
            return MathHelper.ensureRange(this.heartCatalystMultiplier, 1.0, 10.0);
        }

        public double getOverworldianCatalystMultiplier() {
            return MathHelper.ensureRange(this.overworldianCatalystMultiplier, 1.0, 10.0);
        }

        public double getHellishCatalystMultiplier() {
            return MathHelper.ensureRange(this.hellishCatalystMultiplier, 1.0, 10.0);
        }

        public double getExtraterrestrialCatalystMultiplier() {
            return MathHelper.ensureRange(this.extraterrestrialCatalystMultiplier, 1.0, 10.0);
        }

        public double getTwilightCatalystMultiplier() {
            return MathHelper.ensureRange(this.twilightCatalystMultiplier, 1.0, 10.0);
        }
    }

    public static class EssenceBaseAmountsSubCategory {
        @Config.Comment(value={"Default: 50"})
        @Config.Name(value="Tier 1 Data Model - Essence per operation")
        @Config.RangeInt(min=1, max=2000)
        public int tierOneEssenceAmount = 50;
        @Config.Comment(value={"Default: 75"})
        @Config.Name(value="Tier 2 Data Model - Essence per operation")
        @Config.RangeInt(min=1, max=2000)
        public int tierTwoEssenceAmount = 75;
        @Config.Comment(value={"Default: 150"})
        @Config.Name(value="Tier 3 Data Model - Essence per operation")
        @Config.RangeInt(min=1, max=2000)
        public int tierThreeEssenceAmount = 150;
        @Config.Comment(value={"Default: 300"})
        @Config.Name(value="Tier 4 Data Model - Essence per operation")
        @Config.RangeInt(min=1, max=2000)
        public int tierFourEssenceAmount = 300;

        public int getTierEssenceAmount(int tier) {
            switch (tier) {
                case 1: {
                    return MathHelper.ensureRange(this.tierOneEssenceAmount, 1, 2000);
                }
                case 2: {
                    return MathHelper.ensureRange(this.tierTwoEssenceAmount, 1, 2000);
                }
                case 3: {
                    return MathHelper.ensureRange(this.tierThreeEssenceAmount, 1, 2000);
                }
                case 4: {
                    return MathHelper.ensureRange(this.tierFourEssenceAmount, 1, 2000);
                }
            }
            return 1;
        }
    }
}

