/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.util;

import astavie.thermallogistics.client.gui.GuiCrafter;
import astavie.thermallogistics.client.gui.element.ElementSlotFluid;
import astavie.thermallogistics.client.gui.element.ElementSlotItem;
import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.element.ElementBase;
import cofh.core.network.PacketBase;
import cofh.core.util.helpers.RenderHelper;
import cofh.core.util.helpers.StringHelper;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class StackHandler {
    public static void writePacket(PacketBase packet, Object item, Class<?> c, boolean identifier) {
        if (c == ItemStack.class) {
            if (identifier) {
                packet.addByte(0);
            }
            packet.addItemStack((ItemStack)item);
        } else if (c == FluidStack.class) {
            if (identifier) {
                packet.addByte(1);
            }
            packet.addFluidStack((FluidStack)item);
        } else {
            throw new IllegalArgumentException("Unknown item type " + c.getName());
        }
    }

    public static <I> I readPacket(PacketBase packet) {
        byte type = packet.getByte();
        if (type == 0) {
            return (I)packet.getItemStack();
        }
        if (type == 1) {
            return (I)packet.getFluidStack();
        }
        throw new IllegalArgumentException("Unknown item type " + type);
    }

    @SideOnly(value=Side.CLIENT)
    public static void render(GuiContainerCore gui, int x, int y, Object item, boolean count) {
        if (item instanceof ItemStack) {
            ItemStack stack = (ItemStack)item;
            FontRenderer font = null;
            if (!stack.func_190926_b()) {
                font = stack.func_77973_b().getFontRenderer(stack);
            }
            if (font == null) {
                font = gui.getFontRenderer();
            }
            RenderHelper.enableGUIStandardItemLighting();
            gui.field_146296_j.func_180450_b(stack, x, y);
            gui.field_146296_j.func_180453_a(font, stack, x, y - (gui.field_147012_x.func_190926_b() ? 0 : 8), count ? null : "");
        } else if (item instanceof FluidStack) {
            FluidStack fluid = (FluidStack)item;
            GlStateManager.func_179140_f();
            gui.drawFluid(x, y, fluid, 16, 16);
            if (count) {
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
                GlStateManager.func_179084_k();
                GlStateManager.func_179094_E();
                GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
                String amount = StringHelper.formatNumber((long)fluid.amount);
                gui.getFontRenderer().func_175063_a(amount, (float)((x + 16) * 2 - gui.getFontRenderer().func_78256_a(amount)), (float)((y + 12) * 2), 0xFFFFFF);
                GlStateManager.func_179121_F();
                GlStateManager.func_179145_e();
                GlStateManager.func_179126_j();
            }
        } else {
            throw new IllegalArgumentException("Unknown item type " + item.getClass().getName());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void render(GuiContainerCore gui, int x, int y, Object item, String text) {
        if (item instanceof ItemStack) {
            gui.drawItemStack((ItemStack)item, x, y, true, "");
        } else if (item instanceof FluidStack) {
            gui.drawFluid(x, y, (FluidStack)item, 16, 16);
        } else {
            throw new IllegalArgumentException("Unknown item type " + item.getClass().getName());
        }
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179084_k();
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
        gui.getFontRenderer().func_175063_a(text, (float)((x + 16) * 2 - gui.getFontRenderer().func_78256_a(text)), (float)((y + 12) * 2), 0xFFFFFF);
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
    }

    @SideOnly(value=Side.CLIENT)
    public static List<String> getTooltip(GuiContainerCore gui, Object item) {
        if (item instanceof ItemStack) {
            return gui.func_191927_a((ItemStack)item);
        }
        if (item instanceof FluidStack) {
            return Collections.singletonList(((FluidStack)item).getLocalizedName());
        }
        throw new IllegalArgumentException("Unknown item type " + item.getClass().getName());
    }

    @SideOnly(value=Side.CLIENT)
    public static ElementBase getSlot(GuiContainerCore gui, int x, int y, GuiCrafter.Slot<?> slot) {
        Class<?> c = slot.getCrafter().getItemClass();
        if (c == ItemStack.class) {
            return new ElementSlotItem(gui, x, y, slot, slot, true);
        }
        if (c == FluidStack.class) {
            return new ElementSlotFluid(gui, x, y, slot, slot, true);
        }
        throw new IllegalArgumentException("Unknown item type " + c.getName());
    }
}

