/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.block;

import astavie.thermallogistics.ThermalLogistics;
import astavie.thermallogistics.tile.TileTerminal;
import cofh.core.block.BlockCoreTile;
import cofh.core.block.TileNameable;
import cofh.core.render.IModelRegister;
import cofh.core.util.CoreUtils;
import cofh.core.util.RayTracer;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.core.util.helpers.WrenchHelper;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BlockTerminal
extends BlockCoreTile
implements IModelRegister {
    public static final PropertyEnum<Direction> DIRECTION = PropertyEnum.func_177706_a((String)"direction", Direction.class, (Enum[])Direction.values());
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");

    public BlockTerminal(String name, String type) {
        super(Material.field_151573_f, "logistics");
        this.func_149663_c(name + "." + type);
        this.name = name + "_" + type;
        this.setRegistryName(this.name);
        this.func_149647_a(ThermalLogistics.INSTANCE.tab);
        this.func_149711_c(15.0f);
        this.func_149752_b(25.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)).func_177226_a(DIRECTION, (Comparable)((Object)Direction.NORTH)));
    }

    @Nonnull
    public IBlockState getStateForPlacement(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a(DIRECTION, (Comparable)((Object)Direction.getDirection(pos, placer)));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase living, ItemStack stack) {
        TileTerminal tile = (TileTerminal)world.func_175625_s(pos);
        tile.setCustomName(ItemHelper.getNameFromItemStack((ItemStack)stack));
        if (stack.func_77978_p() != null) {
            tile.requester.set(new ItemStack(stack.func_77978_p().func_74775_l("requester")));
        }
        super.func_180633_a(world, pos, state, living, stack);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem;
        RayTraceResult traceResult = RayTracer.retrace((EntityPlayer)player);
        if (traceResult == null) {
            return false;
        }
        PlayerInteractEvent.RightClickBlock event = new PlayerInteractEvent.RightClickBlock(player, hand, pos, side, traceResult.field_72307_f);
        if (MinecraftForge.EVENT_BUS.post((Event)event) || event.getResult() == Event.Result.DENY) {
            return false;
        }
        if (player.func_70093_af() && WrenchHelper.isHoldingUsableWrench((EntityPlayer)player, (RayTraceResult)traceResult)) {
            if (ServerHelper.isServerWorld((World)world) && this.canDismantle(world, pos, state, player)) {
                this.dismantleBlock(world, pos, state, player, false);
                WrenchHelper.usedWrench((EntityPlayer)player, (RayTraceResult)traceResult);
            }
            return true;
        }
        TileNameable tile = (TileNameable)world.func_175625_s(pos);
        if (tile == null || tile.func_145837_r()) {
            return false;
        }
        if (WrenchHelper.isHoldingUsableWrench((EntityPlayer)player, (RayTraceResult)traceResult)) {
            if (tile.canPlayerAccess(player)) {
                if (ServerHelper.isServerWorld((World)world)) {
                    tile.onWrench(player, side);
                }
                WrenchHelper.usedWrench((EntityPlayer)player, (RayTraceResult)traceResult);
            }
            return true;
        }
        if (!tile.canPlayerAccess(player)) {
            return false;
        }
        if (tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) && FluidHelper.isFluidHandler((ItemStack)(heldItem = player.func_184586_b(hand)))) {
            FluidHelper.interactWithHandler((ItemStack)heldItem, (IFluidHandler)((IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)), (EntityPlayer)player, (EnumHand)hand);
            return true;
        }
        return !ServerHelper.isServerWorld((World)world) || tile.openGui(player);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(DIRECTION, (Comparable)((Object)Direction.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((Direction)((Object)state.func_177229_b(DIRECTION))).ordinal();
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ACTIVE, DIRECTION});
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        CoreUtils.dropItemStackIntoWorldWithVelocity((ItemStack)((TileTerminal)world.func_175625_s((BlockPos)pos)).requester.get(), (World)world, (BlockPos)pos);
        super.func_180663_b(world, pos, state);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)this));
    }

    public ArrayList<ItemStack> dropDelegate(NBTTagCompound nbt, IBlockAccess world, BlockPos pos, int fortune) {
        return new ArrayList<ItemStack>(Collections.singleton(new ItemStack(Item.func_150898_a((Block)this))));
    }

    public NBTTagCompound getItemStackTag(IBlockAccess world, BlockPos pos) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("requester", (NBTBase)((TileTerminal)world.func_175625_s((BlockPos)pos)).requester.get().func_77955_b(new NBTTagCompound()));
        return tag;
    }

    public ArrayList<ItemStack> dismantleBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player, boolean returnDrops) {
        NBTTagCompound nbt = this.getItemStackTag((IBlockAccess)world, pos);
        ((TileTerminal)world.func_175625_s((BlockPos)pos)).requester.set(ItemStack.field_190927_a);
        return this.dismantleDelegate(nbt, world, pos, player, returnDrops, false);
    }

    public ArrayList<ItemStack> dismantleDelegate(NBTTagCompound nbt, World world, BlockPos pos, EntityPlayer player, boolean returnDrops, boolean simulate) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (world.func_180495_p(pos).func_177230_c() != this) {
            return ret;
        }
        ItemStack dropBlock = new ItemStack(Item.func_150898_a((Block)this));
        if (nbt != null && !nbt.func_82582_d()) {
            dropBlock.func_77982_d(nbt);
        }
        ret.add(dropBlock);
        if (!simulate) {
            world.func_175698_g(pos);
            if (!returnDrops) {
                float f = 0.3f;
                double x2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double y2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double z2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem dropEntity = new EntityItem(world, (double)pos.func_177958_n() + x2, (double)pos.func_177956_o() + y2, (double)pos.func_177952_p() + z2, dropBlock);
                dropEntity.func_174867_a(10);
                world.func_72838_d((Entity)dropEntity);
                if (player != null) {
                    CoreUtils.dismantleLog((String)player.func_70005_c_(), (Block)this, (int)0, (BlockPos)pos);
                }
            }
        }
        return ret;
    }

    public boolean preInit() {
        return true;
    }

    public boolean initialize() {
        return true;
    }

    public void registerModels() {
        ModelResourceLocation location = new ModelResourceLocation("thermallogistics:" + this.name);
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)location);
    }

    public static enum Direction implements IStringSerializable
    {
        UP_NORTH,
        UP_SOUTH,
        UP_WEST,
        UP_EAST,
        NORTH,
        SOUTH,
        WEST,
        EAST,
        DOWN_NORTH,
        DOWN_SOUTH,
        DOWN_WEST,
        DOWN_EAST;

        private final String name = this.toString().toLowerCase();

        public static Direction getDirection(BlockPos pos, EntityLivingBase placer) {
            return Direction.getDirection(EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer), placer.func_174811_aO().func_176734_d());
        }

        public static Direction getDirection(EnumFacing vertical, EnumFacing horizontal) {
            if (vertical == EnumFacing.UP) {
                switch (horizontal) {
                    case NORTH: {
                        return UP_NORTH;
                    }
                    case SOUTH: {
                        return UP_SOUTH;
                    }
                    case WEST: {
                        return UP_WEST;
                    }
                    case EAST: {
                        return UP_EAST;
                    }
                }
            } else if (vertical == EnumFacing.DOWN) {
                switch (horizontal) {
                    case NORTH: {
                        return DOWN_NORTH;
                    }
                    case SOUTH: {
                        return DOWN_SOUTH;
                    }
                    case WEST: {
                        return DOWN_WEST;
                    }
                    case EAST: {
                        return DOWN_EAST;
                    }
                }
            } else {
                switch (horizontal) {
                    case NORTH: {
                        return NORTH;
                    }
                    case SOUTH: {
                        return SOUTH;
                    }
                    case WEST: {
                        return WEST;
                    }
                    case EAST: {
                        return EAST;
                    }
                }
            }
            return NORTH;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public EnumFacing getFace() {
            if (this.ordinal() > 7) {
                return EnumFacing.DOWN;
            }
            return EnumFacing.func_82600_a((int)MathHelper.clamp((int)(this.ordinal() - 2), (int)1, (int)5));
        }
    }
}

