/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.attachment;

import astavie.thermallogistics.ThermalLogistics;
import astavie.thermallogistics.attachment.ICrafter;
import astavie.thermallogistics.attachment.IRequester;
import astavie.thermallogistics.client.TLTextures;
import astavie.thermallogistics.client.gui.GuiCrafter;
import astavie.thermallogistics.compat.ICrafterWrapper;
import astavie.thermallogistics.container.ContainerCrafter;
import astavie.thermallogistics.process.Process;
import astavie.thermallogistics.process.ProcessItem;
import astavie.thermallogistics.process.Request;
import astavie.thermallogistics.process.RequestItem;
import astavie.thermallogistics.util.RequesterReference;
import astavie.thermallogistics.util.StackHandler;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import cofh.core.util.helpers.BlockHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.thermaldynamics.ThermalDynamics;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.attachments.servo.ServoItem;
import cofh.thermaldynamics.duct.item.DuctUnitItem;
import cofh.thermaldynamics.duct.item.GridItem;
import cofh.thermaldynamics.duct.item.StackMap;
import cofh.thermaldynamics.duct.item.TravelingItem;
import cofh.thermaldynamics.duct.tiles.DuctUnit;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.multiblock.IGridTile;
import cofh.thermaldynamics.multiblock.IGridTileRoute;
import cofh.thermaldynamics.multiblock.Route;
import cofh.thermaldynamics.render.RenderDuct;
import cofh.thermaldynamics.util.ListWrapper;
import com.google.common.primitives.Ints;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public class CrafterItem
extends ServoItem
implements ICrafter<ItemStack> {
    public static final ResourceLocation ID = new ResourceLocation("thermallogistics", "crafter_item");
    public static final int[] SIZE = new int[]{1, 2, 3, 4, 6};
    public static final int[][] SPLITS = new int[][]{{1}, {2, 1}, {3, 1}, {4, 2, 1}, {6, 3, 2, 1}};
    private final List<ICrafter.Recipe<ItemStack>> recipes = NonNullList.func_191196_a();
    private final List<RequesterReference<?>> linked = NonNullList.func_191196_a();
    private final ProcessItem process = new ProcessItem(this);
    private final RequestItem sent = new RequestItem(null);

    public CrafterItem(TileGrid tile, byte side, int type) {
        super(tile, side, type);
        ICrafter.Recipe<ItemStack> recipe = new ICrafter.Recipe<ItemStack>(new RequestItem(null));
        recipe.inputs.addAll(Collections.nCopies(SIZE[type] * 2, ItemStack.field_190927_a));
        recipe.outputs.addAll(Collections.nCopies(SIZE[type], ItemStack.field_190927_a));
        this.recipes.add(recipe);
    }

    public CrafterItem(TileGrid tile, byte side) {
        super(tile, side);
    }

    public boolean canSend() {
        return false;
    }

    public boolean allowDuctConnection() {
        return true;
    }

    public String getInfo() {
        return "tab.thermallogistics.crafterItem";
    }

    public ResourceLocation getId() {
        return ID;
    }

    public ItemStack getPickBlock() {
        return new ItemStack((Item)ThermalLogistics.Items.crafter, 1, this.type);
    }

    public String getName() {
        return this.getPickBlock().func_77977_a() + ".name";
    }

    public boolean render(IBlockAccess world, BlockRenderLayer layer, CCRenderState ccRenderState) {
        if (layer != BlockRenderLayer.SOLID) {
            return false;
        }
        Translation trans = Vector3.fromTileCenter((TileEntity)this.baseTile).translation();
        RenderDuct.modelConnection[this.isPowered ? 1 : 2][this.side].render(ccRenderState, new IVertexOperation[]{trans, new IconTransformation(TLTextures.CRAFTER[this.stuffed ? 1 : 0][this.type])});
        return true;
    }

    private void checkLinked() {
        Iterator<RequesterReference<?>> iterator = this.linked.iterator();
        while (iterator.hasNext()) {
            IRequester<?> requester = iterator.next().getAttachment();
            if (!(requester instanceof ICrafter)) {
                iterator.remove();
                this.markDirty();
                continue;
            }
            ICrafter crafter = (ICrafter)requester;
            if (crafter.hasLinked(this)) continue;
            iterator.remove();
            this.markDirty();
        }
    }

    public void tick(int pass) {
        if (pass == 0 && ((DuctUnitItem.Cache[])this.itemDuct.tileCache)[this.side] != null && !(((DuctUnitItem.Cache[])this.itemDuct.tileCache)[this.side] instanceof CacheWrapper)) {
            ((DuctUnitItem.Cache[])this.itemDuct.tileCache)[this.side] = new CacheWrapper(((DuctUnitItem.Cache[])this.itemDuct.tileCache)[this.side].tile, this);
        }
        super.tick(pass);
    }

    public ItemStack insertItem(ItemStack item, boolean simulate) {
        int count;
        int max = Math.min(this.getMaxSend(), item.func_190916_E());
        int send = 0;
        block0: for (int i = 0; i < this.recipes.size(); ++i) {
            ICrafter.Recipe<ItemStack> recipe = this.recipes.get(i);
            Iterator<Request<ItemStack>> iterator = recipe.requests.iterator();
            while (iterator.hasNext()) {
                IRequester<ItemStack> attachment;
                Request<ItemStack> request = iterator.next();
                count = Math.min(request.getCount(item), max - send);
                if (count == 0 || (attachment = request.attachment.getAttachment()) == null) continue;
                DuctUnitItem duct = (DuctUnitItem)attachment.getDuct();
                int left = duct.canRouteItem(ItemHelper.cloneStack((ItemStack)item, (int)count), attachment.getSide());
                if (left == -1) {
                    max -= count;
                    continue;
                }
                max -= left;
                if ((count -= left) == 0) continue;
                Route route = this.itemDuct.getRoute((IGridTileRoute)duct);
                if (route == null) {
                    max -= count;
                    continue;
                }
                if (!simulate) {
                    ItemStack removed = ItemHelper.cloneStack((ItemStack)item, (int)count);
                    route = route.copy();
                    route.pathDirections.add(attachment.getSide());
                    this.itemDuct.insertNewItem(new TravelingItem(removed, (IGridTile)this.itemDuct, route, (byte)(this.side ^ 1), attachment.getSpeed()));
                    this.onFinishCrafting(recipe, i, iterator, request, removed);
                    attachment.claim(this, removed);
                }
                if ((send += count) != max) continue;
                break block0;
            }
        }
        if (send < max) {
            ItemStack remain = super.insertItem(ItemHelper.cloneStack((ItemStack)item, (int)(max - send)), simulate);
            int leftover = max - send - remain.func_190916_E();
            send += leftover;
            if (!simulate && leftover > 0) {
                for (ICrafter.Recipe<ItemStack> recipe : this.recipes) {
                    count = Math.min(recipe.leftovers.getCount(item), leftover);
                    if (count == 0) continue;
                    recipe.leftovers.decreaseStack(ItemHelper.cloneStack((ItemStack)item, (int)count));
                    if ((leftover -= count) != 0) continue;
                    break;
                }
            }
        }
        return ItemHelper.cloneStack((ItemStack)item, (int)(item.func_190916_E() - send));
    }

    public void handleItemSending() {
        this.checkLinked();
        boolean changed = false;
        for (ICrafter.Recipe<ItemStack> recipe : this.recipes) {
            changed |= ProcessItem.checkRequests(this, recipe.requests, IRequester::getInputFrom);
        }
        if (changed) {
            HashSet<ItemStack> set = new HashSet<ItemStack>();
            block1: for (ItemStack stack : this.process.getStacks()) {
                for (ItemStack compare : set) {
                    if (!this.itemsIdentical(stack, compare)) continue;
                    compare.func_190917_f(stack.func_190916_E());
                    continue block1;
                }
                set.add(stack.func_77946_l());
            }
            Map map = set.stream().collect(Collectors.toMap(Function.identity(), item -> Math.max(item.func_190916_E() - this.required((ItemStack)item, true), 0)));
            map.entrySet().removeIf(e -> (Integer)e.getValue() == 0);
            Iterator iterator = this.process.requests.iterator();
            while (iterator.hasNext() && !map.isEmpty()) {
                Request request = (Request)iterator.next();
                Iterator iterator1 = request.stacks.iterator();
                block4: while (iterator1.hasNext() && !map.isEmpty()) {
                    ItemStack stack = (ItemStack)iterator1.next();
                    Iterator iterator2 = map.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry entry = iterator2.next();
                        if (!this.itemsIdentical((ItemStack)entry.getKey(), stack)) continue;
                        int shrink = Math.min(stack.func_190916_E(), entry.getValue());
                        stack.func_190918_g(shrink);
                        entry.setValue(entry.getValue() - shrink);
                        if (stack.func_190926_b()) {
                            iterator1.remove();
                        }
                        if (entry.getValue() != 0) continue block4;
                        iterator2.remove();
                        continue block4;
                    }
                }
                if (!request.stacks.isEmpty()) continue;
                iterator.remove();
            }
        }
        this.process.tick();
    }

    public void onNeighborChange() {
        boolean wasPowered = this.isPowered;
        super.onNeighborChange();
        if (wasPowered && !this.isPowered) {
            this.process.requests.clear();
            this.sent.stacks.clear();
            for (ICrafter.Recipe<ItemStack> recipe : this.recipes) {
                recipe.requests.clear();
                recipe.leftovers.stacks.clear();
            }
        }
    }

    public void checkSignal() {
        boolean wasPowered = this.isPowered;
        super.checkSignal();
        if (wasPowered && !this.isPowered) {
            this.process.requests.clear();
            this.sent.stacks.clear();
            for (ICrafter.Recipe<ItemStack> recipe : this.recipes) {
                recipe.requests.clear();
                recipe.leftovers.stacks.clear();
            }
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        NBTTagList recipes = new NBTTagList();
        for (ICrafter.Recipe<ItemStack> recipe : this.recipes) {
            Object stack22;
            NBTTagList inputs = new NBTTagList();
            for (Object stack22 : recipe.inputs) {
                inputs.func_74742_a((NBTBase)stack22.func_77955_b(new NBTTagCompound()));
            }
            NBTTagList outputs = new NBTTagList();
            stack22 = recipe.outputs.iterator();
            while (stack22.hasNext()) {
                ItemStack stack3 = (ItemStack)stack22.next();
                outputs.func_74742_a((NBTBase)stack3.func_77955_b(new NBTTagCompound()));
            }
            NBTTagList requests = new NBTTagList();
            for (Request request : recipe.requests) {
                requests.func_74742_a((NBTBase)RequestItem.writeNBT(request));
            }
            NBTTagList leftovers = new NBTTagList();
            for (ItemStack stack4 : recipe.leftovers.stacks) {
                leftovers.func_74742_a((NBTBase)stack4.func_77955_b(new NBTTagCompound()));
            }
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74782_a("inputs", (NBTBase)inputs);
            nBTTagCompound.func_74782_a("outputs", (NBTBase)outputs);
            nBTTagCompound.func_74782_a("requests", (NBTBase)requests);
            nBTTagCompound.func_74782_a("leftovers", (NBTBase)leftovers);
            recipes.func_74742_a((NBTBase)nBTTagCompound);
        }
        NBTTagList sent = new NBTTagList();
        for (ItemStack stack : this.sent.stacks) {
            sent.func_74742_a((NBTBase)stack.func_77955_b(new NBTTagCompound()));
        }
        NBTTagList nBTTagList = new NBTTagList();
        for (RequesterReference<?> reference : this.linked) {
            nBTTagList.func_74742_a((NBTBase)RequesterReference.writeNBT(reference));
        }
        tag.func_74782_a("recipes", (NBTBase)recipes);
        tag.func_74782_a("process", (NBTBase)this.process.writeNbt());
        tag.func_74782_a("sent", (NBTBase)sent);
        tag.func_74782_a("linked", (NBTBase)nBTTagList);
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.recipes.clear();
        this.sent.stacks.clear();
        if (tag.func_74764_b("Inputs") || tag.func_74764_b("Outputs") || tag.func_74764_b("Linked")) {
            ICrafter.Recipe<ItemStack> recipe = new ICrafter.Recipe<ItemStack>(new RequestItem(null));
            recipe.inputs.addAll(Collections.nCopies(SIZE[this.type] * 2, ItemStack.field_190927_a));
            recipe.outputs.addAll(Collections.nCopies(SIZE[this.type], ItemStack.field_190927_a));
            NBTTagList inputs = tag.func_150295_c("Inputs", 10);
            for (int i = 0; i < inputs.func_74745_c(); ++i) {
                NBTTagCompound compound = inputs.func_150305_b(i);
                recipe.inputs.set(compound.func_74762_e("Slot"), new ItemStack(compound));
            }
            NBTTagList outputs = tag.func_150295_c("Outputs", 10);
            for (int i = 0; i < outputs.func_74745_c(); ++i) {
                NBTTagCompound compound = outputs.func_150305_b(i);
                recipe.outputs.set(compound.func_74762_e("Slot"), new ItemStack(compound));
            }
            this.recipes.add(recipe);
            NBTTagList linked = tag.func_150295_c("Linked", 10);
            for (int i = 0; i < linked.func_74745_c(); ++i) {
                NBTTagCompound compound = linked.func_150305_b(i);
                this.linked.add(RequesterReference.readNBT(compound));
            }
        } else {
            NBTTagList recipes = tag.func_150295_c("recipes", 10);
            for (int i = 0; i < recipes.func_74745_c(); ++i) {
                NBTTagCompound nbt = recipes.func_150305_b(i);
                ICrafter.Recipe<ItemStack> recipe = new ICrafter.Recipe<ItemStack>(new RequestItem(null));
                NBTTagList inputs = nbt.func_150295_c("inputs", 10);
                for (int j = 0; j < inputs.func_74745_c(); ++j) {
                    recipe.inputs.add(new ItemStack(inputs.func_150305_b(j)));
                }
                NBTTagList outputs = nbt.func_150295_c("outputs", 10);
                for (int j = 0; j < outputs.func_74745_c(); ++j) {
                    recipe.outputs.add(new ItemStack(outputs.func_150305_b(j)));
                }
                NBTTagList requests = nbt.func_150295_c("requests", 10);
                for (int j = 0; j < requests.func_74745_c(); ++j) {
                    recipe.requests.add(RequestItem.readNBT(requests.func_150305_b(j)));
                }
                NBTTagList leftovers = nbt.func_150295_c("leftovers", 10);
                for (int j = 0; j < leftovers.func_74745_c(); ++j) {
                    recipe.leftovers.stacks.add(new ItemStack(leftovers.func_150305_b(j)));
                }
                this.recipes.add(recipe);
            }
            this.process.readNbt(tag.func_150295_c("process", 10));
            NBTTagList sent = tag.func_150295_c("sent", 10);
            for (int i = 0; i < sent.func_74745_c(); ++i) {
                this.sent.stacks.add(new ItemStack(sent.func_150305_b(i)));
            }
            NBTTagList linked = tag.func_150295_c("linked", 10);
            for (int i = 0; i < linked.func_74745_c(); ++i) {
                this.linked.add(RequesterReference.readNBT(linked.func_150305_b(i)));
            }
        }
    }

    public void writePortableData(EntityPlayer player, NBTTagCompound tag) {
        super.writePortableData(player, tag);
        NBTTagList recipes = new NBTTagList();
        for (ICrafter.Recipe<ItemStack> recipe : this.recipes) {
            Object stack2;
            NBTTagList inputs = new NBTTagList();
            for (Object stack2 : recipe.inputs) {
                inputs.func_74742_a((NBTBase)stack2.func_77955_b(new NBTTagCompound()));
            }
            NBTTagList outputs = new NBTTagList();
            stack2 = recipe.outputs.iterator();
            while (stack2.hasNext()) {
                ItemStack stack3 = (ItemStack)stack2.next();
                outputs.func_74742_a((NBTBase)stack3.func_77955_b(new NBTTagCompound()));
            }
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("inputs", (NBTBase)inputs);
            nbt.func_74782_a("outputs", (NBTBase)outputs);
            recipes.func_74742_a((NBTBase)nbt);
        }
        tag.func_74778_a("DisplayType", new ItemStack((Item)ThermalLogistics.Items.crafter).func_77977_a() + ".name");
        tag.func_74768_a("recipesType", this.type);
        tag.func_74778_a("recipesClass", "ItemStack");
        tag.func_74782_a("recipes", (NBTBase)recipes);
    }

    public void readPortableData(EntityPlayer player, NBTTagCompound tag) {
        super.readPortableData(player, tag);
        if (tag.func_74762_e("recipesType") == this.type && tag.func_74779_i("recipesClass").equals("ItemStack")) {
            this.recipes.clear();
            this.sent.stacks.clear();
            NBTTagList recipes = tag.func_150295_c("recipes", 10);
            for (int i = 0; i < recipes.func_74745_c(); ++i) {
                NBTTagCompound nbt = recipes.func_150305_b(i);
                ICrafter.Recipe<ItemStack> recipe = new ICrafter.Recipe<ItemStack>(new RequestItem(null));
                NBTTagList inputs = nbt.func_150295_c("inputs", 10);
                for (int j = 0; j < inputs.func_74745_c(); ++j) {
                    recipe.inputs.add(new ItemStack(inputs.func_150305_b(j)));
                }
                NBTTagList outputs = nbt.func_150295_c("outputs", 10);
                for (int j = 0; j < outputs.func_74745_c(); ++j) {
                    recipe.outputs.add(new ItemStack(outputs.func_150305_b(j)));
                }
                this.recipes.add(recipe);
            }
            this.markDirty();
        }
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerCrafter(inventory, this);
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiCrafter(inventory, this);
    }

    public void handleInfoPacketType(byte a, PacketBase payload, boolean isServer, EntityPlayer player) {
        block25: {
            block20: {
                int j;
                int i;
                block21: {
                    block23: {
                        int recipe;
                        byte message;
                        block22: {
                            ICrafter.Recipe<ItemStack> r;
                            ItemStack stack;
                            int index;
                            block24: {
                                if (a != 0) break block20;
                                if (!isServer) break block21;
                                message = payload.getByte();
                                if (message != 0) break block22;
                                int recipe2 = payload.getInt();
                                boolean input = payload.getBool();
                                index = payload.getInt();
                                stack = payload.getItemStack();
                                if (recipe2 >= this.recipes.size()) break block23;
                                r = this.recipes.get(recipe2);
                                if (!input) break block24;
                                if (index < r.inputs.size()) {
                                    r.inputs.set(index, stack);
                                    this.markDirty();
                                }
                                break block23;
                            }
                            if (index >= r.outputs.size()) break block23;
                            r.outputs.set(index, stack);
                            this.markDirty();
                            break block23;
                        }
                        if (message == 1) {
                            int split = payload.getInt();
                            if (Ints.contains((int[])SPLITS[this.type], (int)split)) {
                                this.split(split);
                                this.markDirty();
                            }
                        } else if (message == 2) {
                            int n = payload.getInt();
                            if (n < this.linked.size()) {
                                this.linked.remove(n);
                            }
                        } else if (message == 3) {
                            ICrafterWrapper<?> wrapper;
                            TileEntity tile = BlockHelper.getAdjacentTileEntity((TileEntity)this.baseTile, (int)this.side);
                            if (tile != null && (wrapper = ThermalLogistics.INSTANCE.getWrapper(tile.getClass())) != null) {
                                this.recipes.clear();
                                this.sent.stacks.clear();
                                ICrafter.Recipe<ItemStack> recipe3 = new ICrafter.Recipe<ItemStack>(new RequestItem(null));
                                recipe3.inputs.addAll(Collections.nCopies(SIZE[this.type] * 2, ItemStack.field_190927_a));
                                recipe3.outputs.addAll(Collections.nCopies(SIZE[this.type], ItemStack.field_190927_a));
                                wrapper.populateCast(tile, (byte)(this.side ^ 1), recipe3, ItemStack.class);
                                this.recipes.add(recipe3);
                                this.markDirty();
                            }
                        } else if (message == 4 && (recipe = payload.getInt()) < this.recipes.size()) {
                            int i2;
                            ICrafter.Recipe<ItemStack> r = this.recipes.get(recipe);
                            for (i2 = 0; i2 < r.inputs.size(); ++i2) {
                                r.inputs.set(i2, payload.getItemStack());
                            }
                            for (i2 = 0; i2 < r.outputs.size(); ++i2) {
                                r.outputs.set(i2, payload.getItemStack());
                            }
                        }
                    }
                    PacketHandler.sendToAllAround((PacketBase)this.getGuiPacket(), (TileEntity)this.baseTile);
                    break block25;
                }
                byte message = payload.getByte();
                if (message == 0) {
                    this.recipes.clear();
                    int size = payload.getInt();
                    for (i = 0; i < size; ++i) {
                        ICrafter.Recipe<ItemStack> recipe = new ICrafter.Recipe<ItemStack>(new RequestItem(null));
                        int inputs = payload.getInt();
                        for (j = 0; j < inputs; ++j) {
                            recipe.inputs.add(payload.getItemStack());
                        }
                        int outputs = payload.getInt();
                        for (int j2 = 0; j2 < outputs; ++j2) {
                            recipe.outputs.add(payload.getItemStack());
                        }
                        this.recipes.add(recipe);
                    }
                }
                if (message == 0 || message == 1) {
                    this.linked.clear();
                    int links = payload.getInt();
                    for (i = 0; i < links; ++i) {
                        RequesterReference reference = RequesterReference.readPacket(payload);
                        int outputs = payload.getInt();
                        for (j = 0; j < outputs; ++j) {
                            reference.outputs.add(StackHandler.readPacket(payload));
                        }
                        this.linked.add(reference);
                    }
                }
                break block25;
            }
            super.handleInfoPacketType(a, payload, isServer, player);
        }
    }

    @Override
    public void split(int split) {
        ItemStack[] inputs = new ItemStack[SIZE[this.type] * 2];
        ItemStack[] outputs = new ItemStack[SIZE[this.type]];
        int recipeSize = SIZE[this.type] / this.recipes.size();
        for (int i = 0; i < this.recipes.size(); ++i) {
            ICrafter.Recipe<ItemStack> recipe = this.recipes.get(i);
            for (int j = 0; j < recipeSize; ++j) {
                inputs[(i * recipeSize + j) * 2] = (ItemStack)recipe.inputs.get(j * 2);
                inputs[(i * recipeSize + j) * 2 + 1] = (ItemStack)recipe.inputs.get(j * 2 + 1);
                outputs[i * recipeSize + j] = (ItemStack)recipe.outputs.get(j);
            }
        }
        this.recipes.clear();
        this.sent.stacks.clear();
        int recipes = SIZE[this.type] / split;
        for (int i = 0; i < recipes; ++i) {
            ICrafter.Recipe<ItemStack> recipe = new ICrafter.Recipe<ItemStack>(new RequestItem(null));
            for (int j = 0; j < split; ++j) {
                recipe.inputs.add(inputs[(i * split + j) * 2]);
                recipe.inputs.add(inputs[(i * split + j) * 2 + 1]);
                recipe.outputs.add(outputs[i * split + j]);
            }
            this.recipes.add(recipe);
        }
    }

    @Override
    public Class<ItemStack> getItemClass() {
        return ItemStack.class;
    }

    private PacketTileInfo getGuiPacket() {
        PacketTileInfo packet = this.getNewPacket((byte)0);
        packet.addByte(0);
        packet.addInt(this.recipes.size());
        for (ICrafter.Recipe<ItemStack> recipe : this.recipes) {
            packet.addInt(recipe.inputs.size());
            for (ItemStack input : recipe.inputs) {
                packet.addItemStack(input);
            }
            packet.addInt(recipe.outputs.size());
            for (ItemStack output : recipe.outputs) {
                packet.addItemStack(output);
            }
        }
        this.writeSyncPacket(packet);
        return packet;
    }

    private void writeSyncPacket(PacketTileInfo packet) {
        this.checkLinked();
        packet.addInt(this.linked.size());
        for (RequesterReference<?> reference : this.linked) {
            RequesterReference.writePacket((PacketBase)packet, reference);
            ICrafter crafter = (ICrafter)reference.getAttachment();
            List outputs = crafter.getOutputs();
            packet.addInt(outputs.size());
            for (Object object : outputs) {
                StackHandler.writePacket((PacketBase)packet, object, crafter.getItemClass(), true);
            }
        }
    }

    @Override
    public void sync(EntityPlayer player) {
        PacketTileInfo packet = this.getNewPacket((byte)0);
        packet.addByte(1);
        this.writeSyncPacket(packet);
        PacketHandler.sendTo((PacketBase)packet, (EntityPlayer)player);
    }

    @Override
    public int getIndex() {
        return 0;
    }

    @Override
    public List<RequesterReference<?>> getLinked() {
        return this.linked;
    }

    public boolean openGui(EntityPlayer player) {
        if (ServerHelper.isServerWorld((World)this.baseTile.world())) {
            PacketHandler.sendTo((PacketBase)this.getGuiPacket(), (EntityPlayer)player);
            player.openGui((Object)ThermalDynamics.instance, 10 + this.side, this.baseTile.func_145831_w(), this.baseTile.x(), this.baseTile.y(), this.baseTile.z());
        }
        return true;
    }

    @Override
    public List<ItemStack> getOutputs() {
        NonNullList outputs = NonNullList.func_191196_a();
        for (ICrafter.Recipe<ItemStack> recipe : this.recipes) {
            outputs.addAll(this.getOutputs(recipe));
        }
        return outputs;
    }

    private List<ItemStack> getOutputs(ICrafter.Recipe<ItemStack> recipe) {
        RequestItem request = new RequestItem(null);
        for (ItemStack item : recipe.outputs) {
            if (item.func_190926_b()) continue;
            request.addStack(item);
        }
        return request.stacks;
    }

    @Override
    public List<ICrafter.Recipe<ItemStack>> getRecipes() {
        return this.recipes;
    }

    @Override
    public Set<RequesterReference<ItemStack>> getBlacklist() {
        HashSet<RequesterReference<ItemStack>> list = new HashSet<RequesterReference<ItemStack>>();
        list.add(this.getReference());
        for (Request request : this.process.requests) {
            list.addAll(request.blacklist);
        }
        return list;
    }

    @Override
    public boolean request(IRequester<ItemStack> requester, ItemStack stack) {
        for (ICrafter.Recipe<ItemStack> recipe : this.recipes) {
            ItemStack output = ItemStack.field_190927_a;
            for (ItemStack itemStack : recipe.outputs) {
                if (!ItemHelper.itemsIdentical((ItemStack)itemStack, (ItemStack)stack)) continue;
                if (output.func_190926_b()) {
                    output = itemStack;
                    continue;
                }
                output.func_190917_f(itemStack.func_190916_E());
            }
            if (output.func_190926_b()) continue;
            this.markDirty();
            for (Request request : recipe.requests) {
                if (!request.attachment.references(requester)) continue;
                request.addStack(stack);
                return true;
            }
            recipe.requests.add(new RequestItem(requester.getReference(), stack));
            return true;
        }
        return false;
    }

    @Override
    public void link(ICrafter<?> crafter, boolean recursion) {
        if (!this.linked.contains(crafter.getReference())) {
            Iterator<RequesterReference<?>> iterator = this.linked.iterator();
            while (iterator.hasNext()) {
                IRequester<?> requester = iterator.next().getAttachment();
                if (!(requester instanceof ICrafter)) {
                    iterator.remove();
                    continue;
                }
                ICrafter other = (ICrafter)requester;
                if (!other.hasLinked(this)) {
                    iterator.remove();
                    continue;
                }
                if (!recursion) continue;
                other.link(crafter, false);
            }
            this.linked.add(crafter.getReference());
            crafter.link(this, false);
            this.markDirty();
        }
    }

    @Override
    public boolean hasLinked(ICrafter<?> crafter) {
        return this.linked.contains(crafter.getReference());
    }

    @Override
    public List<ItemStack> getInputFrom(IRequester<ItemStack> requester) {
        return this.process.getStacks(requester);
    }

    @Override
    public List<ItemStack> getOutputTo(IRequester<ItemStack> requester) {
        NonNullList stacks = NonNullList.func_191196_a();
        for (ICrafter.Recipe<ItemStack> recipe : this.recipes) {
            stacks.addAll(Process.getStacks(recipe.requests, requester));
        }
        return stacks;
    }

    @Override
    public boolean isEnabled() {
        return this.isPowered;
    }

    private boolean itemsIdentical(ItemStack a, ItemStack b) {
        if (!this.filter.getFlag(4) && a.func_77973_b().getRegistryName().func_110624_b().equals(b.func_77973_b().getRegistryName().func_110624_b())) {
            return true;
        }
        if (!this.filter.getFlag(3) && !Collections.disjoint(Ints.asList((int[])OreDictionary.getOreIDs((ItemStack)a)), Ints.asList((int[])OreDictionary.getOreIDs((ItemStack)b)))) {
            return true;
        }
        return !(a.func_77973_b() != b.func_77973_b() || !this.filter.getFlag(1) && a.func_77960_j() != b.func_77960_j() || !this.filter.getFlag(2) && !ItemStack.func_77970_a((ItemStack)a, (ItemStack)b));
    }

    @Override
    public int amountRequired(ItemStack stack) {
        int amount = this.required(stack, true);
        for (ItemStack item : this.process.getStacks()) {
            if (!this.itemsIdentical(item, stack)) continue;
            amount -= item.func_190916_E();
        }
        return Math.max(amount, 0);
    }

    @Override
    public float getThrottle() {
        return 0.0f;
    }

    private int required(ItemStack stack, boolean ducts) {
        StackMap map;
        int amount = 0;
        for (int i = 0; i < this.recipes.size(); ++i) {
            ICrafter.Recipe<ItemStack> recipe = this.recipes.get(i);
            int inputAmount = 0;
            for (ItemStack input : recipe.inputs) {
                if (input.func_190926_b() || !this.itemsIdentical(input, stack)) continue;
                inputAmount += input.func_190916_E();
            }
            if (inputAmount == 0) continue;
            int recipes = this.getRequiredRecipes(i);
            for (RequesterReference<?> reference : this.linked) {
                recipes = Math.max(recipes, ((ICrafter)reference.getAttachment()).getRequiredRecipes(i));
            }
            amount += inputAmount * recipes;
        }
        for (ItemStack item : this.sent.stacks) {
            if (!this.itemsIdentical(item, stack)) continue;
            amount -= item.func_190916_E();
        }
        if (ducts && (map = (StackMap)((GridItem)this.itemDuct.getGrid()).travelingItems.get(this.itemDuct.pos().func_177972_a(EnumFacing.func_82600_a((int)this.side)))) != null) {
            for (ItemStack item : map.getItems()) {
                if (!this.itemsIdentical(item, stack)) continue;
                amount -= item.func_190916_E();
            }
        }
        return Math.max(amount, 0);
    }

    @Override
    public int getRequiredRecipes(int index) {
        if (index >= this.recipes.size()) {
            return 0;
        }
        ICrafter.Recipe<ItemStack> recipe = this.recipes.get(index);
        int recipes = 0;
        for (ItemStack output : this.getOutputs(recipe)) {
            int count = 0;
            block1: for (Request request : recipe.requests) {
                for (ItemStack item : request.stacks) {
                    if (!ItemHelper.itemsIdentical((ItemStack)output, (ItemStack)item)) continue;
                    count += item.func_190916_E();
                    continue block1;
                }
            }
            if ((count -= recipe.leftovers.getCount(output)) <= 0) continue;
            recipes = Math.max(recipes, (count - 1) / output.func_190916_E() + 1);
        }
        return recipes;
    }

    @Override
    public DuctUnit getDuct() {
        return this.itemDuct;
    }

    @Override
    public TileEntity getTile() {
        return this.baseTile;
    }

    @Override
    public byte getSide() {
        return this.side;
    }

    @Override
    public ListWrapper<Route<DuctUnitItem, GridItem>> getRoutes() {
        return this.routesWithInsertSideList;
    }

    @Override
    public boolean hasMultiStack() {
        return multiStack[this.type];
    }

    @Override
    public TileEntity getCachedTile() {
        return this.myTile;
    }

    @Override
    public ItemStack getIcon() {
        return this.getPickBlock();
    }

    private void onFinishCrafting(ICrafter.Recipe<ItemStack> recipe, int i, Iterator<Request<ItemStack>> iterator, Request<ItemStack> request, ItemStack stack) {
        ItemStack output = ItemStack.field_190927_a;
        for (ItemStack out : recipe.outputs) {
            if (!ItemHelper.itemsIdentical((ItemStack)out, (ItemStack)stack)) continue;
            if (output.func_190926_b()) {
                output = out;
                continue;
            }
            output.func_190917_f(out.func_190916_E());
        }
        request.decreaseStack(stack);
        if (request.stacks.isEmpty()) {
            iterator.remove();
        }
        int count = stack.func_190916_E();
        Iterator iterator1 = recipe.leftovers.stacks.iterator();
        while (iterator1.hasNext()) {
            ItemStack leftovers = (ItemStack)iterator1.next();
            if (!ItemHelper.itemsIdentical((ItemStack)leftovers, (ItemStack)stack)) continue;
            int amount = Math.min(leftovers.func_190916_E(), stack.func_190916_E());
            leftovers.func_190918_g(amount);
            count -= amount;
            if (!leftovers.func_190926_b()) break;
            iterator1.remove();
            break;
        }
        int recipes = (count - 1) / output.func_190916_E() + 1;
        if (count > 0 && recipes > 0) {
            int leftover = count % output.func_190916_E() > 0 ? output.func_190916_E() - count % output.func_190916_E() : 0;
            for (ItemStack itemStack : recipe.inputs) {
                if (itemStack.func_190926_b()) continue;
                this.sent.decreaseStack(ItemHelper.cloneStack((ItemStack)itemStack, (int)(itemStack.func_190916_E() * recipes)));
            }
            for (ItemStack itemStack : this.getOutputs(recipe)) {
                int amount = ItemHelper.itemsIdentical((ItemStack)itemStack, (ItemStack)stack) ? leftover : itemStack.func_190916_E() * recipes;
                if (amount <= 0) continue;
                recipe.leftovers.addStack(ItemHelper.cloneStack((ItemStack)itemStack, (int)amount));
            }
            this.checkLinked();
            for (RequesterReference requesterReference : this.linked) {
                requesterReference.getAttachment().onFinishCrafting(i, recipes);
            }
        }
        this.markDirty();
    }

    @Override
    public void onFinishCrafting(IRequester<ItemStack> requester, ItemStack stack) {
        for (int i = 0; i < this.recipes.size(); ++i) {
            ICrafter.Recipe<ItemStack> recipe = this.recipes.get(i);
            if (recipe.requests.isEmpty()) continue;
            Iterator<Request<ItemStack>> iterator = recipe.requests.iterator();
            while (iterator.hasNext()) {
                Request<ItemStack> request = iterator.next();
                if (!request.attachment.references(requester)) continue;
                this.onFinishCrafting(recipe, i, iterator, request, stack);
                return;
            }
        }
    }

    @Override
    public void onFinishCrafting(int index, int recipes) {
        if (index >= this.recipes.size()) {
            return;
        }
        ICrafter.Recipe<ItemStack> recipe = this.recipes.get(index);
        for (ItemStack in : recipe.inputs) {
            if (in.func_190926_b()) continue;
            this.sent.decreaseStack(ItemHelper.cloneStack((ItemStack)in, (int)(in.func_190916_E() * recipes)));
        }
        for (ItemStack out : recipe.outputs) {
            if (out.func_190926_b()) continue;
            recipe.leftovers.addStack(ItemHelper.cloneStack((ItemStack)out, (int)(out.func_190916_E() * recipes)));
        }
        this.markDirty();
    }

    @Override
    public void markDirty() {
        this.baseTile.markChunkDirty();
    }

    @Override
    public void claim(ICrafter<ItemStack> crafter, ItemStack stack) {
        Iterator iterator = this.process.requests.iterator();
        while (iterator.hasNext()) {
            Request request = (Request)iterator.next();
            if (!request.attachment.references(crafter)) continue;
            request.decreaseStack(stack);
            if (request.stacks.isEmpty()) {
                iterator.remove();
            }
            return;
        }
    }

    private static class Inventory
    implements IItemHandler {
        private final CrafterItem crafter;
        private final IItemHandler inv;

        private Inventory(CrafterItem crafter, IItemHandler inv) {
            this.crafter = crafter;
            this.inv = inv;
        }

        public int getSlots() {
            return this.inv.getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.inv.getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            int required = Math.min(stack.func_190916_E(), this.crafter.required(stack, false));
            if (required == 0) {
                return stack;
            }
            int remaining = stack.func_190916_E() - required;
            ItemStack remainder = this.inv.insertItem(slot, ItemHelper.cloneStack((ItemStack)stack, (int)required), simulate);
            if (!simulate) {
                this.crafter.sent.addStack(ItemHelper.cloneStack((ItemStack)stack, (int)(required - remainder.func_190916_E())));
                this.crafter.markDirty();
            }
            return ItemHelper.cloneStack((ItemStack)stack, (int)(remainder.func_190916_E() + remaining));
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.inv.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.inv.getSlotLimit(slot);
        }
    }

    private static class CacheWrapper
    extends DuctUnitItem.Cache {
        private final CrafterItem crafter;

        private CacheWrapper(@Nonnull TileEntity tile, @Nonnull CrafterItem attachment) {
            super(tile, (Attachment)attachment);
            this.crafter = attachment;
        }

        public IItemHandler getItemHandler(int face) {
            return new Inventory(this.crafter, super.getItemHandler(EnumFacing.func_82600_a((int)face)));
        }

        public IItemHandler getItemHandler(EnumFacing face) {
            return new Inventory(this.crafter, super.getItemHandler(face));
        }
    }
}

