/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.gui.controls.gui.timeline;

import com.creativemd.creativecore.common.gui.controls.gui.timeline.KeyControl;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.creativecore.common.utils.type.PairList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class TimelineChannel<T> {
    public int index;
    public String name;
    public List<KeyControl<T>> controls = new ArrayList<KeyControl<T>>();

    public TimelineChannel(String name) {
        this.name = name;
    }

    public TimelineChannel addKeys(PairList<Integer, T> keys) {
        if (keys == null || keys.isEmpty()) {
            return this;
        }
        for (Pair pair : keys) {
            this.addKey((Integer)pair.key, pair.value);
        }
        return this;
    }

    public TimelineChannel<T> addKeyFixed(int tick, T value) {
        KeyControl control = this.addKey(tick, value);
        control.modifiable = false;
        return this;
    }

    public KeyControl addKey(int tick, T value) {
        KeyControl<T> control = new KeyControl<T>(this, this.controls.size(), tick, value);
        for (int i = 0; i < this.controls.size(); ++i) {
            KeyControl<T> other = this.controls.get(i);
            if (other.tick == tick) {
                return other;
            }
            if (other.tick <= tick) continue;
            this.controls.add(i, control);
            return control;
        }
        this.controls.add(control);
        return control;
    }

    public void removeKey(KeyControl control) {
        this.controls.remove(control);
    }

    public void movedKey(KeyControl control) {
        Collections.sort(this.controls);
    }

    public boolean isSpaceFor(KeyControl control, int tick) {
        for (int i = 0; i < this.controls.size(); ++i) {
            int otherTick = this.controls.get((int)i).tick;
            if (otherTick == tick) {
                return false;
            }
            if (otherTick <= tick) continue;
            return true;
        }
        return true;
    }

    public T getValueAt(int tick) {
        if (this.controls.isEmpty()) {
            return this.getDefault();
        }
        int higher = this.controls.size();
        for (int i = 0; i < this.controls.size(); ++i) {
            int otherTick = this.controls.get((int)i).tick;
            if (otherTick == tick) {
                return this.controls.get((int)i).value;
            }
            if (otherTick <= tick) continue;
            higher = i;
            break;
        }
        if (higher == 0 || higher == this.controls.size()) {
            return this.controls.get((int)(higher == 0 ? 0 : this.controls.size() - 1)).value;
        }
        KeyControl<T> before = this.controls.get(higher - 1);
        KeyControl<T> after = this.controls.get(higher);
        double percentage = (double)(tick - before.tick) / (double)(after.tick - before.tick);
        return this.getValueAt(before, after, percentage);
    }

    protected abstract T getValueAt(KeyControl<T> var1, KeyControl<T> var2, double var3);

    protected abstract T getDefault();

    public PairList<Integer, T> getPairs() {
        if (this.controls.isEmpty()) {
            return null;
        }
        boolean fixed = true;
        PairList list = new PairList();
        for (KeyControl<T> control : this.controls) {
            if (control.modifiable) {
                fixed = false;
            }
            list.add(Integer.valueOf(control.tick), control.value);
        }
        if (fixed) {
            return null;
        }
        return list;
    }

    public static class TimelineChannelDouble
    extends TimelineChannel<Double> {
        public TimelineChannelDouble(String name) {
            super(name);
        }

        @Override
        protected Double getValueAt(KeyControl<Double> before, KeyControl<Double> after, double percentage) {
            return (double)Math.round((((Double)after.value - (Double)before.value) * percentage + (Double)before.value) * 100.0) / 100.0;
        }

        @Override
        protected Double getDefault() {
            return 0.0;
        }
    }

    public static class TimelineChannelInteger
    extends TimelineChannel<Integer> {
        public TimelineChannelInteger(String name) {
            super(name);
        }

        @Override
        protected Integer getValueAt(KeyControl<Integer> before, KeyControl<Integer> after, double percentage) {
            int dif = (Integer)after.value - (Integer)before.value;
            double current = (double)dif * percentage + (double)((Integer)before.value).intValue();
            return (int)current;
        }

        @Override
        protected Integer getDefault() {
            return 0;
        }
    }
}

