/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.zensummoning.common.blocks;

import ca.teamdman.zensummoning.SummoningAttempt;
import ca.teamdman.zensummoning.ZenSummoning;
import ca.teamdman.zensummoning.common.tiles.TileAltar;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockAltar
extends Block
implements ITileEntityProvider {
    private final AxisAlignedBB bb = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.0625, 0.9375);

    public BlockAltar() {
        super(Material.field_151576_e);
        this.setRegistryName(new ResourceLocation("zensummoning", "altar"));
        this.func_149663_c("altar");
        this.func_149647_a(ZenSummoning.CREATIVE_TAB);
        this.func_149711_c(3.0f);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileAltar();
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.bb;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileAltar) {
            ItemStack stack;
            TileAltar altar = (TileAltar)tile;
            while (!(stack = altar.popStack()).func_190926_b()) {
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
            }
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ZenSummoning.log("Altar onBlockActivated");
        if (!world.field_72995_K) {
            TileEntity tile = world.func_175625_s(pos);
            if (!(tile instanceof TileAltar)) {
                ZenSummoning.log("Altar onBlockActivated tile not altar?");
                return false;
            }
            TileAltar altar = (TileAltar)tile;
            if (!playerIn.func_70093_af()) {
                ZenSummoning.log("Altar onBlockActivated player not sneaking");
                if (playerIn.func_184586_b(hand).func_190926_b()) {
                    playerIn.func_184611_a(hand, altar.popStack());
                    world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.5f, -0.5f);
                } else {
                    playerIn.func_184611_a(hand, altar.pushStack(playerIn.func_184586_b(hand)));
                    world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.5f, 2.0f);
                }
            } else {
                ZenSummoning.log("Altar onBlockActivated player is sneaking");
                SummoningAttempt result = altar.summonStart(playerIn, hand);
                ZenSummoning.log("Altar onBlockActivated summon " + result.getMessage());
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation(result.getMessage(), new Object[0]));
                if (result.isSuccess()) {
                    world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_193809_ey, SoundCategory.BLOCKS, 1.0f, 0.1f);
                } else {
                    world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187689_f, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            }
        }
        return true;
    }
}

