/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory.wrapper;

import fi.dy.masa.enderutilities.inventory.IItemHandlerSelective;
import fi.dy.masa.enderutilities.inventory.IItemHandlerSize;
import fi.dy.masa.enderutilities.inventory.IItemHandlerSyncable;
import fi.dy.masa.enderutilities.inventory.item.InventoryItem;
import fi.dy.masa.enderutilities.util.nbt.OwnerData;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ItemHandlerWrapperPermissions
implements IItemHandlerModifiable,
IItemHandlerSelective,
IItemHandlerSize,
IItemHandlerSyncable {
    private final InventoryItem baseHandler;
    private final UUID accessorUUID;

    public ItemHandlerWrapperPermissions(InventoryItem baseHandler, Entity entity) {
        this.baseHandler = baseHandler;
        this.accessorUUID = entity != null ? entity.func_110124_au() : null;
    }

    public boolean isCurrentlyAccessible() {
        return this.isAccessibleBy(this.accessorUUID);
    }

    public boolean isAccessibleByPlayer(EntityPlayer player) {
        return OwnerData.canAccessItem(this.baseHandler.getContainerItemStack(), (Entity)player);
    }

    public boolean isAccessibleBy(UUID uuid) {
        return OwnerData.canAccessItem(this.baseHandler.getContainerItemStack(), uuid);
    }

    public int getSlots() {
        return this.baseHandler.getSlots();
    }

    public int getSlotLimit(int slot) {
        return this.baseHandler.getSlotLimit(slot);
    }

    public ItemStack getStackInSlot(int slot) {
        if (this.isCurrentlyAccessible()) {
            return this.baseHandler.getStackInSlot(slot);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (this.isCurrentlyAccessible()) {
            return this.baseHandler.insertItem(slot, stack, simulate);
        }
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.isCurrentlyAccessible()) {
            return this.baseHandler.extractItem(slot, amount, simulate);
        }
        return ItemStack.field_190927_a;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (this.isCurrentlyAccessible()) {
            this.baseHandler.setStackInSlot(slot, stack);
        }
    }

    @Override
    public void syncStackInSlot(int slot, ItemStack stack) {
        this.baseHandler.setStackInSlot(slot, stack);
    }

    @Override
    public int getInventoryStackLimit() {
        return this.baseHandler.getInventoryStackLimit();
    }

    @Override
    public int getItemStackLimit(int slot, ItemStack stack) {
        return this.baseHandler.getItemStackLimit(slot, stack);
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (this.isCurrentlyAccessible()) {
            return this.baseHandler.isItemValidForSlot(slot, stack);
        }
        return false;
    }

    @Override
    public boolean canExtractFromSlot(int slot) {
        if (this.isCurrentlyAccessible()) {
            return this.baseHandler.canExtractFromSlot(slot);
        }
        return false;
    }
}

