/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.entity;

import fi.dy.masa.enderutilities.item.tool.ItemEnderSword;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.EntityUtils;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityEndermanFighter
extends EntityMob {
    private static final DataParameter<Boolean> RAGING = EntityDataManager.func_187226_a(EntityEndermanFighter.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SCREAMING = EntityDataManager.func_187226_a(EntityEndermanFighter.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final UUID ATTACKING_SPEED_BOOST_ID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier ATTACKING_SPEED_BOOST = new AttributeModifier(ATTACKING_SPEED_BOOST_ID, "Attacking speed boost", 0.2, 0).func_111168_a(false);
    private EntityLivingBase assignedTarget;
    private EntityLivingBase revengeTarget;
    private UUID assignedTargetUUID;
    private UUID revengeTargetUUID;
    private boolean isBeingControlled;
    private int lastCreepySound;

    public EntityEndermanFighter(World world) {
        super(world);
        this.func_70105_a(0.6f, 2.9f);
        this.field_70138_W = 1.0f;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new AIDespawn(this, 200));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AIAttackAssignedTarget(this, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new AIAttackRevengeTarget(this, false));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new AIAttackClosestPlayer(this, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(9.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(RAGING, (Object)false);
        this.func_184212_Q().func_187214_a(SCREAMING, (Object)false);
    }

    public float func_70047_e() {
        return 2.55f;
    }

    protected boolean func_146066_aG() {
        return false;
    }

    public void playEndermanSound() {
        if (this.field_70173_aa >= this.lastCreepySound + 400) {
            this.lastCreepySound = this.field_70173_aa;
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, SoundEvents.field_187532_aV, this.func_184176_by(), 2.5f, 1.0f, false);
            }
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        if (SCREAMING.equals(key) && this.isScreaming() && this.field_70170_p.field_72995_K) {
            this.playEndermanSound();
        }
        super.func_184206_a(key);
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        super.func_70624_b(target);
        IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (target == null) {
            this.setScreaming(false);
            iattributeinstance.func_111124_b(ATTACKING_SPEED_BOOST);
        } else {
            if (!iattributeinstance.func_180374_a(ATTACKING_SPEED_BOOST)) {
                iattributeinstance.func_111121_a(ATTACKING_SPEED_BOOST);
            }
            if (target instanceof EntityPlayer && !this.isScreaming()) {
                this.setScreaming(true);
            }
        }
    }

    private boolean isPlayerHoldingSummonItem(EntityPlayer player) {
        ItemStack stack = player.func_184614_ca();
        return !stack.func_190926_b() && stack.func_77973_b() == EnderUtilitiesItems.ENDER_SWORD && ItemEnderSword.SwordMode.fromStack(stack) == ItemEnderSword.SwordMode.SUMMON;
    }

    public void setAssignedTarget(@Nullable EntityLivingBase target) {
        this.assignedTarget = target;
        this.assignedTargetUUID = target != null ? target.func_110124_au() : null;
    }

    public void func_70604_c(@Nullable EntityLivingBase target) {
        this.revengeTarget = target;
        this.revengeTargetUUID = target != null ? target.func_110124_au() : null;
    }

    @Nullable
    public EntityLivingBase getAssignedTarget() {
        if (this.assignedTarget == null) {
            if (this.assignedTargetUUID != null) {
                this.assignedTarget = (EntityLivingBase)this.getEntityFromUUID(this.assignedTargetUUID);
            }
        } else if (!this.assignedTarget.func_70089_S()) {
            this.assignedTarget = null;
            this.assignedTargetUUID = null;
        }
        return this.assignedTarget;
    }

    @Nullable
    public EntityLivingBase func_70643_av() {
        if (this.revengeTarget == null) {
            if (this.revengeTargetUUID != null) {
                this.revengeTarget = (EntityLivingBase)this.getEntityFromUUID(this.revengeTargetUUID);
            }
        } else if (!this.revengeTarget.func_70089_S()) {
            this.revengeTarget = null;
            this.revengeTargetUUID = null;
        }
        return this.revengeTarget;
    }

    public boolean isWithinTargetingDistance(@Nonnull Entity entity) {
        return this.func_70068_e(entity) <= 1024.0;
    }

    public boolean isBeingControlled() {
        return this.isBeingControlled;
    }

    @Nullable
    private Entity getEntityFromUUID(UUID uuid) {
        if (this.func_130014_f_() instanceof WorldServer) {
            return ((WorldServer)this.func_130014_f_()).func_175733_a(uuid);
        }
        return null;
    }

    @Nullable
    protected EntityPlayer findPlayerToAttack() {
        EntityPlayer player = this.getClosestVulnerablePlayer(this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0);
        if (player != null && this.shouldAttackPlayer(player)) {
            return player;
        }
        return null;
    }

    @Nullable
    protected EntityPlayer getClosestVulnerablePlayer(double x, double y, double z, double distance) {
        double closest = -1.0;
        EntityPlayer player = null;
        List players = this.func_130014_f_().func_175661_b(EntityPlayer.class, EntitySelectors.field_180132_d);
        for (EntityPlayer playerTmp : players) {
            double distSight;
            if (playerTmp.field_71075_bZ.field_75102_a || !playerTmp.func_70089_S() || this.isPlayerHoldingSummonItem(playerTmp)) continue;
            double distTmp = playerTmp.func_70092_e(x, y, z);
            double d = distSight = playerTmp.func_70093_af() ? distance * 0.8 : distance;
            if (playerTmp.func_82150_aj()) {
                float f = playerTmp.func_82243_bO();
                if (f < 0.1f) {
                    f = 0.1f;
                }
                distSight *= 0.7 * (double)f;
            }
            if (!(distance < 0.0) && !(distTmp < distSight * distSight) || closest != -1.0 && !(distTmp < closest)) continue;
            closest = distTmp;
            player = playerTmp;
        }
        return player;
    }

    public boolean shouldAttackPlayer(@Nonnull EntityPlayer player) {
        return !this.isBeingControlled && !this.func_145818_k_() && player.func_70089_S() && !player.field_71075_bZ.field_75102_a && !this.isPlayerHoldingSummonItem(player);
    }

    private void updateIsBeingControlled() {
        for (int i = 0; i < this.func_130014_f_().field_73010_i.size(); ++i) {
            EntityPlayer playerTmp = (EntityPlayer)this.func_130014_f_().field_73010_i.get(i);
            if (!playerTmp.func_70089_S() || !(playerTmp.func_70092_e(this.field_70165_t, this.field_70163_u, this.field_70161_v) < 1024.0) || !this.isPlayerHoldingSummonItem(playerTmp)) continue;
            this.isBeingControlled = true;
            return;
        }
        this.isBeingControlled = false;
    }

    public EntityLivingBase getLivingEntityNearbyByUUID(UUID uuid, double bbRadius) {
        double r = bbRadius;
        AxisAlignedBB bb = new AxisAlignedBB(this.field_70165_t - r, this.field_70163_u - r, this.field_70161_v - r, this.field_70165_t + r, this.field_70163_u + r, this.field_70161_v + r);
        List list = this.func_130014_f_().func_72872_a(EntityLivingBase.class, bb);
        return (EntityLivingBase)EntityUtils.findEntityByUUID(list, uuid);
    }

    public static void summonFighters(World world, EntityLivingBase target, int amount) {
        if (target instanceof EntityEndermanFighter) {
            return;
        }
        double r = 16.0;
        double x = target.field_70165_t;
        double y = target.field_70163_u;
        double z = target.field_70161_v;
        int numReTargeted = 0;
        AxisAlignedBB bb = new AxisAlignedBB(x - r, y - r, z - r, x + r, y + r, z + r);
        List list = world.func_72872_a(EntityEndermanFighter.class, bb);
        for (EntityEndermanFighter fighter : list) {
            if (fighter.getAssignedTarget() != null || fighter.func_145818_k_()) continue;
            fighter.setAssignedTarget(target);
            ++numReTargeted;
        }
        if (numReTargeted >= amount) {
            return;
        }
        block1: for (int count = numReTargeted; count < amount; ++count) {
            EntityEndermanFighter fighter;
            fighter = new EntityEndermanFighter(world);
            for (int i = 0; i < 16; ++i) {
                x = target.field_70165_t - 5.0 + (double)world.field_73012_v.nextFloat() * 10.0;
                y = target.field_70163_u - 2.0 + (double)world.field_73012_v.nextFloat() * 4.0;
                z = target.field_70161_v - 5.0 + (double)world.field_73012_v.nextFloat() * 10.0;
                BlockPos pos = new BlockPos(x, (double)((int)(y - 1.0)), z);
                IBlockState state = world.func_180495_p(pos);
                fighter.func_70107_b(x, (int)y, z);
                if (!world.func_184144_a((Entity)fighter, fighter.func_174813_aQ()).isEmpty() || world.func_72953_d(fighter.func_174813_aQ()) || !state.isSideSolid((IBlockAccess)world, pos, EnumFacing.UP)) continue;
                for (int j = 0; j < 16; ++j) {
                    float vx = (world.field_73012_v.nextFloat() - 0.5f) * 0.2f;
                    float vy = (world.field_73012_v.nextFloat() - 0.5f) * 0.2f;
                    float vz = (world.field_73012_v.nextFloat() - 0.5f) * 0.2f;
                    world.func_175688_a(EnumParticleTypes.PORTAL, x, y, z, (double)vx, (double)vy, (double)vz, new int[0]);
                }
                fighter.setAssignedTarget(target);
                world.func_72838_d((Entity)fighter);
                world.func_184148_a(null, x, y, z, SoundEvents.field_187534_aX, fighter.func_184176_by(), 1.0f, 1.0f);
                continue block1;
            }
        }
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                double x = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
                double y = this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25;
                double z = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
                double vx = (this.field_70146_Z.nextDouble() - 0.5) * 2.0;
                double vz = (this.field_70146_Z.nextDouble() - 0.5) * 2.0;
                this.func_130014_f_().func_175688_a(EnumParticleTypes.PORTAL, x, y, z, vx, -this.field_70146_Z.nextDouble(), vz, new int[0]);
            }
        }
        this.field_70703_bu = false;
        super.func_70636_d();
    }

    protected void func_70619_bc() {
        if (!this.func_175446_cd()) {
            if (this.func_70026_G()) {
                this.func_70097_a(DamageSource.field_76369_e, 1.0f);
            }
            if ((this.field_70173_aa & 7) == 0) {
                this.updateIsBeingControlled();
            }
        }
        super.func_70619_bc();
    }

    protected boolean teleportRandomly() {
        double x = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 32.0;
        double y = this.field_70163_u + (double)(this.field_70146_Z.nextInt(8) - 4);
        double z = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 32.0;
        return this.teleportTo(x, y, z);
    }

    protected boolean teleportTo(double x, double y, double z) {
        EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)this, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        boolean success = this.func_184595_k(event.getTargetX(), event.getTargetY(), event.getTargetZ());
        if (success) {
            this.func_130014_f_().func_184148_a(null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
        }
        return success;
    }

    protected SoundEvent func_184639_G() {
        if (this.func_175446_cd()) {
            return null;
        }
        return this.isScreaming() ? SoundEvents.field_187532_aV : SoundEvents.field_187529_aS;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187531_aU;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187530_aT;
    }

    protected Item func_146068_u() {
        return null;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.func_180431_b(source)) {
            return false;
        }
        this.setScreaming(true);
        if (source.func_76346_g() == null) {
            for (int i = 0; i < 64; ++i) {
                if (!this.teleportRandomly()) continue;
                return true;
            }
        }
        return super.func_70097_a(source, damage);
    }

    public boolean isRaging() {
        return (Boolean)this.func_184212_Q().func_187225_a(RAGING);
    }

    public void setRaging(boolean value) {
        this.func_184212_Q().func_187227_b(RAGING, (Object)value);
    }

    public boolean isScreaming() {
        return (Boolean)this.func_184212_Q().func_187225_a(SCREAMING);
    }

    public void setScreaming(boolean value) {
        this.func_184212_Q().func_187227_b(SCREAMING, (Object)value);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.assignedTargetUUID != null) {
            nbt.func_74772_a("ATUUIDM", this.assignedTargetUUID.getMostSignificantBits());
            nbt.func_74772_a("ATUUIDL", this.assignedTargetUUID.getLeastSignificantBits());
        }
        if (this.revengeTargetUUID != null) {
            nbt.func_74772_a("RTUUIDM", this.revengeTargetUUID.getMostSignificantBits());
            nbt.func_74772_a("RTUUIDL", this.revengeTargetUUID.getLeastSignificantBits());
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_150297_b("ATUUIDM", 4) && nbt.func_150297_b("ATUUIDL", 4)) {
            this.assignedTargetUUID = new UUID(nbt.func_74763_f("ATUUIDM"), nbt.func_74763_f("ATUUIDL"));
        }
        if (nbt.func_150297_b("RTUUIDM", 4) && nbt.func_150297_b("RTUUIDL", 4)) {
            this.revengeTargetUUID = new UUID(nbt.func_74763_f("RTUUIDM"), nbt.func_74763_f("RTUUIDL"));
        }
    }

    class AIDespawn
    extends EntityAIBase {
        protected final EntityEndermanFighter fighter;
        protected final int delay;
        protected int timer;

        public AIDespawn(EntityEndermanFighter fighter, int delay) {
            this.fighter = fighter;
            this.delay = delay;
        }

        public boolean func_75250_a() {
            return !this.fighter.func_104002_bU() && this.fighter.func_70638_az() == null;
        }

        public void func_75246_d() {
            Random rand;
            if (++this.timer >= this.delay && (rand = this.fighter.func_70681_au()).nextFloat() < 0.03f) {
                for (int i = 0; i < 16; ++i) {
                    float vx = (rand.nextFloat() - 0.5f) * 0.2f;
                    float vy = (rand.nextFloat() - 0.5f) * 0.2f;
                    float vz = (rand.nextFloat() - 0.5f) * 0.2f;
                    double x = this.fighter.field_70165_t + (rand.nextDouble() - 0.5) * (double)this.fighter.field_70130_N * 2.0;
                    double y = this.fighter.field_70163_u + rand.nextDouble() * (double)this.fighter.field_70131_O;
                    double z = this.fighter.field_70161_v + (rand.nextDouble() - 0.5) * (double)this.fighter.field_70130_N * 2.0;
                    this.fighter.func_130014_f_().func_175688_a(EnumParticleTypes.PORTAL, x, y, z, (double)vx, (double)vy, (double)vz, new int[0]);
                }
                this.fighter.func_130014_f_().func_184148_a(null, this.fighter.field_70165_t, this.fighter.field_70163_u, this.fighter.field_70161_v, SoundEvents.field_187534_aX, this.fighter.func_184176_by(), 0.7f, 1.0f);
                this.fighter.func_70106_y();
            }
        }

        public void func_75251_c() {
            this.timer = 0;
        }
    }

    class AIAttackClosestPlayer
    extends AIAttackRevengeTarget {
        public AIAttackClosestPlayer(EntityEndermanFighter fighter, boolean shouldBeControlled) {
            super(fighter, shouldBeControlled);
        }

        @Override
        @Nullable
        protected EntityLivingBase getTarget() {
            return this.fighter.findPlayerToAttack();
        }
    }

    class AIAttackRevengeTarget
    extends AIAttackTarget {
        public AIAttackRevengeTarget(EntityEndermanFighter fighter, boolean shouldBeControlled) {
            super(fighter, shouldBeControlled);
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            this.fighter.setRaging(true);
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.fighter.setRaging(false);
        }

        @Override
        @Nullable
        protected EntityLivingBase getTarget() {
            return this.fighter.func_70643_av();
        }
    }

    class AIAttackAssignedTarget
    extends AIAttackTarget {
        public AIAttackAssignedTarget(EntityEndermanFighter fighter, boolean shouldBeControlled) {
            super(fighter, shouldBeControlled);
        }

        @Override
        @Nullable
        protected EntityLivingBase getTarget() {
            return this.fighter.getAssignedTarget();
        }
    }

    private abstract class AIAttackTarget
    extends EntityAITarget {
        protected final EntityEndermanFighter fighter;
        protected final boolean shouldBeControlled;

        public AIAttackTarget(EntityEndermanFighter fighter, boolean shouldBeControlled) {
            super((EntityCreature)fighter, false, false);
            this.func_75248_a(1);
            this.fighter = fighter;
            this.shouldBeControlled = shouldBeControlled;
        }

        public boolean func_75250_a() {
            if (this.fighter.func_145818_k_() || this.fighter.isBeingControlled() != this.shouldBeControlled) {
                return false;
            }
            EntityLivingBase target = this.getTarget();
            return target != null && target.func_70089_S();
        }

        public boolean func_75253_b() {
            if (this.func_75250_a() && super.func_75253_b()) {
                this.fighter.func_70625_a((Entity)this.getTarget(), 10.0f, 10.0f);
                return true;
            }
            return false;
        }

        public void func_75249_e() {
            super.func_75249_e();
            this.fighter.func_70624_b(this.getTarget());
        }

        @Nullable
        protected abstract EntityLivingBase getTarget();
    }
}

