/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.entity;

import fi.dy.masa.enderutilities.entity.base.EntityThrowableEU;
import fi.dy.masa.enderutilities.entity.base.IItemData;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.teleport.TeleportEntity;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityEnderPearlReusable
extends EntityThrowableEU
implements IItemData {
    private static final DataParameter<Boolean> IS_ELITE_PEARL = EntityDataManager.func_187226_a(EntityEnderPearlReusable.class, (DataSerializer)DataSerializers.field_187198_h);
    public float teleportDamage;
    public boolean canPickUp = true;
    public boolean isElite = false;

    public EntityEnderPearlReusable(World world) {
        super(world);
    }

    public EntityEnderPearlReusable(World world, EntityLivingBase entity) {
        super(world, entity);
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
            this.canPickUp = false;
        }
    }

    public EntityEnderPearlReusable(World world, EntityLivingBase entity, boolean isElitePearl) {
        this(world, entity);
        this.isElite = isElitePearl;
        this.teleportDamage = isElitePearl ? 1.0f : 2.0f;
        this.func_184212_Q().func_187227_b(IS_ELITE_PEARL, (Object)this.isElite);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_ELITE_PEARL, (Object)false);
    }

    protected void func_70076_C() {
        if (!this.returnToPlayersInventory()) {
            this.dropAsItem();
        }
        super.func_70076_C();
    }

    @Override
    public void func_70071_h_() {
        if (!this.func_130014_f_().field_72995_K && this.isElite && !this.func_184207_aI()) {
            if (!this.returnToPlayersInventory()) {
                this.dropAsItem();
            }
            this.func_70106_y();
            return;
        }
        super.func_70071_h_();
    }

    protected void func_70184_a(RayTraceResult rayTraceResult) {
        IBlockState state;
        AxisAlignedBB aabb;
        EntityLivingBase thrower = this.func_85052_h();
        if (thrower == null) {
            if (!this.func_130014_f_().field_72995_K && this.canPickUp) {
                this.dropAsItem();
            }
            this.func_70106_y();
            return;
        }
        if (!this.func_130014_f_().field_72995_K && rayTraceResult.field_72313_a == RayTraceResult.Type.ENTITY) {
            if (EntityUtils.doesEntityStackContainEntity(rayTraceResult.field_72308_g, (Entity)thrower)) {
                return;
            }
            if (rayTraceResult.field_72308_g instanceof EntityPlayerMP && ((EntityPlayerMP)rayTraceResult.field_72308_g).func_175149_v()) {
                return;
            }
            if (rayTraceResult.field_72308_g instanceof EntityLivingBase) {
                rayTraceResult.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)thrower), 0.0f);
            }
        } else if (rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK && rayTraceResult.func_178782_a() != null && (aabb = (state = this.func_130014_f_().func_180495_p(rayTraceResult.func_178782_a())).func_185890_d((IBlockAccess)this.func_130014_f_(), rayTraceResult.func_178782_a())) == Block.field_185506_k) {
            return;
        }
        if (!this.isElite) {
            Entity bottom = thrower.func_184208_bv();
            if (bottom instanceof EntityEnderPearlReusable && bottom.func_184207_aI()) {
                bottom.func_184226_ay();
            }
            if (!this.func_130014_f_().field_72995_K) {
                TeleportEntity.teleportEntityWithProjectile((Entity)thrower, (Entity)this, rayTraceResult, this.teleportDamage, true, true);
            }
        } else if (this.func_184207_aI()) {
            Entity entity = (Entity)this.func_184188_bt().get(0);
            this.func_184226_ay();
            if (!this.func_130014_f_().field_72995_K) {
                TeleportEntity.teleportEntityWithProjectile(entity, (Entity)this, rayTraceResult, this.teleportDamage, true, true);
            }
        }
        if (!this.func_130014_f_().field_72995_K && !this.returnToPlayersInventory()) {
            this.dropAsItem();
        }
        this.func_70106_y();
    }

    public boolean returnToPlayersInventory() {
        int damage;
        if (!this.canPickUp || this.func_130014_f_().field_72995_K) {
            return true;
        }
        EntityLivingBase thrower = this.func_85052_h();
        int n = damage = this.isElite ? 1 : 0;
        if (thrower instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)thrower;
            if (!player.field_71071_by.func_70441_a(new ItemStack((Item)EnderUtilitiesItems.ENDER_PEARL_REUSABLE, 1, damage))) {
                return false;
            }
            player.func_71120_a(player.field_71070_bA);
            return true;
        }
        return false;
    }

    public void dropAsItem() {
        if (this.field_70128_L) {
            return;
        }
        int damage = this.isElite ? 1 : 0;
        EntityItem entityitem = new EntityItem(this.func_130014_f_(), this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack((Item)EnderUtilitiesItems.ENDER_PEARL_REUSABLE, 1, damage));
        entityitem.field_70159_w = 0.05 * this.func_130014_f_().field_73012_v.nextGaussian();
        entityitem.field_70181_x = 0.05 * this.func_130014_f_().field_73012_v.nextGaussian() + 0.2;
        entityitem.field_70179_y = 0.05 * this.func_130014_f_().field_73012_v.nextGaussian();
        entityitem.func_174869_p();
        this.func_130014_f_().func_72838_d((Entity)entityitem);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("Elite", this.isElite);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.isElite = nbt.func_74767_n("Elite");
        this.func_184212_Q().func_187227_b(IS_ELITE_PEARL, (Object)this.isElite);
    }

    @Override
    public int getItemMetadata(Entity entity) {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_ELITE_PEARL) != false ? 1 : 0;
    }

    @Override
    public NBTTagCompound getTagCompound(Entity entity) {
        return null;
    }
}

