/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.client.renderer.model.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.client.renderer.model.block.BakedModelBarrel;
import fi.dy.masa.enderutilities.client.renderer.model.block.BakedModelCamouflageBlock;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesBlocks;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class ModelCamouflageBlock {

    public static class ModelLoaderCamouflageBlocks
    implements ICustomModelLoader {
        private static final ResourceLocation LOC_ELEVATOR_NORMAL = new ResourceLocation("enderutilities", "models/block/custom/camo_ender_elevator");
        private static final ResourceLocation LOC_ELEVATOR_SLAB_TOP = new ResourceLocation("enderutilities", "models/block/custom/camo_ender_elevator_slab_top");
        private static final ResourceLocation LOC_ELEVATOR_SLAB_BOTTOM = new ResourceLocation("enderutilities", "models/block/custom/camo_ender_elevator_slab_bottom");
        private static final ResourceLocation LOC_ELEVATOR_LAYER_TOP = new ResourceLocation("enderutilities", "models/block/custom/camo_ender_elevator_layer_top");
        private static final ResourceLocation LOC_ELEVATOR_LAYER_BOTTOM = new ResourceLocation("enderutilities", "models/block/custom/camo_ender_elevator_layer_bottom");
        private static final ResourceLocation LOC_PORTAL_FRAME = new ResourceLocation("enderutilities", "models/block/custom/camo_frame");
        private static final ResourceLocation LOC_DRAW_BRIDGE_N = new ResourceLocation("enderutilities", "models/block/custom/camo_draw_bridge_normal");
        private static final ResourceLocation LOC_DRAW_BRIDGE_A = new ResourceLocation("enderutilities", "models/block/custom/camo_draw_bridge_advanced");
        private static final ResourceLocation LOC_BARREL_NORMAL = new ResourceLocation("enderutilities", "models/block/custom/camo_barrel_normal");
        private static final ResourceLocation LOC_BARREL_CREATIVE = new ResourceLocation("enderutilities", "models/block/custom/camo_barrel_creative");

        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("enderutilities") && modelLocation.func_110623_a().startsWith("models/block/custom/camo_");
        }

        public IModel loadModel(ResourceLocation modelLocation) throws Exception {
            if (modelLocation.equals((Object)LOC_ELEVATOR_NORMAL)) {
                return new ModelElevator(EnderUtilitiesBlocks.ELEVATOR.func_176223_P(), "_full");
            }
            if (modelLocation.equals((Object)LOC_ELEVATOR_SLAB_TOP)) {
                return new ModelElevator(EnderUtilitiesBlocks.ELEVATOR_SLAB.func_176223_P(), "_slab_top");
            }
            if (modelLocation.equals((Object)LOC_ELEVATOR_SLAB_BOTTOM)) {
                return new ModelElevator(EnderUtilitiesBlocks.ELEVATOR_SLAB.func_176223_P(), "_slab_bottom");
            }
            if (modelLocation.equals((Object)LOC_ELEVATOR_LAYER_TOP)) {
                return new ModelElevator(EnderUtilitiesBlocks.ELEVATOR_LAYER.func_176223_P(), "_layer_top");
            }
            if (modelLocation.equals((Object)LOC_ELEVATOR_LAYER_BOTTOM)) {
                return new ModelElevator(EnderUtilitiesBlocks.ELEVATOR_LAYER.func_176223_P(), "_layer_bottom");
            }
            if (modelLocation.equals((Object)LOC_PORTAL_FRAME)) {
                return new ModelCamouflageBlockBase(new ResourceLocation("minecraft:block/cube_all"), null);
            }
            if (modelLocation.equals((Object)LOC_DRAW_BRIDGE_N) || modelLocation.equals((Object)LOC_DRAW_BRIDGE_A)) {
                ResourceLocation baseModelLocation = new ResourceLocation("enderutilities", "block/orientable_directional_individual");
                return new ModelCamouflageBlockBase(baseModelLocation, null);
            }
            if (modelLocation.equals((Object)LOC_BARREL_NORMAL)) {
                return new ModelCamouflageBlockBase(BakedModelBarrel.ModelLoaderBarrel.LOCATION_NORMAL, BakedModelBarrel.ModelLoaderBarrel.LOCATION_NORMAL);
            }
            if (modelLocation.equals((Object)LOC_BARREL_CREATIVE)) {
                return new ModelCamouflageBlockBase(BakedModelBarrel.ModelLoaderBarrel.LOCATION_CREATIVE, BakedModelBarrel.ModelLoaderBarrel.LOCATION_CREATIVE);
            }
            return ModelLoaderRegistry.getMissingModel();
        }

        public void func_110549_a(IResourceManager resourceManager) {
            for (Map.Entry<BlockRenderLayer, Map<ImmutablePair<IBlockState, IBlockState>, ImmutableMap<Optional<EnumFacing>, ImmutableList<BakedQuad>>>> entry : BakedModelCamouflageBlock.QUAD_CACHE.entrySet()) {
                entry.getValue().clear();
            }
        }
    }

    private static class ModelElevator
    extends ModelCamouflageBlockBase {
        public ModelElevator(IBlockState defaultState, String variant) {
            super(new ResourceLocation("enderutilities", "block/ender_elevator" + variant), new ResourceLocation("enderutilities", "block/ender_elevator" + variant + "_overlay"));
        }
    }

    public static class ModelCamouflageBlockBase
    implements IModel {
        protected final ResourceLocation baseModelLocation;
        @Nullable
        protected final ResourceLocation overlayModelLocation;
        protected final ImmutableMap<String, String> textures;
        protected IModel baseModel;
        @Nullable
        protected IModel overlayModel;
        protected static ImmutableList<ResourceLocation> texture_deps = ImmutableList.of();

        protected ModelCamouflageBlockBase(ResourceLocation baseModelLocation, @Nullable ResourceLocation overlayModelLocation) {
            this.baseModelLocation = baseModelLocation;
            this.overlayModelLocation = overlayModelLocation;
            this.textures = ImmutableMap.of();
        }

        protected ModelCamouflageBlockBase(ResourceLocation baseModelLocation, @Nullable ResourceLocation overlayModelLocation, IModel baseModel, @Nullable IModel overlayModel, ImmutableMap<String, String> textures) {
            this.baseModelLocation = baseModelLocation;
            this.overlayModelLocation = overlayModelLocation;
            this.baseModel = baseModel;
            this.overlayModel = overlayModel;
            this.textures = textures;
        }

        public IModelState getDefaultState() {
            return ModelRotation.X0_Y0;
        }

        public Collection<ResourceLocation> getDependencies() {
            if (this.overlayModelLocation != null) {
                return ImmutableList.of((Object)this.baseModelLocation, (Object)this.overlayModelLocation);
            }
            return ImmutableList.of((Object)this.baseModelLocation);
        }

        public Collection<ResourceLocation> getTextures() {
            return texture_deps;
        }

        public IModel retexture(ImmutableMap<String, String> textures) {
            IModel baseModel = ModelLoaderRegistry.getMissingModel();
            IModel overlayModel = null;
            try {
                baseModel = ModelLoaderRegistry.getModel((ResourceLocation)this.baseModelLocation);
                baseModel = baseModel.retexture(textures);
                if (this.overlayModelLocation != null) {
                    overlayModel = ModelLoaderRegistry.getModel((ResourceLocation)this.overlayModelLocation);
                    overlayModel = overlayModel.retexture(textures);
                }
            }
            catch (Exception e) {
                EnderUtilities.logger.warn("Failed to load a model for a camouflage block", (Throwable)e);
            }
            return new ModelCamouflageBlockBase(this.baseModelLocation, this.overlayModelLocation, baseModel, overlayModel, textures);
        }

        public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            return new BakedModelCamouflageBlock(this.baseModel, this.overlayModel, this.textures, state, format, bakedTextureGetter);
        }

        static {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)new ResourceLocation("enderutilities:blocks/ender_elevator_side"));
            builder.add((Object)new ResourceLocation("enderutilities:blocks/ender_elevator_top_overlay"));
            builder.add((Object)new ResourceLocation("enderutilities:blocks/ender_elevator_side_layer"));
            builder.add((Object)new ResourceLocation("enderutilities:blocks/ender_elevator_side_slab"));
            builder.add((Object)new ResourceLocation("enderutilities:blocks/draw_bridge_back"));
            builder.add((Object)new ResourceLocation("enderutilities:blocks/draw_bridge_front_advanced"));
            builder.add((Object)new ResourceLocation("enderutilities:blocks/draw_bridge_front_normal"));
            builder.add((Object)new ResourceLocation("enderutilities:blocks/draw_bridge_side_advanced"));
            builder.add((Object)new ResourceLocation("enderutilities:blocks/draw_bridge_side_normal"));
            builder.add((Object)new ResourceLocation("enderutilities:blocks/frame"));
            texture_deps = builder.build();
        }
    }
}

