/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.experimental.features;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockPistonStructureHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vazkii.quark.automation.feature.PistonsMoveTEs;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.ModuleLoader;

public class CollateralPistonMovement
extends Feature {
    public static Map<ResourceLocation, MoveAction> blockActions;

    @Override
    public void setupConfig() {
        String[] actionArr;
        blockActions = new HashMap<ResourceLocation, MoveAction>();
        String desc = "An array of actions to apply to blocks. Each element is in the following format:\nblockid=action\nWhere blockid is the ID of the block to apply the action to (e.g. minecraft:stone)\nAnd action is one of the following:\nabove - moves all equal blocks above it\nbelow - moves all equal blocks below it\nabove_below - moves all equal blocks above and below it\nabove_edge - moves all equal blocks above it, and one more block of any type that's above the stack\nbelow_edge - moves all equal blocks below it, and one more block of any type that's below the stack\nabove_below_edge - moves all equal blocks above and below it, and one more block of any type that's above or below the stack\ndirectional - moves the block its facing to (only works on directional blocks)\nsides - moves the blocks on all adjacent sides\nhoriozntals - moves the blocks on all adjacent horizontal sides\nverticals - moves the blocks on all adjacent vertical sides";
        for (String s : actionArr = this.loadPropStringList("Actions", desc, new String[]{"quark:chain=below_edge"})) {
            String[] toks = s.split("=");
            if (toks.length != 2) continue;
            String res = toks[0];
            String actionStr = toks[1];
            MoveAction action = null;
            switch (actionStr) {
                case "above": {
                    action = CollateralPistonMovement::moveAllAbove;
                    break;
                }
                case "below": {
                    action = CollateralPistonMovement::moveAllBelow;
                    break;
                }
                case "above_below": {
                    action = CollateralPistonMovement::moveAllAboveBelow;
                    break;
                }
                case "above_edge": {
                    action = CollateralPistonMovement::moveAllAboveAndEdge;
                    break;
                }
                case "below_edge": {
                    action = CollateralPistonMovement::moveAllAboveAndEdge;
                    break;
                }
                case "above_below_edge": {
                    action = CollateralPistonMovement::moveAllAboveBelowAndEdge;
                    break;
                }
                case "directional": {
                    action = CollateralPistonMovement::moveNextDirectional;
                    break;
                }
                case "sides": {
                    action = CollateralPistonMovement::moveSides;
                    break;
                }
                case "horizontals": {
                    action = CollateralPistonMovement::moveHorizontals;
                    break;
                }
                case "verticals": {
                    action = CollateralPistonMovement::moveVerticals;
                }
            }
            if (action == null) continue;
            blockActions.put(new ResourceLocation(res), action);
        }
    }

    public static void applyCollateralMovements(World world, BlockPos sourcePos, BlockPistonStructureHelper helper, EnumFacing facing, boolean extending) {
        if (!ModuleLoader.isFeatureEnabled(CollateralPistonMovement.class)) {
            return;
        }
        List moveList = helper.func_177254_c();
        LinkedList<BlockPos> additions = new LinkedList<BlockPos>();
        for (BlockPos move : moveList) {
            IBlockState moveState = world.func_180495_p(move);
            Block moveBlock = moveState.func_177230_c();
            MoveAction action = blockActions.get(moveBlock.getRegistryName());
            if (action == null) continue;
            action.add(world, move, moveState, facing, extending, additions);
        }
        for (BlockPos add : additions) {
            IBlockState checkState;
            BlockPos check = add.func_177972_a(facing);
            if (moveList.contains(check) || additions.contains(check) || (checkState = world.func_180495_p(check)).func_177230_c().isAir(checkState, (IBlockAccess)world, check) || checkState.func_177230_c().func_176200_f((IBlockAccess)world, check)) continue;
            return;
        }
        moveList.addAll(additions);
    }

    private static BlockPos moveAllEqualSide(World world, BlockPos pos, IBlockState state, EnumFacing side, List<BlockPos> list) {
        BlockPos curr = pos.func_177972_a(side);
        IBlockState stateAt = world.func_180495_p(curr);
        while (stateAt.equals(state)) {
            if (!CollateralPistonMovement.canMove(stateAt, world, curr)) {
                return curr;
            }
            list.add(curr);
            curr = curr.func_177972_a(side);
            stateAt = world.func_180495_p(curr);
        }
        return curr;
    }

    private static void moveAllEqualSideAndOneMore(World world, BlockPos pos, IBlockState state, EnumFacing side, List<BlockPos> list) {
        BlockPos edge = CollateralPistonMovement.moveAllEqualSide(world, pos, state, side, list);
        IBlockState edgeState = world.func_180495_p(edge);
        if (CollateralPistonMovement.canMove(edgeState, world, edge)) {
            list.add(edge);
        }
    }

    private static void moveAllAbove(World world, BlockPos pos, IBlockState state, EnumFacing facing, boolean extending, List<BlockPos> list) {
        CollateralPistonMovement.moveAllEqualSide(world, pos, state, EnumFacing.UP, list);
    }

    private static void moveAllBelow(World world, BlockPos pos, IBlockState state, EnumFacing facing, boolean extending, List<BlockPos> list) {
        CollateralPistonMovement.moveAllEqualSide(world, pos, state, EnumFacing.DOWN, list);
    }

    private static void moveAllAboveBelow(World world, BlockPos pos, IBlockState state, EnumFacing facing, boolean extending, List<BlockPos> list) {
        CollateralPistonMovement.moveAllEqualSide(world, pos, state, EnumFacing.UP, list);
        CollateralPistonMovement.moveAllEqualSide(world, pos, state, EnumFacing.DOWN, list);
    }

    private static void moveAllAboveAndEdge(World world, BlockPos pos, IBlockState state, EnumFacing facing, boolean extending, List<BlockPos> list) {
        CollateralPistonMovement.moveAllEqualSideAndOneMore(world, pos, state, EnumFacing.UP, list);
    }

    private static void moveAllBelowAndEdge(World world, BlockPos pos, IBlockState state, EnumFacing facing, boolean extending, List<BlockPos> list) {
        CollateralPistonMovement.moveAllEqualSideAndOneMore(world, pos, state, EnumFacing.DOWN, list);
    }

    private static void moveAllAboveBelowAndEdge(World world, BlockPos pos, IBlockState state, EnumFacing facing, boolean extending, List<BlockPos> list) {
        CollateralPistonMovement.moveAllEqualSideAndOneMore(world, pos, state, EnumFacing.UP, list);
        CollateralPistonMovement.moveAllEqualSideAndOneMore(world, pos, state, EnumFacing.DOWN, list);
    }

    private static void moveNextDirectional(World world, BlockPos pos, IBlockState state, EnumFacing facing, boolean extending, List<BlockPos> list) {
        EnumFacing direction = CollateralPistonMovement.getStateFacing(state);
        if (direction != null) {
            CollateralPistonMovement.moveSideIterable(world, pos, facing, list, new EnumFacing[]{direction});
        }
    }

    private static void moveSides(World world, BlockPos pos, IBlockState state, EnumFacing facing, boolean extending, List<BlockPos> list) {
        CollateralPistonMovement.moveSideIterable(world, pos, facing, list, EnumFacing.field_82609_l);
    }

    private static void moveHorizontals(World world, BlockPos pos, IBlockState state, EnumFacing facing, boolean extending, List<BlockPos> list) {
        CollateralPistonMovement.moveSideIterable(world, pos, facing, list, EnumFacing.field_176754_o);
    }

    private static void moveVerticals(World world, BlockPos pos, IBlockState state, EnumFacing facing, boolean extending, List<BlockPos> list) {
        CollateralPistonMovement.moveSideIterable(world, pos, facing, list, new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN});
    }

    private static void moveSideIterable(World world, BlockPos pos, EnumFacing facing, List<BlockPos> list, EnumFacing[] directions) {
        for (EnumFacing direction : directions) {
            BlockPos nextPos;
            IBlockState nextState;
            if (direction == facing.func_176734_d() || !CollateralPistonMovement.canMove(nextState = world.func_180495_p(nextPos = pos.func_177972_a(direction)), world, nextPos)) continue;
            list.add(nextPos);
        }
    }

    private static boolean canMove(IBlockState state, World world, BlockPos pos) {
        Block block = state.func_177230_c();
        if (block == Blocks.field_150331_J || block == Blocks.field_150320_F) {
            return (Boolean)state.func_177229_b((IProperty)BlockPistonBase.field_176320_b) == false;
        }
        return !block.isAir(state, (IBlockAccess)world, pos) && state.func_185905_o() == EnumPushReaction.NORMAL && (!block.func_149716_u() || !PistonsMoveTEs.shouldMoveTE(true, state));
    }

    private static EnumFacing getStateFacing(IBlockState state) {
        Collection props = state.func_177227_a();
        for (IProperty prop : props) {
            Comparable obj;
            if (!prop.func_177701_a().equals("facing") || !((obj = state.func_177229_b(prop)) instanceof EnumFacing)) continue;
            return (EnumFacing)obj;
        }
        return null;
    }

    private static interface MoveAction {
        public void add(World var1, BlockPos var2, IBlockState var3, EnumFacing var4, boolean var5, List<BlockPos> var6);
    }
}

