/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.client;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import vazkii.quark.base.lib.LibObfuscation;

public class ContributorRewardHandler {
    private static final ImmutableSet<String> UUIDS = ImmutableSet.of((Object)"8c826f34-113b-4238-a173-44639c53b6e6", (Object)"0d054077-a977-4b19-9df9-8a4d5bf20ec3");
    private static final Set<EntityPlayer> done = Collections.newSetFromMap(new WeakHashMap());
    public static int localPatronTier = 0;
    public static String featuredPatron = "";

    public static void init() {
        MinecraftForge.EVENT_BUS.register(ContributorRewardHandler.class);
        new ThreadContributorListLoader();
    }

    @SubscribeEvent
    public static void onRenderPlayer(RenderPlayerEvent.Post event) {
        AbstractClientPlayer clplayer;
        EntityPlayer player = event.getEntityPlayer();
        String uuid = EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()).toString();
        if (player instanceof AbstractClientPlayer && UUIDS.contains((Object)uuid) && !done.contains(player) && (clplayer = (AbstractClientPlayer)player).func_152122_n()) {
            NetworkPlayerInfo info = (NetworkPlayerInfo)ReflectionHelper.getPrivateValue(AbstractClientPlayer.class, (Object)clplayer, (String[])LibObfuscation.PLAYER_INFO);
            Map textures = (Map)ReflectionHelper.getPrivateValue(NetworkPlayerInfo.class, (Object)info, (String[])LibObfuscation.PLAYER_TEXTURES);
            ResourceLocation loc = new ResourceLocation("quark", "textures/misc/dev_cape.png");
            textures.put(MinecraftProfileTexture.Type.CAPE, loc);
            textures.put(MinecraftProfileTexture.Type.ELYTRA, loc);
            done.add(player);
        }
    }

    private static void load(Properties props) {
        ArrayList allPatrons = new ArrayList(props.size());
        String name = Minecraft.func_71410_x().func_110432_I().func_111285_a().toLowerCase();
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String key = (String)k;
            String value = (String)v;
            int tier = Integer.parseInt(value);
            if (tier < 10) {
                allPatrons.add(key);
            }
            if (key.toLowerCase().equals(name)) {
                localPatronTier = tier;
            }
        }));
        if (!allPatrons.isEmpty()) {
            featuredPatron = (String)allPatrons.get((int)(Math.random() * (double)allPatrons.size()));
        }
    }

    private static class ThreadContributorListLoader
    extends Thread {
        public ThreadContributorListLoader() {
            this.setName("Quark Contributor Loading Thread");
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            try {
                URL url = new URL("https://raw.githubusercontent.com/Vazkii/Quark/master/contributors.properties");
                Properties props = new Properties();
                try (InputStreamReader reader = new InputStreamReader(url.openStream());){
                    props.load(reader);
                    ContributorRewardHandler.load(props);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

