/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.togetherforever.action;

import com.buuz135.togetherforever.TogetherForever;
import com.buuz135.togetherforever.action.recovery.AdvancementOfflineRecovery;
import com.buuz135.togetherforever.api.IPlayerInformation;
import com.buuz135.togetherforever.api.ITogetherTeam;
import com.buuz135.togetherforever.api.action.EventSyncAction;
import com.buuz135.togetherforever.api.annotation.SyncAction;
import com.buuz135.togetherforever.config.TogetherForeverConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.player.AdvancementEvent;

@SyncAction(id="advancement_event_sync")
public class AdvancementEventSyncAction
extends EventSyncAction<AdvancementEvent, AdvancementOfflineRecovery> {
    public AdvancementEventSyncAction() {
        super(AdvancementEvent.class, AdvancementOfflineRecovery.class);
    }

    public static void grantAllParentAchievements(EntityPlayerMP player, Advancement advancement) {
        if (advancement.func_192070_b() != null) {
            AdvancementEventSyncAction.grantAllParentAchievements(player, advancement.func_192070_b());
        }
        TogetherForever.LOGGER.debug("Advancement granting: " + advancement.func_192067_g().toString());
        for (String string : player.func_192039_O().func_192747_a(advancement).func_192107_d()) {
            player.func_192039_O().func_192750_a(advancement, string);
        }
    }

    @Override
    public List<IPlayerInformation> triggerSync(AdvancementEvent object, ITogetherTeam togetherTeam) {
        ArrayList<IPlayerInformation> playerInformations = new ArrayList<IPlayerInformation>();
        TogetherForever.LOGGER.debug("Starting to sync advancement " + object.getAdvancement().func_192067_g().toString());
        if (!TogetherForeverConfig.advancementSync) {
            return playerInformations;
        }
        for (IPlayerInformation information : togetherTeam.getPlayers()) {
            EntityPlayerMP playerMP = information.getPlayer();
            if (playerMP == null) {
                TogetherForever.LOGGER.debug(information.getName() + " is not online, adding it to the offline recovery!");
                playerInformations.add(information);
                continue;
            }
            TogetherForever.LOGGER.debug("Trying to grant all the parent advancements to the player " + information.getName());
            AdvancementEventSyncAction.grantAllParentAchievements(playerMP, object.getAdvancement());
        }
        return playerInformations;
    }

    @Override
    public void syncJoinPlayer(IPlayerInformation toBeSynced, IPlayerInformation teamMember) {
        if (teamMember.getPlayer() != null && toBeSynced.getPlayer() != null) {
            EntityPlayerMP member = teamMember.getPlayer();
            EntityPlayerMP sync = toBeSynced.getPlayer();
            for (Advancement advancement : member.func_71121_q().func_191952_z().func_192780_b()) {
                for (String crit : member.func_192039_O().func_192747_a(advancement).func_192102_e()) {
                    sync.func_192039_O().func_192750_a(advancement, crit);
                }
            }
        }
    }

    @Override
    public NBTTagCompound transformEventToNBT(AdvancementEvent event) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("AdvancementId", event.getAdvancement().func_192067_g().toString());
        return compound;
    }
}

