/*
 * Decompiled with CFR 0.152.
 */
package com.teamdman.animus.items.sigils;

import WayofTime.bloodmagic.core.data.Binding;
import WayofTime.bloodmagic.core.data.SoulTicket;
import WayofTime.bloodmagic.iface.ISigil;
import WayofTime.bloodmagic.util.ChatUtil;
import WayofTime.bloodmagic.util.helper.NBTHelper;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import WayofTime.bloodmagic.util.helper.PlayerHelper;
import WayofTime.bloodmagic.util.helper.TextHelper;
import com.teamdman.animus.AnimusConfig;
import com.teamdman.animus.items.sigils.ItemSigilToggleableBaseBase;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSigilTransposition
extends ItemSigilToggleableBaseBase {
    public ItemSigilTransposition() {
        super("transposition", 5000);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() instanceof ISigil.Holding) {
            stack = ((ISigil.Holding)stack.func_77973_b()).getHeldItem(stack, player);
        }
        if (PlayerHelper.isFakePlayer((EntityPlayer)player)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        if (world.field_72995_K || this.isUnusable(stack)) {
            return super.func_77659_a(world, player, hand);
        }
        RayTraceResult result = this.func_77621_a(world, player, true);
        if (result == null || result.field_72313_a == RayTraceResult.Type.MISS || result.field_72313_a != RayTraceResult.Type.BLOCK) {
            NBTHelper.checkNBT((ItemStack)stack);
            stack.func_77978_p().func_74772_a("pos", 0L);
            ChatUtil.sendNoSpam((EntityPlayer)player, (String[])new String[]{"text.component.animus.transposition.cleared"});
            this.setActivatedState(stack, false);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos blockPos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        Binding binding;
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() instanceof ISigil.Holding) {
            stack = ((ISigil.Holding)stack.func_77973_b()).getHeldItem(stack, player);
        }
        if ((binding = this.getBinding(stack)) == null) {
            return EnumActionResult.PASS;
        }
        if (!this.isUnusable(stack) && !world.field_72995_K) {
            NBTHelper.checkNBT((ItemStack)stack);
            IBlockState state = world.func_180495_p(blockPos);
            if (!this.getActivated(stack)) {
                if (AnimusConfig.sigils.transpositionMovesUnbreakables < 2 && state.func_185887_b(world, blockPos) == -1.0f) {
                    return EnumActionResult.PASS;
                }
                stack.func_77978_p().func_74772_a("pos", blockPos.func_177986_g());
                ChatUtil.sendNoSpamUnloc((EntityPlayer)player, (String[])new String[]{"text.component.animus.transposition.set"});
                world.func_184133_a(null, blockPos, SoundEvents.field_187791_eX, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.setActivatedState(stack, true);
            } else {
                BlockPos posOld = BlockPos.func_177969_a((long)stack.func_77978_p().func_74763_f("pos"));
                BlockPos posNew = blockPos.func_177972_a(side);
                if (AnimusConfig.sigils.transpositionMovesUnbreakables == 0 && world.func_180495_p(posOld).func_185887_b(world, posOld) == -1.0f) {
                    stack.func_77978_p().func_74772_a("pos", 0L);
                    world.func_184133_a(null, posNew, SoundEvents.field_187767_eL, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    this.setActivatedState(stack, false);
                    ChatUtil.sendNoSpamUnloc((EntityPlayer)player, (String[])new String[]{"text.component.animus.transposition.unmovable"});
                    return EnumActionResult.PASS;
                }
                TileEntity tileOld = world.func_175625_s(posOld);
                if (world.func_175623_d(posNew)) {
                    NetworkHelper.getSoulNetwork((EntityPlayer)player).syphonAndDamage(player, new SoulTicket((ITextComponent)new TextComponentTranslation("text.component.animus.ticket.transposition", new Object[0]), this.getLpUsed()));
                    world.func_175656_a(posNew, world.func_180495_p(posOld));
                    TileEntity tileNew = world.func_175625_s(posNew);
                    if (tileNew != null && tileOld != null) {
                        NBTTagCompound inv = tileOld.serializeNBT();
                        inv.func_74768_a("x", posNew.func_177958_n());
                        inv.func_74768_a("y", posNew.func_177956_o());
                        inv.func_74768_a("z", posNew.func_177952_p());
                        tileNew.deserializeNBT(inv);
                        world.func_175713_t(posOld);
                    }
                    world.func_175698_g(posOld);
                    world.func_184133_a(null, posNew, SoundEvents.field_187561_bM, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    stack.func_77978_p().func_74772_a("pos", 0L);
                    this.setActivatedState(stack, false);
                } else {
                    ChatUtil.sendNoSpamUnloc((EntityPlayer)player, (String[])new String[]{"text.component.animus.diviner.obstructed"});
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        Binding binding;
        tooltip.add(TextHelper.localize((String)"tooltip.animus.sigil.transposition.flavour", (Object[])new Object[0]));
        NBTHelper.checkNBT((ItemStack)stack);
        if (stack.func_77978_p().func_74763_f("pos") != 0L) {
            tooltip.add(TextHelper.localize((String)"tooltip.animus.sigil.transposition.stored", (Object[])new Object[0]));
        }
        if ((binding = this.getBinding(stack)) == null) {
            return;
        }
        tooltip.add(TextHelper.localizeEffect((String)"tooltip.animus.currentOwner", (Object[])new Object[]{binding.getOwnerName()}));
    }
}

