/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.effects;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.math.interpolate.numeric.InterpFloatInOut;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModuleEffect;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceEffect;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.init.ModPotions;
import com.teamwizardry.wizardry.init.ModSounds;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@RegisterModule(ID="effect_shatter")
public class ModuleEffectShatter
implements IModuleEffect {
    @Override
    public String[] compatibleModifiers() {
        return new String[]{"modifier_increase_potency"};
    }

    @Override
    public boolean run(ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        Entity targetEntity = spell.getVictim();
        Entity caster = spell.getCaster();
        BlockPos pos = spell.getTargetPos();
        if (pos == null) {
            return false;
        }
        double potency = spellRing.getAttributeValue(AttributeRegistry.POTENCY, spell) / 2.0;
        if (!spellRing.taxCaster(spell, true)) {
            return false;
        }
        if (targetEntity instanceof EntityLivingBase) {
            PotionEffect slowness = ((EntityLivingBase)targetEntity).func_70660_b(MobEffects.field_76421_d);
            PotionEffect frost = ((EntityLivingBase)targetEntity).func_70660_b((Potion)ModPotions.SLIPPERY);
            int mult = 0;
            if (slowness != null) {
                mult += slowness.func_76458_c() + 1;
            }
            if (frost != null) {
                mult += frost.func_76458_c() + 1;
            }
            potency *= 1.0 + (double)mult * 0.5;
            int invTime = targetEntity.field_70172_ad;
            targetEntity.field_70172_ad = 0;
            spell.world.func_184133_a(null, pos, (SoundEvent)ModSounds.MARBLE_EXPLOSION, SoundCategory.NEUTRAL, 2.0f, RandUtil.nextFloat(0.8f, 1.2f));
            spell.world.func_184133_a(null, pos, (SoundEvent)ModSounds.FIREWORK, SoundCategory.NEUTRAL, 2.0f, RandUtil.nextFloat(0.8f, 1.2f));
            if (caster instanceof EntityLivingBase) {
                ((EntityLivingBase)caster).func_130011_c(targetEntity);
                if (caster instanceof EntityPlayer) {
                    targetEntity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)caster)).func_82726_p(), (float)potency);
                } else {
                    targetEntity.func_70097_a(new DamageSource("generic").func_82726_p(), (float)potency);
                }
            } else {
                targetEntity.func_70097_a(new DamageSource("generic").func_82726_p(), (float)potency);
            }
            targetEntity.field_70172_ad = invTime;
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        World world = spell.world;
        Vec3d position = spell.getTarget();
        if (position == null) {
            return;
        }
        ParticleBuilder glitter = new ParticleBuilder(10);
        glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        glitter.setCollision(true);
        glitter.setCanBounce(true);
        glitter.disableRandom();
        glitter.setDeceleration(new Vec3d(0.5, 0.5, 0.5));
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)position), (int)100, (int)0, (i, builder) -> {
            builder.setLifetime(RandUtil.nextInt(30, 60));
            builder.setScale((float)RandUtil.nextDouble(0.3, 0.5));
            builder.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.0f, 0.3f));
            builder.setColor(RandUtil.nextBoolean() ? spellRing.getPrimaryColor() : spellRing.getSecondaryColor());
            builder.setAcceleration(new Vec3d(0.0, 0.001, 0.0));
            double radius = 1.0;
            double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
            double r = radius * (double)RandUtil.nextFloat();
            double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
            double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
            builder.setMotion(new Vec3d(x, RandUtil.nextDouble(-radius, radius), z).func_72432_b().func_186678_a((double)RandUtil.nextFloat(2.0f)));
            builder.setTick(particle -> {
                if (particle.getAge() > 15) {
                    particle.setAcceleration(new Vec3d(RandUtil.nextDouble(-0.01, 0.01), RandUtil.nextDouble(0.01, 0.03), RandUtil.nextDouble(-0.01, 0.01)));
                    particle.setJitterChance(1.0f);
                    particle.setJitterMagnitude(new Vec3d(RandUtil.nextDouble(-0.05, 0.05), 0.0, RandUtil.nextDouble(-0.05, 0.05)));
                }
            });
        });
    }
}

