/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.core.version;

import com.teamwizardry.librarianlib.core.LibrarianLib;
import com.teamwizardry.wizardry.Wizardry;
import com.teamwizardry.wizardry.api.ConfigValues;
import com.teamwizardry.wizardry.common.core.version.VersionChecker;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;

public class ThreadVersionChecker
extends Thread {
    public ThreadVersionChecker() {
        this.setName("Wizardry Version Checker Thread");
        this.setDaemon(true);
        if (ConfigValues.versionCheckerEnabled) {
            this.start();
        }
    }

    @Override
    public void run() {
        Wizardry.logger.info("Checking for new updates...");
        try {
            String line;
            URL url = LibrarianLib.DEV_ENVIRONMENT ? new URL("https://raw.githubusercontent.com/TeamWizardry/Wizardry/master/version/1.12.2-dev.txt") : new URL("https://raw.githubusercontent.com/TeamWizardry/Wizardry/master/version/1.12.2.txt");
            BufferedReader r = new BufferedReader(new InputStreamReader(url.openStream()));
            StringBuilder text = new StringBuilder();
            while ((line = r.readLine()) != null) {
                if (VersionChecker.onlineVersion == null) {
                    VersionChecker.onlineVersion = line;
                    text.append("VERSION: ").append(VersionChecker.onlineVersion).append("\n");
                    continue;
                }
                if (line.isEmpty()) continue;
                if (line.matches("[0-9.]*")) {
                    text.append("\n").append("VERSION: ").append(line).append("\n");
                    continue;
                }
                text.append(" - ").append(line).append("\n");
            }
            VersionChecker.updateMessage = text.toString();
            r.close();
            Wizardry.logger.error("New version found! -> " + VersionChecker.onlineVersion);
            Wizardry.logger.error("Message: " + VersionChecker.updateMessage);
        }
        catch (Exception e) {
            Wizardry.logger.error("Failed to check for updates! :(");
        }
        VersionChecker.doneChecking = true;
    }
}

