/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.client.render.block;

import com.teamwizardry.wizardry.api.capability.mana.CapManager;
import com.teamwizardry.wizardry.common.tile.TilePearlHolder;
import com.teamwizardry.wizardry.init.ModBlocks;
import java.awt.Color;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class TilePearlHolderRenderer
extends TileEntitySpecialRenderer<TilePearlHolder> {
    private static ResourceLocation pearlTexture = new ResourceLocation("wizardry", "textures/blocks/pearl_cube.png");
    private static ResourceLocation manaOrb = new ResourceLocation("wizardry", "textures/blocks/mana_orb_cube.png");
    private static ResourceLocation glassOrb = new ResourceLocation("wizardry", "textures/blocks/glass_orb_cube.png");
    private static final double TX = 0.25;

    public void render(TilePearlHolder te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (te.containsSomething()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
            GlStateManager.func_179101_C();
            float sin = (float)Math.sin((double)((float)te.func_145831_w().func_82737_E() + partialTicks + (float)te.func_174877_v().hashCode()) / 10.0);
            boolean gravitating = false;
            if (te.containsSomething()) {
                BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(te.func_174877_v());
                for (int i = -6; i < 6; ++i) {
                    block1: for (int j = -6; j < 6; ++j) {
                        for (int k = -6; k < 6; ++k) {
                            Vec3d direction;
                            pos.func_181079_c(te.func_174877_v().func_177958_n() + i, te.func_174877_v().func_177956_o() + j, te.func_174877_v().func_177952_p() + k);
                            Block block = te.func_145831_w().func_180495_p((BlockPos)pos).func_177230_c();
                            if (te.containsNacrePearl() && block == ModBlocks.MANA_MAGNET) {
                                gravitating = true;
                                direction = new Vec3d((Vec3i)te.func_174877_v()).func_178788_d(new Vec3d((Vec3i)pos)).func_72432_b();
                                GlStateManager.func_179137_b((double)((double)sin * direction.field_72450_a / 5.0), (double)((double)sin * direction.field_72448_b / 5.0), (double)((double)sin * direction.field_72449_c / 5.0));
                                continue block1;
                            }
                            if (!te.containsAnyOrb() || block != ModBlocks.MANA_BATTERY) continue;
                            gravitating = true;
                            direction = new Vec3d((Vec3i)te.func_174877_v()).func_178788_d(new Vec3d((Vec3i)pos)).func_72432_b();
                            GlStateManager.func_179137_b((double)((double)sin * direction.field_72450_a / 5.0), (double)((double)sin * direction.field_72448_b / 5.0), (double)((double)sin * direction.field_72449_c / 5.0));
                            continue block1;
                        }
                    }
                }
            }
            if (!gravitating) {
                GlStateManager.func_179137_b((double)0.0, (double)((double)sin / 10.0), (double)0.0);
            }
            GlStateManager.func_179114_b((float)(((float)te.func_145831_w().func_82737_E() + partialTicks) * 4.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)0.0, (double)0.6, (double)0.0);
            GlStateManager.func_179114_b((float)45.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179129_p();
            GlStateManager.func_179145_e();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderHelper.func_74518_a();
            if (te.containsNacrePearl()) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(pearlTexture);
                TilePearlHolderRenderer.renderCube(0.1, new Color(Minecraft.func_71410_x().getItemColors().func_186728_a(te.getItemStack(), 0)));
            } else if (te.containsAnyOrb()) {
                Color c = new Color(1.0f, 1.0f, 1.0f, (float)(CapManager.getMana(te.getWizardryCap()) / CapManager.getMaxMana(te.getWizardryCap())));
                Minecraft.func_71410_x().func_110434_K().func_110577_a(manaOrb);
                TilePearlHolderRenderer.renderCube(0.13, c);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(glassOrb);
                TilePearlHolderRenderer.renderCube(0.135, new Color(1.0f, 1.0f, 1.0f, 0.8f));
            }
            GlStateManager.func_179101_C();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }

    private static void side(Tessellator tess, double scale, Color color, EnumFacing facing, double u, double v) {
        int normalX = facing.func_82601_c();
        int normalY = facing.func_96559_d();
        int normalZ = facing.func_82599_e();
        BufferBuilder bf = tess.func_178180_c();
        bf.func_181668_a(5, DefaultVertexFormats.field_181709_i);
        for (int vertex = 0; vertex <= 3; ++vertex) {
            int z;
            int vertexU = vertex & 1;
            int vertexV = (vertex & 2) >> 1;
            int crossU = 1 - 2 * vertexU;
            int crossV = 1 - 2 * vertexV;
            int x = normalX == 0 ? crossU : normalX;
            int n = z = normalZ == 0 ? crossV : normalZ;
            int y = normalY == 0 ? (normalX != 0 ? crossU : crossV) : normalY;
            TilePearlHolderRenderer.vertex(bf, scale, x, y, z, u, v, vertexU, vertexV, color);
        }
        tess.func_78381_a();
    }

    private static void vertex(BufferBuilder bf, double scale, int xDir, int yDir, int zDir, double startU, double startV, double uAmount, double vAmount, Color color) {
        bf.func_181662_b(scale * (double)xDir, scale * (double)yDir, scale * (double)zDir).func_187315_a((startU + uAmount) * 0.25, (startV + vAmount) * 0.25).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
    }

    public static void renderCube(double scale, Color color) {
        Tessellator tess = Tessellator.func_178181_a();
        TilePearlHolderRenderer.side(tess, scale, color, EnumFacing.DOWN, 2.0, 0.0);
        TilePearlHolderRenderer.side(tess, scale, color, EnumFacing.UP, 1.0, 0.0);
        TilePearlHolderRenderer.side(tess, scale, color, EnumFacing.NORTH, 1.0, 1.0);
        TilePearlHolderRenderer.side(tess, scale, color, EnumFacing.SOUTH, 3.0, 1.0);
        TilePearlHolderRenderer.side(tess, scale, color, EnumFacing.WEST, 2.0, 1.0);
        TilePearlHolderRenderer.side(tess, scale, color, EnumFacing.EAST, 0.0, 1.0);
    }
}

