/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.client.gui.worktable;

import com.teamwizardry.librarianlib.core.LibrarianLib;
import com.teamwizardry.librarianlib.core.client.ClientTickHandler;
import com.teamwizardry.librarianlib.features.animator.Animation;
import com.teamwizardry.librarianlib.features.animator.Easing;
import com.teamwizardry.librarianlib.features.animator.animations.BasicAnimation;
import com.teamwizardry.librarianlib.features.eventbus.Event;
import com.teamwizardry.librarianlib.features.gui.EnumMouseButton;
import com.teamwizardry.librarianlib.features.gui.component.GuiComponent;
import com.teamwizardry.librarianlib.features.gui.component.GuiComponentEvents;
import com.teamwizardry.librarianlib.features.gui.components.ComponentVoid;
import com.teamwizardry.librarianlib.features.gui.mixin.DragMixin;
import com.teamwizardry.librarianlib.features.math.Vec2d;
import com.teamwizardry.librarianlib.features.math.interpolate.position.InterpBezier2D;
import com.teamwizardry.librarianlib.features.sprite.Sprite;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstance;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceModifier;
import com.teamwizardry.wizardry.api.spell.module.ModuleRegistry;
import com.teamwizardry.wizardry.api.spell.module.ModuleType;
import com.teamwizardry.wizardry.client.gui.worktable.WorktableGui;
import com.teamwizardry.wizardry.init.ModSounds;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import org.jetbrains.annotations.NotNull;

public class TableModule
extends GuiComponent {
    private boolean errored = false;
    @Nonnull
    private final WorktableGui worktable;
    @Nonnull
    private final ModuleInstance module;
    private final boolean draggable;
    private final Sprite icon;
    private final boolean benign;
    public float radius = 16.0f;
    public float textRadius = 10.0f;
    @Nullable
    private TableModule linksTo = null;
    private boolean enableTooltip;
    private Vec2d initialPos;

    public TableModule(@Nonnull WorktableGui worktable, @Nonnull ModuleInstance module, boolean draggable, boolean benign) {
        super(0, 0, WorktableGui.PLATE.getWidth(), WorktableGui.PLATE.getHeight());
        this.worktable = worktable;
        this.module = module;
        this.draggable = draggable;
        this.icon = new Sprite(module.getIconLocation());
        this.benign = this.enableTooltip = benign;
        this.initialPos = this.thisPosToOtherContext(null);
        ComponentVoid paper = worktable.paper;
        if (draggable) {
            this.getTransform().setTranslateZ(30.0);
        }
        if (!benign && draggable) {
            this.setData(UUID.class, "uuid", UUID.randomUUID());
        }
        if (!benign && !draggable) {
            this.BUS.hook(GuiComponentEvents.MouseDownEvent.class, event -> {
                if (worktable.animationPlaying) {
                    return;
                }
                if (event.getButton() == EnumMouseButton.LEFT && this.getMouseOver()) {
                    Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ModSounds.BUTTON_CLICK_IN, 1.0f, 1.0f);
                    TableModule item = new TableModule(this.worktable, this.module, true, false);
                    item.setPos(paper.otherPosToThisContext(event.component, event.getMousePos()));
                    DragMixin drag = new DragMixin((GuiComponent)item, vec2d -> vec2d);
                    drag.setDragOffset(new Vec2d(6.0, 6.0));
                    drag.setMouseDown(event.getButton());
                    paper.add(new GuiComponent[]{item});
                    event.cancel();
                }
            });
        }
        if (!benign) {
            this.BUS.hook(DragMixin.DragPickupEvent.class, event -> {
                if (worktable.animationPlaying) {
                    return;
                }
                if (!this.getMouseOver()) {
                    return;
                }
                if (this.isErrored()) {
                    this.setErrored(false);
                    TableModule.deselect(this);
                }
                this.initialPos = event.component.thisPosToOtherContext(null);
                if (event.getButton() == EnumMouseButton.RIGHT) {
                    event.component.addTag((Object)"connecting");
                    Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ModSounds.POP, 1.0f, 1.0f);
                }
            });
        }
        if (!benign) {
            this.BUS.hook(DragMixin.DragMoveEvent.class, event -> {
                if (this.isErrored()) {
                    this.setErrored(false);
                    TableModule.deselect(this);
                }
                if (worktable.animationPlaying || event.getButton() == EnumMouseButton.RIGHT) {
                    event.setNewPos(event.getPos());
                }
            });
        }
        if (!benign) {
            this.BUS.hook(DragMixin.DragDropEvent.class, event -> {
                boolean isInsidePaper;
                if (worktable.animationPlaying) {
                    return;
                }
                if (!event.component.hasTag((Object)"placed")) {
                    event.component.addTag((Object)"placed");
                }
                if (this.isErrored()) {
                    this.setErrored(false);
                    TableModule.deselect(this);
                }
                Vec2d currentPos = event.component.thisPosToOtherContext(null);
                if (event.getButton() == EnumMouseButton.LEFT && this.initialPos.squareDist(currentPos) < 0.1) {
                    if (worktable.selectedModule == this) {
                        Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ModSounds.BUTTON_CLICK_OUT, 1.0f, 1.0f);
                        worktable.selectedModule = null;
                        TableModule.deselect(this);
                    } else {
                        Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ModSounds.BUTTON_CLICK_IN, 1.0f, 1.0f);
                        if (worktable.selectedModule != null) {
                            TableModule.unhoverOver(worktable.selectedModule);
                        }
                        worktable.selectedModule = this;
                        TableModule.select(this);
                    }
                    worktable.modifiers.refresh();
                    event.component.removeTag((Object)"connecting");
                    return;
                }
                Vec2d plateSize = paper.getSize();
                Vec2d platePos = event.component.getPos();
                boolean bl = isInsidePaper = platePos.getX() >= 0.0 && platePos.getX() <= plateSize.getX() && platePos.getY() >= 0.0 && platePos.getY() <= plateSize.getY();
                if (!isInsidePaper) {
                    if (!event.component.hasTag((Object)"connecting")) {
                        for (GuiComponent paperComponent : paper.getChildren()) {
                            TableModule linkTo;
                            if (paperComponent == event.component || !(paperComponent instanceof TableModule) || (linkTo = (TableModule)paperComponent).getLinksTo() != this) continue;
                            linkTo.setLinksTo(null);
                        }
                        if (worktable.selectedModule == this) {
                            worktable.selectedModule = null;
                        }
                        Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ModSounds.ZOOM, 1.0f, 1.0f);
                        event.component.invalidate();
                        if (event.component.hasTag((Object)"placed")) {
                            worktable.setToastMessage("", Color.GREEN);
                        }
                        worktable.modifiers.refresh();
                    }
                    event.component.removeTag((Object)"connecting");
                    worktable.paper.BUS.fire((Event)new ModuleUpdateEvent());
                    worktable.syncToServer();
                    return;
                }
                if (event.component.hasTag((Object)"connecting")) {
                    for (GuiComponent paperComponent : paper.getChildren()) {
                        if (paperComponent == event.component || !paperComponent.geometry.getMouseOverNoOcclusion() || !(paperComponent instanceof TableModule)) continue;
                        TableModule linkTo = (TableModule)paperComponent;
                        if (!linkTo.draggable || linkTo == this) continue;
                        if (this.getLinksTo() == linkTo) {
                            event.component.removeTag((Object)"connecting");
                            this.setLinksTo(null);
                            worktable.setToastMessage("", Color.GREEN);
                            worktable.paper.BUS.fire((Event)new ModuleUpdateEvent());
                            worktable.syncToServer();
                            return;
                        }
                        if (linkTo.getLinksTo() == this) {
                            this.setLinksTo(null);
                            linkTo.setLinksTo(null);
                        } else {
                            boolean linkedFrom = false;
                            for (GuiComponent component : paper.getChildren()) {
                                TableModule child;
                                if (!(component instanceof TableModule) || (child = (TableModule)component).getLinksTo() != linkTo) continue;
                                child.setLinksTo(null);
                                linkedFrom = true;
                                if (!child.isErrored()) continue;
                                child.setErrored(false);
                                TableModule.deselect(child);
                            }
                            if (linkTo.getLinksTo() != null && linkedFrom) {
                                linkTo.setLinksTo(null);
                            }
                            this.setLinksTo(linkTo);
                            if (linkTo.isErrored()) {
                                linkTo.setErrored(false);
                                TableModule.deselect(linkTo);
                            }
                            if (this.isErrored()) {
                                this.setErrored(false);
                                TableModule.deselect(this);
                            }
                        }
                        Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ModSounds.BELL_TING, 1.0f, 1.0f);
                        worktable.setToastMessage("", Color.GREEN);
                        worktable.paper.BUS.fire((Event)new ModuleUpdateEvent());
                        worktable.syncToServer();
                        event.component.removeTag((Object)"connecting");
                        return;
                    }
                }
                event.component.removeTag((Object)"connecting");
                worktable.paper.BUS.fire((Event)new ModuleUpdateEvent());
                worktable.syncToServer();
            });
        }
        if (!benign || this.enableTooltip) {
            this.render.getTooltip().func(t -> {
                ArrayList<String> txt = new ArrayList<String>();
                if (worktable.animationPlaying) {
                    return txt;
                }
                if (t.hasTag((Object)"connecting")) {
                    return txt;
                }
                txt.add(TextFormatting.GOLD + module.getReadableName());
                if (GuiScreen.func_146272_n()) {
                    txt.add(TextFormatting.GRAY + module.getDescription());
                    if (module.getAttributeRanges().keySet().stream().anyMatch(attribute -> attribute.hasDetailedText())) {
                        if (GuiScreen.func_146271_m()) {
                            module.getDetailedInfo().forEach(info -> txt.add(TextFormatting.GRAY + info));
                        } else {
                            txt.add(TextFormatting.GRAY + LibrarianLib.PROXY.translate("wizardry.misc.ctrl", new Object[0]));
                        }
                    }
                } else {
                    txt.add(TextFormatting.GRAY + LibrarianLib.PROXY.translate("wizardry.misc.sneak", new Object[0]));
                }
                return txt;
            });
        }
        if (!benign) {
            this.BUS.hook(GuiComponentEvents.MouseInEvent.class, event -> {
                if (worktable.animationPlaying) {
                    return;
                }
                if (this.isErrored() || worktable.selectedModule == this) {
                    return;
                }
                TableModule.hoverOver(this);
            });
        }
        if (!benign) {
            this.BUS.hook(GuiComponentEvents.MouseOutEvent.class, event -> {
                if (worktable.animationPlaying) {
                    return;
                }
                if (this.isErrored() || worktable.selectedModule == this) {
                    return;
                }
                TableModule.unhoverOver(this);
            });
        }
    }

    public static void select(TableModule module) {
        Vec2d toSize = new Vec2d(24.0, 24.0);
        BasicAnimation animSize = new BasicAnimation((Object)module, "size");
        animSize.setDuration(5.0f);
        animSize.setEasing((Easing)Easing.easeOutCubic);
        animSize.setTo((Object)toSize);
        module.add(new Animation[]{animSize});
        BasicAnimation animPos = new BasicAnimation((Object)module, "pos");
        animPos.setDuration(5.0f);
        animPos.setEasing((Easing)Easing.easeOutCubic);
        animPos.setTo((Object)module.getPos().add(module.getSize().sub(toSize).mul(0.5)));
        module.add(new Animation[]{animPos});
        BasicAnimation animRadius = new BasicAnimation((Object)module, "radius");
        animRadius.setDuration(20.0f);
        animRadius.setEasing((Easing)Easing.easeOutCubic);
        animRadius.setTo((Object)24);
        module.add(new Animation[]{animRadius});
        BasicAnimation animText = new BasicAnimation((Object)module, "textRadius");
        animText.setDuration(40.0f);
        animText.setEasing((Easing)Easing.easeOutCubic);
        animText.setTo((Object)40);
        module.add(new Animation[]{animText});
    }

    public static void drawWire(Vec2d start, Vec2d end, Color primary, Color secondary) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179129_p();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-10.0f);
        WorktableGui.STREAK.bind();
        InterpBezier2D bezier = new InterpBezier2D(start, end);
        List list = bezier.list(50);
        float p = 0.0f;
        for (int i = 0; i < list.size() - 1; ++i) {
            float x = (float)(start.length() + (double)ClientTickHandler.getTicks() + (double)ClientTickHandler.getPartialTicks()) / 30.0f;
            if (i != (int)(((double)x - Math.floor(x)) * 50.0)) continue;
            p = (float)i / ((float)list.size() - 1.0f);
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vb = tessellator.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        Vec2d lastPoint = null;
        for (int i = 0; i < list.size() - 1; ++i) {
            float wire;
            float z;
            Vec2d point = (Vec2d)list.get(i);
            if (lastPoint == null) {
                lastPoint = point;
                continue;
            }
            float dist = (float)i / ((float)list.size() - 1.0f);
            if (dist < p) {
                z = Math.abs(dist - p);
                wire = 9.481482f * (z * z * z - z * z * z * z);
            } else {
                z = Math.abs(dist - (p + 1.0f));
                wire = 9.481482f * (z * z * z - z * z * z * z);
            }
            float r = TableModule.lerp(primary.getRed(), secondary.getRed(), wire) / 255.0f;
            float g = TableModule.lerp(primary.getGreen(), secondary.getGreen(), wire) / 255.0f;
            float b = TableModule.lerp(primary.getBlue(), secondary.getBlue(), wire) / 255.0f;
            Vec2d normal = point.sub(lastPoint).normalize();
            Vec2d perp = new Vec2d((double)(-normal.getYf()), (double)normal.getXf()).mul((double)(1.0f - 2.0f * Math.abs(dist - 0.5f) + 0.3f));
            Vec2d point1 = lastPoint.sub(normal.mul(0.5)).add(perp);
            Vec2d point2 = point.add(normal.mul(0.5)).add(perp);
            Vec2d point3 = point.add(normal.mul(0.5)).sub(perp);
            Vec2d point4 = lastPoint.sub(normal.mul(0.5)).sub(perp);
            vb.func_181662_b((double)point1.getXf(), (double)point1.getYf(), 0.0).func_187315_a(0.0, 0.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
            vb.func_181662_b((double)point2.getXf(), (double)point2.getYf(), 0.0).func_187315_a(0.0, 1.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
            vb.func_181662_b((double)point3.getXf(), (double)point3.getYf(), 0.0).func_187315_a(1.0, 0.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
            vb.func_181662_b((double)point4.getXf(), (double)point4.getYf(), 0.0).func_187315_a(1.0, 1.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
            lastPoint = point;
        }
        tessellator.func_78381_a();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)10.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
    }

    private static float lerp(float a, float b, float f) {
        return a + f * (b - a);
    }

    public static Color getColorForModule(ModuleType type) {
        switch (type) {
            case EVENT: {
                return Color.PINK;
            }
            case SHAPE: {
                return Color.CYAN;
            }
            case EFFECT: {
                return Color.ORANGE;
            }
            case MODIFIER: {
                return Color.GREEN;
            }
        }
        return Color.BLACK;
    }

    public static void deselect(TableModule module) {
        Vec2d toSize = new Vec2d(20.0, 20.0);
        BasicAnimation animSize = new BasicAnimation((Object)module, "size");
        animSize.setDuration(5.0f);
        animSize.setEasing((Easing)Easing.easeOutCubic);
        animSize.setTo((Object)toSize);
        module.add(new Animation[]{animSize});
        BasicAnimation animPos = new BasicAnimation((Object)module, "pos");
        animPos.setDuration(5.0f);
        animPos.setEasing((Easing)Easing.easeOutCubic);
        animPos.setTo((Object)module.getPos().add(module.getSize().sub(toSize).mul(0.5)));
        module.add(new Animation[]{animPos});
        BasicAnimation animRadius = new BasicAnimation((Object)module, "radius");
        animRadius.setDuration(20.0f);
        animRadius.setEasing((Easing)Easing.easeOutCubic);
        animRadius.setTo((Object)16);
        module.add(new Animation[]{animRadius});
        BasicAnimation animText = new BasicAnimation((Object)module, "textRadius");
        animText.setDuration(40.0f);
        animText.setEasing((Easing)Easing.easeOutCubic);
        animText.setTo((Object)30);
        module.add(new Animation[]{animText});
    }

    public void drawComponent(@NotNull Vec2d mousePos, float partialTicks) {
        super.drawComponent(mousePos, partialTicks);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
        Sprite plate = this.isErrored() ? WorktableGui.PLATE_HIGHLIGHTED_ERROR : (this.worktable.selectedModule == this ? WorktableGui.PLATE_HIGHLIGHTED : WorktableGui.PLATE);
        Vec2d pos = Vec2d.ZERO;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-20.0f);
        if (this.hasTag("connecting")) {
            TableModule.drawWire(pos.add(this.getSize().getX() / 2.0, this.getSize().getY() / 2.0), mousePos, TableModule.getColorForModule(this.module.getModuleType()), Color.WHITE);
        }
        if (this.linksTo != null) {
            Vec2d posTo = this.linksTo.thisPosToOtherContext(this);
            TableModule.drawWire(pos.add(this.getSize().getX() / 2.0, this.getSize().getY() / 2.0), posTo.add(this.getSize().getX() / 2.0, this.getSize().getY() / 2.0), TableModule.getColorForModule(this.module.getModuleType()), TableModule.getColorForModule(this.linksTo.getModule().getModuleType()));
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)20.0f);
        if (this.isErrored() || this.worktable.selectedModule == this || !this.benign && !this.worktable.animationPlaying && this.getMouseOver() && !this.hasTag("connecting")) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)80.0f);
        }
        plate.bind();
        plate.draw(0, 0.0f, 0.0f, this.getSize().getXf(), this.getSize().getYf());
        float shrink = 4.0f;
        this.icon.bind();
        this.icon.draw(0, shrink / 2.0f, shrink / 2.0f, this.getSize().getXf() - shrink, this.getSize().getYf() - shrink);
        HashMap<ModuleInstanceModifier, Object> modifiers = new HashMap<ModuleInstanceModifier, Object>();
        ArrayList<ModuleInstanceModifier> modifierList = new ArrayList<ModuleInstanceModifier>();
        for (ModuleInstance module : ModuleRegistry.INSTANCE.getModules(ModuleType.MODIFIER)) {
            if (!(module instanceof ModuleInstanceModifier) || !this.hasData(Integer.class, module.getSubModuleID())) continue;
            modifiers.put((ModuleInstanceModifier)module, this.getData(Integer.class, module.getSubModuleID()));
            modifierList.add((ModuleInstanceModifier)module);
        }
        int count = modifierList.size();
        for (int i = 0; i < count; ++i) {
            ModuleInstanceModifier modifier = (ModuleInstanceModifier)modifierList.get(i);
            Vec2d modSize = this.getSize().mul(0.75);
            float angle = (float)((double)i * Math.PI * 2.0 / (double)count);
            float x = this.getSize().getXf() / 2.0f - modSize.getXf() / 2.0f + MathHelper.func_76134_b((float)angle) * this.radius;
            float y = this.getSize().getYf() / 2.0f - modSize.getYf() / 2.0f + MathHelper.func_76126_a((float)angle) * this.radius;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)x, (float)y, (float)-10.0f);
            plate.bind();
            plate.draw(0, 0.0f, 0.0f, modSize.getXf(), modSize.getYf());
            float modShrink = 4.0f;
            Sprite modICon = new Sprite(new ResourceLocation("wizardry", "textures/gui/worktable/icons/" + modifier.getSubModuleID() + ".png"));
            modICon.bind();
            modICon.draw(0, modShrink / 2.0f, modShrink / 2.0f, modSize.getXf() - modShrink, modSize.getYf() - modShrink);
            GlStateManager.func_179109_b((float)(-x), (float)(-y), (float)10.0f);
            GlStateManager.func_179121_F();
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            String txt = "x" + modifiers.get(modifier);
            float txtWidth = font.func_78256_a(txt);
            float txtHeight = font.field_78288_b;
            float x2 = this.getSize().getXf() / 2.0f - txtWidth / 2.0f + MathHelper.func_76134_b((float)angle) * this.textRadius;
            float y2 = this.getSize().getYf() / 2.0f - txtHeight / 2.0f + MathHelper.func_76126_a((float)angle) * this.textRadius;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)x2, (float)y2, (float)-15.0f);
            font.func_78276_b(txt, 0, 0, 0);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)(-x2), (float)(-y2), (float)15.0f);
            GlStateManager.func_179121_F();
        }
        if (this.isErrored() || this.worktable.selectedModule == this || !this.benign && !this.worktable.animationPlaying && this.getMouseOver() && !this.hasTag("connecting")) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-80.0f);
        }
    }

    public boolean isErrored() {
        return this.errored;
    }

    @Nullable
    public TableModule getLinksTo() {
        return this.linksTo;
    }

    public void setLinksTo(@Nullable TableModule linksTo) {
        this.linksTo = linksTo;
    }

    @Nonnull
    public WorktableGui getWorktable() {
        return this.worktable;
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    @Nonnull
    public ModuleInstance getModule() {
        return this.module;
    }

    public Sprite getIcon() {
        return this.icon;
    }

    public boolean isEnableTooltip() {
        return this.enableTooltip;
    }

    public void setEnableTooltip(boolean enableTooltip) {
        this.enableTooltip = enableTooltip;
    }

    public static void unhoverOver(TableModule module) {
        Vec2d toSize = new Vec2d(16.0, 16.0);
        BasicAnimation animSize = new BasicAnimation((Object)module, "size");
        animSize.setDuration(5.0f);
        animSize.setEasing((Easing)Easing.easeOutCubic);
        animSize.setTo((Object)toSize);
        module.add(new Animation[]{animSize});
        BasicAnimation animPos = new BasicAnimation((Object)module, "pos");
        animPos.setDuration(5.0f);
        animPos.setEasing((Easing)Easing.easeOutCubic);
        animPos.setTo((Object)module.getPos().add(module.getSize().sub(toSize).mul(0.5)));
        module.add(new Animation[]{animPos});
        BasicAnimation animRadius = new BasicAnimation((Object)module, "radius");
        animRadius.setDuration(20.0f);
        animRadius.setEasing((Easing)Easing.easeOutCubic);
        animRadius.setTo((Object)10);
        module.add(new Animation[]{animRadius});
        BasicAnimation animText = new BasicAnimation((Object)module, "textRadius");
        animText.setDuration(40.0f);
        animText.setEasing((Easing)Easing.easeOutCubic);
        animText.setTo((Object)0);
        module.add(new Animation[]{animText});
    }

    public static void hoverOver(TableModule module) {
        Vec2d toSize = new Vec2d(20.0, 20.0);
        BasicAnimation animSize = new BasicAnimation((Object)module, "size");
        animSize.setDuration(5.0f);
        animSize.setEasing((Easing)Easing.easeOutCubic);
        animSize.setTo((Object)toSize);
        module.add(new Animation[]{animSize});
        BasicAnimation animPos = new BasicAnimation((Object)module, "pos");
        animPos.setDuration(5.0f);
        animPos.setEasing((Easing)Easing.easeOutCubic);
        animPos.setTo((Object)module.getPos().add(module.getSize().sub(toSize).mul(0.5)));
        module.add(new Animation[]{animPos});
        BasicAnimation animRadius = new BasicAnimation((Object)module, "radius");
        animRadius.setDuration(20.0f);
        animRadius.setEasing((Easing)Easing.easeOutCubic);
        animRadius.setTo((Object)16);
        module.add(new Animation[]{animRadius});
        BasicAnimation animText = new BasicAnimation((Object)module, "textRadius");
        animText.setDuration(40.0f);
        animText.setEasing((Easing)Easing.easeOutCubic);
        animText.setTo((Object)30);
        module.add(new Animation[]{animText});
    }

    public void setErrored(boolean errored) {
        this.errored = errored;
    }

    public static class ModuleUpdateEvent
    extends Event {
    }
}

