/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.util;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public final class PosUtils {
    public static final ArrayList<EnumFacing> symmetricFacingValues = new ArrayList();

    public static EnumFacing[] getPerpendicularFacings(EnumFacing facing) {
        switch (facing) {
            case DOWN: 
            case UP: {
                return EnumFacing.field_176754_o;
            }
            case NORTH: 
            case SOUTH: {
                return new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN, EnumFacing.WEST, EnumFacing.EAST};
            }
            case WEST: 
            case EAST: {
                return new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.SOUTH};
            }
        }
        return new EnumFacing[0];
    }

    @Nullable
    public static BlockPos checkNeighborBlocksThoroughly(World world, BlockPos origin, Block desiredBlockToFind) {
        if (world.func_180495_p(origin).func_177230_c() == desiredBlockToFind) {
            return origin;
        }
        for (EnumFacing facing : EnumFacing.values()) {
            BlockPos pos = origin.func_177972_a(facing);
            if (world.func_180495_p(pos).func_177230_c() == desiredBlockToFind) {
                return pos;
            }
            BlockPos pos2 = pos.func_177972_a(EnumFacing.DOWN);
            if (world.func_180495_p(pos2).func_177230_c() != desiredBlockToFind) continue;
            return pos2;
        }
        return null;
    }

    public static Vec3d vecFromRotations(float rotationPitch, float rotationYaw) {
        return Vec3d.func_189986_a((float)rotationPitch, (float)rotationYaw);
    }

    public static float[] vecToRotations(Vec3d vec) {
        float yaw = (float)MathHelper.func_181159_b((double)vec.field_72449_c, (double)vec.field_72450_a);
        float pitch = (float)Math.asin(vec.field_72448_b / vec.func_72433_c());
        return new float[]{(float)Math.toDegrees(pitch), (float)Math.toDegrees(yaw) + 90.0f};
    }

    public static void boom(World world, Vec3d pos, @Nullable Entity excluded, double scale, boolean reverseDirection) {
        List entityList = world.func_72839_b(excluded, new AxisAlignedBB(new BlockPos(pos)).func_72314_b(32.0, 32.0, 32.0));
        for (Entity entity1 : entityList) {
            double x = entity1.func_70011_f(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c) / 32.0;
            double magY = reverseDirection ? x : -x + 1.0;
            Vec3d dir = entity1.func_174791_d().func_178788_d(pos).func_72432_b().func_186678_a(reverseDirection ? -1.0 : 1.0).func_186678_a(magY).func_186678_a(scale);
            entity1.field_70159_w += dir.field_72450_a;
            entity1.field_70181_x += dir.field_72448_b;
            entity1.field_70179_y += dir.field_72449_c;
            entity1.field_70143_R = 0.0f;
            entity1.field_70133_I = true;
            if (!(entity1 instanceof EntityPlayerMP)) continue;
            ((EntityPlayerMP)entity1).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(entity1));
        }
    }

    static {
        symmetricFacingValues.add(EnumFacing.UP);
        symmetricFacingValues.add(EnumFacing.DOWN);
        symmetricFacingValues.add(EnumFacing.EAST);
        symmetricFacingValues.add(EnumFacing.WEST);
        symmetricFacingValues.add(EnumFacing.SOUTH);
        symmetricFacingValues.add(EnumFacing.NORTH);
    }
}

