/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.util;

import com.mojang.authlib.GameProfile;
import com.teamwizardry.wizardry.init.ModBlocks;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;

public final class BlockUtils {
    private static final UUID uuid = UUID.randomUUID();
    private static final GameProfile breaker = new GameProfile(uuid, "Wizardry Block Breaker");
    private static final GameProfile placer = new GameProfile(uuid, "Wizardry Block Placer");

    private BlockUtils() {
    }

    public static boolean isAnyAir(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150350_a || state.func_177230_c() == ModBlocks.FAKE_AIR;
    }

    public static boolean isAnyAir(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c() == Blocks.field_150350_a || state.func_177230_c() == ModBlocks.FAKE_AIR;
    }

    public static boolean isAnyAir(Block block) {
        return block == Blocks.field_150350_a || block == ModBlocks.FAKE_AIR;
    }

    public static boolean placeBlock(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nullable EntityPlayerMP player) {
        EntityPlayerMP playerMP;
        if (!world.func_175667_e(pos)) {
            return false;
        }
        if (player == null) {
            playerMP = new FakePlayer((WorldServer)world, placer);
            playerMP.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            playerMP.func_70095_a(true);
        } else {
            playerMP = player;
        }
        if (!BlockUtils.hasEditPermission(pos, playerMP)) {
            return false;
        }
        BlockEvent.PlaceEvent event = new BlockEvent.PlaceEvent(BlockSnapshot.getBlockSnapshot((World)world, (BlockPos)pos), Blocks.field_150350_a.func_176223_P(), (EntityPlayer)playerMP, playerMP.func_184600_cs());
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            world.func_175656_a(pos, state);
            world.func_184138_a(pos, state, state, 3);
            return true;
        }
        return false;
    }

    public static boolean placeBlock(@Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, @Nonnull ItemStack stack) {
        if (!world.func_175667_e(pos)) {
            return false;
        }
        FakePlayer player = new FakePlayer((WorldServer)world, placer);
        player.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        player.func_184611_a(EnumHand.MAIN_HAND, stack);
        player.func_70095_a(true);
        if (!BlockUtils.hasEditPermission(pos, (EntityPlayerMP)player)) {
            return false;
        }
        if (!world.func_175667_e(pos)) {
            return false;
        }
        if (world.func_175625_s(pos) == null) {
            if (facing == null) {
                for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
                    EnumActionResult result = player.field_71134_c.func_187251_a((EntityPlayer)player, world, stack, EnumHand.MAIN_HAND, pos, enumFacing, 0.0f, 0.0f, 0.0f);
                    if (result == EnumActionResult.FAIL) continue;
                    return true;
                }
            } else {
                EnumActionResult result = player.field_71134_c.func_187251_a((EntityPlayer)player, world, stack, EnumHand.MAIN_HAND, pos, facing, 0.0f, 0.0f, 0.0f);
                return result != EnumActionResult.FAIL;
            }
        }
        return false;
    }

    public static boolean breakBlock(@Nonnull World world, @Nonnull BlockPos pos, @Nullable IBlockState oldState, @Nullable EntityPlayerMP player, boolean drop) {
        EntityPlayerMP playerMP;
        if (!world.func_175667_e(pos)) {
            return false;
        }
        if (player == null) {
            playerMP = new FakePlayer((WorldServer)world, breaker);
            playerMP.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        } else {
            playerMP = player;
        }
        if (player != null && !(player instanceof FakePlayer) && !BlockUtils.hasBreakPermission(world, pos, playerMP)) {
            return false;
        }
        if (oldState == null) {
            oldState = world.func_180495_p(pos);
        }
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, oldState, (EntityPlayer)playerMP);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            TileEntity tile = world.func_175625_s(pos);
            Block block = oldState.func_177230_c();
            if (block.removedByPlayer(oldState, world, pos, (EntityPlayer)playerMP, true)) {
                block.func_176206_d(world, pos, oldState);
                block.func_180657_a(world, (EntityPlayer)playerMP, pos, oldState, tile, null);
            } else {
                world.func_175698_g(pos);
            }
            return true;
        }
        return false;
    }

    public static boolean hasBreakPermission(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayerMP player) {
        return BlockUtils.hasEditPermission(pos, player) && ForgeHooks.onBlockBreakEvent((World)world, (GameType)player.field_71134_c.func_73081_b(), (EntityPlayerMP)player, (BlockPos)pos) != -1;
    }

    public static boolean hasEditPermission(@Nonnull BlockPos pos, @Nonnull EntityPlayerMP player) {
        if (FMLCommonHandler.instance().getMinecraftServerInstance().func_175579_a(player.func_130014_f_(), pos, (EntityPlayer)player)) {
            return false;
        }
        IBlockState block = player.func_130014_f_().func_180495_p(pos);
        if (block.func_185887_b(player.func_130014_f_(), pos) == -1.0f && !player.field_71075_bZ.field_75098_d) {
            return false;
        }
        for (EnumFacing e : EnumFacing.field_82609_l) {
            if (player.func_175151_a(pos, e, player.func_184614_ca())) continue;
            return false;
        }
        return true;
    }

    public static Set<BlockPos> blocksInSquare(BlockPos center, EnumFacing.Axis axis, int maxBlocks, int maxRange, Predicate<BlockPos> ignore) {
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        if (ignore.test(center)) {
            return blocks;
        }
        blocks.add(center);
        if (blocks.size() >= maxBlocks) {
            return blocks;
        }
        LinkedList<BlockPos> blockQueue = new LinkedList<BlockPos>();
        blockQueue.add(center);
        while (!blockQueue.isEmpty()) {
            BlockPos pos = (BlockPos)blockQueue.remove();
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                BlockPos shift;
                if (facing.func_176740_k() == axis || (shift = pos.func_177972_a(facing)).func_177958_n() - center.func_177958_n() > maxRange || center.func_177958_n() - shift.func_177958_n() > maxRange || shift.func_177956_o() - center.func_177956_o() > maxRange || center.func_177956_o() - shift.func_177956_o() > maxRange || shift.func_177952_p() - center.func_177952_p() > maxRange || center.func_177952_p() - shift.func_177952_p() > maxRange || blocks.contains(shift) || ignore.test(shift)) continue;
                blocks.add(shift);
                blockQueue.add(shift);
                if (blocks.size() >= maxBlocks) break;
            }
            if (blocks.size() < maxBlocks) continue;
            break;
        }
        return blocks;
    }

    public static Set<BlockPos> blocksInSquare(BlockPos center, EnumFacing facing, int maxBlocks, int maxRange, Predicate<BlockPos> ignore) {
        return BlockUtils.blocksInSquare(center, facing.func_176740_k(), maxBlocks, maxRange, ignore);
    }

    public static <T extends TileEntity> T getTileEntity(IBlockAccess world, BlockPos pos, Class<T> clazz) {
        TileEntity te = world.func_175625_s(pos);
        if (!clazz.isInstance(te)) {
            return null;
        }
        return (T)te;
    }
}

