/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.spell;

import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeModifier;
import com.teamwizardry.wizardry.api.spell.attribute.ModifierPredicate;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;

public class SpellModifierRegistry {
    private static WeakHashMap<UUID, HashMap<ResourceLocation, ModifierPredicate<SpellRing, SpellData>>> entityModifiers = new WeakHashMap();

    public static boolean addModifier(Entity entity, ResourceLocation loc, ModifierPredicate<SpellRing, SpellData> predicate) {
        HashMap<Object, ModifierPredicate<SpellRing, SpellData>> predicates = entityModifiers.get(entity.func_110124_au());
        if (predicates == null) {
            predicates = new HashMap();
        }
        predicates.put(loc, predicate);
        entityModifiers.put(entity.func_110124_au(), predicates);
        return false;
    }

    public static boolean removeModifier(Entity entity, ResourceLocation loc) {
        HashMap<ResourceLocation, ModifierPredicate<SpellRing, SpellData>> predicates = entityModifiers.get(entity.func_110124_au());
        if (predicates == null) {
            return false;
        }
        return predicates.remove(loc) != null;
    }

    public static List<AttributeModifier> compileModifiers(Entity entity, SpellRing spell, SpellData data) {
        LinkedList<AttributeModifier> modifiers = new LinkedList<AttributeModifier>();
        HashMap<ResourceLocation, ModifierPredicate<SpellRing, SpellData>> predicates = entityModifiers.get(entity.func_110124_au());
        if (predicates == null) {
            return modifiers;
        }
        for (ModifierPredicate<SpellRing, SpellData> predicate : predicates.values()) {
            modifiers.addAll(predicate.apply(spell, data));
        }
        return modifiers;
    }
}

