/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.item.wheels;

import com.google.common.collect.Lists;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.IItemHandler;

@Cancelable
public class FindPearlWheelEvent
extends Event {
    private final TObjectIntHashMap<Iterable<ItemStack>> inventories = new TObjectIntHashMap();
    public final EntityPlayer player;

    public FindPearlWheelEvent(EntityPlayer player) {
        this.player = player;
    }

    public void addItems(IItemHandler handler, int priority) {
        this.addItems(() -> new CapabilityIterator(handler), priority);
    }

    public void addItems(IInventory handler, int priority) {
        this.addItems(() -> new InventoryIterator(handler), priority);
    }

    public void addItems(ItemStack handler, int priority) {
        this.addItems(Lists.newArrayList((Object[])new ItemStack[]{handler}), priority);
    }

    public void addItems(Iterable<ItemStack> handler, int priority) {
        this.inventories.put(handler, priority);
    }

    public Iterator<ItemStack> getCombinedIterator() {
        if (this.isCanceled()) {
            return Collections.emptyIterator();
        }
        ArrayList inventoriesSorted = Lists.newArrayList((Iterable)this.inventories.keySet());
        inventoriesSorted.sort(Comparator.comparingInt(arg_0 -> this.inventories.get(arg_0)).reversed());
        return new CombinedIterator<ItemStack>(inventoriesSorted);
    }

    private static final class CombinedIterator<T>
    implements Iterator<T> {
        private final Iterator<Iterable<T>> iterators;
        private Iterator<T> current;
        private final Iterator<Iterable<T>> stepAhead;
        private boolean atParity = true;
        private Iterator<T> checkAgainst;

        public CombinedIterator(Iterable<Iterable<T>> iterators) {
            this.iterators = iterators.iterator();
            this.stepAhead = iterators.iterator();
            if (this.iterators.hasNext()) {
                this.current = this.iterators.next().iterator();
                this.checkAgainst = this.stepAhead.next().iterator();
            }
        }

        @Override
        public boolean hasNext() {
            if (this.current.hasNext()) {
                return true;
            }
            if (this.iterators.hasNext()) {
                if (this.atParity) {
                    this.checkAgainst = this.stepAhead.next().iterator();
                    this.atParity = false;
                }
                return this.checkAgainst.hasNext();
            }
            return false;
        }

        @Override
        public T next() {
            if (this.current.hasNext()) {
                return this.current.next();
            }
            this.current = this.iterators.next().iterator();
            this.atParity = true;
            return this.current.next();
        }
    }

    private static final class CapabilityIterator
    implements Iterator<ItemStack> {
        private final IItemHandler inventory;
        private int slot = 0;

        public CapabilityIterator(IItemHandler inventory) {
            this.inventory = inventory;
        }

        @Override
        public boolean hasNext() {
            return this.inventory.getSlots() >= this.slot;
        }

        @Override
        public ItemStack next() {
            return this.inventory.getStackInSlot(this.slot++);
        }
    }

    private static final class InventoryIterator
    implements Iterator<ItemStack> {
        private final IInventory inventory;
        private int slot = 0;

        public InventoryIterator(IInventory inventory) {
            this.inventory = inventory;
        }

        @Override
        public boolean hasNext() {
            return this.inventory.func_70302_i_() >= this.slot;
        }

        @Override
        public ItemStack next() {
            return this.inventory.func_70301_a(this.slot++);
        }
    }
}

