/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.teleport.anchor;

import com.enderio.core.client.render.ManagedTESR;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.util.Util;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector3f;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.base.teleport.TravelController;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.machine.teleport.anchor.TileTravelAnchor;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

@SideOnly(value=Side.CLIENT)
public class TravelEntitySpecialRenderer<T extends TileTravelAnchor>
extends ManagedTESR<T> {
    private final Vector4f selectedColor = new Vector4f(1.0f, 0.25f, 0.0f, 0.5f);
    private final Vector4f itemBlend = new Vector4f(0.3f, 0.3f, 0.3f, 0.3f);
    private final Vector4f blockBlend = new Vector4f(0.6f, 0.6f, 0.6f, 0.4f);
    private final Vector4f selectedBlockBlend = new Vector4f(0.9f, 0.33f, 0.1f, 0.35f);

    public TravelEntitySpecialRenderer(Block block) {
        super(block);
    }

    public TravelEntitySpecialRenderer() {
        super(MachineObject.block_travel_anchor.getBlock());
    }

    public boolean shouldRender(@Nonnull T te, @Nonnull IBlockState blockState, int renderPass) {
        return TravelController.instance.showTargets() && ((TileTravelAnchor)((Object)te)).isVisible() && (TravelController.instance.getPosPlayerOn() == null || BlockCoord.getDist((BlockPos)TravelController.instance.getPosPlayerOn(), (BlockPos)((TileTravelAnchor)((Object)te)).getLocation()) > 2) && ((TileTravelAnchor)((Object)te)).canSeeBlock((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
    }

    public void renderTileEntity(@Nonnull T te, @Nonnull IBlockState blockState, float partialTicks, int destroyStage) {
        int maxDistance;
        Vector3d eye = Util.getEyePositionEio((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        Vector3d loc = new Vector3d((double)te.func_174877_v().func_177958_n() + 0.5, (double)te.func_174877_v().func_177956_o() + 0.5, (double)te.func_174877_v().func_177952_p() + 0.5);
        int n = maxDistance = TravelController.instance.isTravelItemActiveForRendering((EntityPlayer)Minecraft.func_71410_x().field_71439_g) ? TravelSource.STAFF.getMaxDistanceTravelledSq() : TravelSource.BLOCK.getMaxDistanceTravelledSq();
        if (eye.distanceSquared(loc) > (double)maxDistance) {
            return;
        }
        double sf = TravelController.instance.getScaleForCandidate(loc, maxDistance);
        boolean highlight = TravelController.instance.isBlockSelected(((TileTravelAnchor)((Object)te)).getLocation());
        TravelController.instance.addCandidate(((TileTravelAnchor)((Object)te)).getLocation());
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
        GlStateManager.func_179091_B();
        GlStateManager.func_179097_i();
        GlStateManager.func_179140_f();
        this.renderBlock(te.func_174877_v(), (IBlockAccess)te.func_145831_w(), sf, highlight);
        this.renderItemLabel(((TileTravelAnchor)((Object)te)).getItemLabel(), sf);
        this.renderLabel(((TileTravelAnchor)((Object)te)).getLabel(), sf, highlight);
        GlStateManager.func_179101_C();
        GlStateManager.func_179126_j();
        Minecraft.func_71410_x().field_71460_t.func_180436_i();
    }

    private void renderItemLabel(@Nonnull ItemStack itemLabel, double globalScale) {
        if (!itemLabel.func_190926_b()) {
            RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
            RenderItem itemRenderer = Minecraft.func_71410_x().func_175599_af();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.5f, (float)0.75f, (float)0.5f);
            GlStateManager.func_179114_b((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)(renderManager.field_78733_k.field_74320_O == 2 ? -1 : 1) * renderManager.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179139_a((double)globalScale, (double)globalScale, (double)globalScale);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            RenderHelper.func_74519_b();
            IBakedModel bakedmodel = itemRenderer.func_184393_a(itemLabel, (World)null, (EntityLivingBase)null);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179120_a((int)770, (int)32769, (int)GlStateManager.SourceFactor.ONE.field_187395_p, (int)GlStateManager.DestFactor.ZERO.field_187345_o);
            GL14.glBlendColor((float)this.itemBlend.x, (float)this.itemBlend.y, (float)this.itemBlend.z, (float)this.itemBlend.w);
            bakedmodel = ForgeHooksClient.handleCameraTransforms((IBakedModel)bakedmodel, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GUI, (boolean)false);
            itemRenderer.func_180454_a(itemLabel, (IBakedModel)NullHelper.notnullF((Object)bakedmodel, (String)"handleCameraTransforms returned null!"));
            RenderHelper.func_74518_a();
            GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179121_F();
        }
    }

    private void renderLabel(String toRender, double globalScale, boolean highlight) {
        if (toRender != null && toRender.trim().length() > 0) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Vector4f bgCol = RenderUtil.DEFAULT_TEXT_BG_COL;
            if (highlight) {
                bgCol = new Vector4f(this.selectedColor.x, this.selectedColor.y, this.selectedColor.z, this.selectedColor.w);
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.func_179139_a((double)globalScale, (double)globalScale, (double)globalScale);
            Vector3f pos = new Vector3f(0.0f, 1.2f, 0.0f);
            float size = 0.5f;
            RenderUtil.drawBillboardedText((Vector3f)pos, (String)toRender, (float)size, (Vector4f)bgCol);
            GL11.glPopMatrix();
        }
    }

    public void renderBlock(@Nonnull BlockPos pos, IBlockAccess blockAccess, double globalScale, boolean highlight) {
        BufferBuilder tes = Tessellator.func_178181_a().func_178180_c();
        BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.func_179139_a((double)globalScale, (double)globalScale, (double)globalScale);
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
        IBlockState state = blockAccess.func_180495_p(pos).func_185899_b(blockAccess, pos);
        IBakedModel ibakedmodel = blockrendererdispatcher.func_184389_a(state);
        state = state.func_177230_c().getExtendedState(state, blockAccess, pos);
        tes.func_178969_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
        Vector4f color = highlight ? this.selectedBlockBlend : this.blockBlend;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179120_a((int)770, (int)32769, (int)GlStateManager.SourceFactor.ONE.field_187395_p, (int)GlStateManager.DestFactor.ZERO.field_187345_o);
        GL14.glBlendColor((float)color.x, (float)color.y, (float)color.z, (float)color.w);
        tes.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        for (BlockRenderLayer layer : BlockRenderLayer.values()) {
            if (!state.func_177230_c().canRenderInLayer(state, (BlockRenderLayer)NullHelper.notnullJ((Object)layer, (String)"BlockRenderLayer value was null!"))) continue;
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
            blockrendererdispatcher.func_175019_b().func_178267_a(blockAccess, ibakedmodel, state, pos, tes, false);
        }
        ForgeHooksClient.setRenderLayer(null);
        Tessellator.func_178181_a().func_78381_a();
        GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179112_b((int)770, (int)771);
        tes.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179121_F();
    }

    public boolean isGlobalRenderer(@Nonnull T te) {
        return true;
    }
}

