/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.darksteel.upgrade.solar;

import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.api.upgrades.IHasPlayerRenderer;
import crazypants.enderio.api.upgrades.IRenderUpgrade;
import crazypants.enderio.base.handler.darksteel.AbstractUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgradeManager;
import crazypants.enderio.base.power.PowerHandlerUtil;
import crazypants.enderio.machines.config.config.SolarConfig;
import crazypants.enderio.machines.darksteel.upgrade.solar.SolarUpgradeLayer;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.machine.solar.TileSolarPanel;
import info.loenwind.autoconfig.factory.IValue;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="enderiomachines")
public class SolarUpgrade
extends AbstractUpgrade
implements IHasPlayerRenderer {
    @Nonnull
    private static final String UPGRADE_NAME = "solar";
    @Nonnull
    static final String NAME = "enderio.darksteel.upgrade.solar_";
    public static final SolarUpgrade SOLAR1 = new SolarUpgrade(new ItemStack(MachineObject.block_solar_panel.getItemNN(), 1, 0), 1, SolarConfig.darkSteelSolarOneCost, SolarConfig.darkSteelSolarOneGen);
    public static final SolarUpgrade SOLAR2 = new SolarUpgrade(new ItemStack(MachineObject.block_solar_panel.getItemNN(), 1, 1), 2, SolarConfig.darkSteelSolarTwoCost, SolarConfig.darkSteelSolarTwoGen);
    public static final SolarUpgrade SOLAR3 = new SolarUpgrade(new ItemStack(MachineObject.block_solar_panel.getItemNN(), 1, 2), 3, SolarConfig.darkSteelSolarThreeCost, SolarConfig.darkSteelSolarThreeGen);
    private final int level;
    @Nonnull
    private final IValue<Integer> rf;

    @SubscribeEvent
    public static void registerDarkSteelUpgrades(@Nonnull RegistryEvent.Register<IDarkSteelUpgrade> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)SOLAR1);
        registry.register((IForgeRegistryEntry)SOLAR2);
        registry.register((IForgeRegistryEntry)SOLAR3);
    }

    public static SolarUpgrade loadAnyFromItem(@Nonnull ItemStack stack) {
        if (SOLAR3.hasUpgrade(stack)) {
            return SOLAR3;
        }
        if (SOLAR2.hasUpgrade(stack)) {
            return SOLAR2;
        }
        if (SOLAR1.hasUpgrade(stack)) {
            return SOLAR1;
        }
        return null;
    }

    public SolarUpgrade(@Nonnull ItemStack item, int level, @Nonnull IValue<Integer> levelCost, @Nonnull IValue<Integer> rf) {
        super("enderiomachines", UPGRADE_NAME, level, NAME + level, item, levelCost);
        this.level = level;
        this.rf = rf;
    }

    protected int getMinVariant() {
        return 1;
    }

    public boolean canAddToItem(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
        if (!item.isForSlot(EntityEquipmentSlot.HEAD) || !EnergyUpgradeManager.itemHasAnyPowerUpgrade((ItemStack)stack)) {
            return false;
        }
        SolarUpgrade up = SolarUpgrade.loadAnyFromItem(stack);
        if (up == null) {
            return this.getLevel() == 1;
        }
        return up.getLevel() == this.getLevel() - 1;
    }

    public boolean canOtherBeRemoved(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item, @Nonnull IDarkSteelUpgrade other) {
        return !EnergyUpgradeManager.isLowestPowerUpgrade((IDarkSteelUpgrade)other);
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IRenderUpgrade getRender() {
        return SolarUpgradeLayer.instance;
    }

    public int getLevel() {
        return this.level;
    }

    public void onPlayerTick(@Nonnull ItemStack helm, @Nonnull IDarkSteelItem item, @Nonnull EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (!player.field_70170_p.func_175710_j(new BlockPos(MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)(player.field_70163_u + (double)player.eyeHeight + 0.25)), MathHelper.func_76128_c((double)player.field_70161_v)))) {
            return;
        }
        int RFperSecond = Math.round((float)((Integer)this.rf.get()).intValue() * TileSolarPanel.calculateLightRatio(player.field_70170_p));
        int leftover = RFperSecond % 20;
        boolean addExtraRF = player.field_70170_p.func_82737_E() % 20L < (long)leftover;
        int toAdd = RFperSecond / 20 + (addExtraRF ? 1 : 0);
        if (toAdd != 0) {
            int nextIndex = player.getEntityData().func_74762_e("dsarmor:solar") % 4;
            for (int i = 0; i < 4 && toAdd > 0; ++i) {
                ItemStack stack = (ItemStack)player.field_71071_by.field_70460_b.get(nextIndex);
                IEnergyStorage cap = PowerHandlerUtil.getCapability((ICapabilityProvider)stack, null);
                if (cap != null && (EnergyUpgradeManager.loadFromItem((ItemStack)stack) != null || ((Boolean)SolarConfig.helmetChargeOthers.get()).booleanValue())) {
                    toAdd -= cap.receiveEnergy(toAdd, false);
                }
                nextIndex = (nextIndex + 1) % 4;
            }
            player.getEntityData().func_74768_a("dsarmor:solar", nextIndex);
        }
    }
}

