/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.recipesystem.loader;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.teamacronymcoders.base.Base;
import com.teamacronymcoders.base.json.factory.IObjectFactory;
import com.teamacronymcoders.base.recipesystem.Recipe;
import com.teamacronymcoders.base.recipesystem.RecipeSystem;
import com.teamacronymcoders.base.recipesystem.condition.ICondition;
import com.teamacronymcoders.base.recipesystem.event.RegisterRecipeFactoriesEvent;
import com.teamacronymcoders.base.recipesystem.input.IInput;
import com.teamacronymcoders.base.recipesystem.loader.ILoader;
import com.teamacronymcoders.base.recipesystem.output.IOutput;
import com.teamacronymcoders.base.recipesystem.source.IRecipeSource;
import com.teamacronymcoders.base.recipesystem.source.RecipeSource;
import com.teamacronymcoders.base.recipesystem.type.RecipeType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.io.FilenameUtils;

public class JsonRecipeLoader
implements ILoader {
    private static JsonRecipeLoader instance;
    private final Gson GSON = new Gson();
    private final IRecipeSource JSON_RECIPE_SOURCE = new RecipeSource("json", true);
    private final Map<String, IObjectFactory<? extends IInput>> inputFactories = Maps.newHashMap();
    private final Map<String, IObjectFactory<? extends IOutput>> outputFactories = Maps.newHashMap();
    private final Map<String, IObjectFactory<? extends ICondition>> conditionFactories = Maps.newHashMap();

    public static JsonRecipeLoader getInstance() {
        if (instance == null) {
            instance = new JsonRecipeLoader();
        }
        return instance;
    }

    private JsonRecipeLoader() {
        RegisterRecipeFactoriesEvent<IInput> inputEvent = new RegisterRecipeFactoriesEvent<IInput>(IInput.class);
        MinecraftForge.EVENT_BUS.post(inputEvent);
        this.inputFactories.putAll(inputEvent.getFactories());
        RegisterRecipeFactoriesEvent<IOutput> outputEvent = new RegisterRecipeFactoriesEvent<IOutput>(IOutput.class);
        MinecraftForge.EVENT_BUS.post(outputEvent);
        this.outputFactories.putAll(outputEvent.getFactories());
        RegisterRecipeFactoriesEvent<ICondition> conditionEvent = new RegisterRecipeFactoriesEvent<ICondition>(ICondition.class);
        MinecraftForge.EVENT_BUS.post(conditionEvent);
        this.conditionFactories.putAll(conditionEvent.getFactories());
    }

    @Override
    public IRecipeSource getRecipeSource() {
        return this.JSON_RECIPE_SOURCE;
    }

    @Override
    public List<Recipe> loadRecipes() {
        return Loader.instance().getActiveModList().parallelStream().map(this::loadRecipesForMod).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<Recipe> loadRecipesForMod(ModContainer mod) {
        JsonContext ctx = new JsonContext(mod.getModId());
        ArrayList recipes = Lists.newArrayList();
        CraftingHelper.findFiles((ModContainer)mod, (String)("assets/" + mod.getModId() + "/base/recipe_system"), root -> true, (root, file) -> {
            block18: {
                String relative = root.relativize((Path)file).toString();
                if (!"json".equals(FilenameUtils.getExtension((String)file.toString())) || relative.startsWith("_")) {
                    return true;
                }
                String name = FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/");
                ResourceLocation key = new ResourceLocation(ctx.getModId(), name);
                try (BufferedReader bufferedReader = Files.newBufferedReader(file);){
                    JsonObject jsonObject = (JsonObject)JsonUtils.func_193839_a((Gson)this.GSON, (Reader)bufferedReader, JsonObject.class);
                    if (jsonObject == null || !jsonObject.has("type")) break block18;
                    String typeName = jsonObject.get("type").getAsString();
                    RecipeType recipeType = RecipeSystem.getRecipeType(typeName);
                    if (recipeType != null) {
                        boolean loadRecipe = true;
                        if (jsonObject.has("load_conditions")) {
                            loadRecipe = CraftingHelper.processConditions((JsonArray)JsonUtils.func_151214_t((JsonObject)jsonObject, (String)"load_conditions"), (JsonContext)ctx);
                        }
                        if (loadRecipe) {
                            int priority = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"priority", (int)0);
                            JsonArray inputsJson = JsonUtils.func_151214_t((JsonObject)jsonObject, (String)"inputs");
                            JsonArray outputsJson = JsonUtils.func_151214_t((JsonObject)jsonObject, (String)"outputs");
                            JsonArray conditionsJson = JsonUtils.func_151213_a((JsonObject)jsonObject, (String)"conditions", (JsonArray)new JsonArray());
                            List inputList = JsonRecipeLoader.processJsonArray(inputsJson, ctx, this.inputFactories::get, "Input");
                            List<IOutput> outputList = this.processOutputs(outputsJson, ctx);
                            List conditionList = JsonRecipeLoader.processJsonArray(conditionsJson, ctx, this.conditionFactories::get, "Conditions");
                            recipes.add(new Recipe(key, priority, this.JSON_RECIPE_SOURCE, recipeType, inputList, outputList, conditionList));
                        }
                        break block18;
                    }
                    throw new JsonParseException("No Recipe Type found for: " + typeName);
                }
                catch (JsonParseException | IOException e) {
                    Base.instance.getLogger().getLogger().warn("Error in recipe: " + key.toString(), e);
                }
            }
            return true;
        }, (boolean)true, (boolean)true);
        return recipes;
    }

    public List<IOutput> processOutputs(JsonArray jsonElements, JsonContext context) {
        return JsonRecipeLoader.processJsonArray(jsonElements, context, this.outputFactories::get, "Output");
    }

    private static <T> List<T> processJsonArray(JsonArray jsonElements, JsonContext context, Function<String, IObjectFactory<? extends T>> factoryFunction, String name) {
        ArrayList processedList = Lists.newArrayList();
        for (JsonElement element : jsonElements) {
            if (element.isJsonObject()) {
                JsonObject jsonObject = element.getAsJsonObject();
                String typeName = JsonUtils.func_151200_h((JsonObject)jsonObject, (String)"type");
                IObjectFactory<T> factory = factoryFunction.apply(typeName);
                jsonObject.remove("type");
                if (factory != null) {
                    processedList.add(factory.parse(context, (JsonElement)jsonObject));
                    continue;
                }
                throw new JsonParseException("No " + name + " found for type: " + typeName);
            }
            throw new JsonParseException(name + "s must be JSON Objects");
        }
        return processedList;
    }
}

