/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks.tweaks;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public class TweakBlockHardness {
    public static void configure(Configuration config) {
        ConfigCategory category = config.getCategory("tweaks");
        String[] values = config.get(category.getName(), "block_hardness", new String[0]).getStringList();
        category.get("block_hardness").setComment("Here you can override the hardness of blocks.\n- Syntax: modid:blockid=hardness\n- Example: minecraft:stone=100\nYou can also override using OreDictionary entries.\n- Syntax: ore:orevalue=hardness\n- Example: ore:oreCopper=25");
        for (String value : values) {
            float hardness;
            String[] parts = value.split("=");
            String blockName = parts[0];
            if (parts.length != 2) continue;
            try {
                hardness = Float.valueOf(parts[1]).floatValue();
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (blockName.startsWith("ore:")) {
                for (ItemStack stack : OreDictionary.getOres((String)blockName.substring(4))) {
                    int[] metadata = new int[]{stack.func_77960_j()};
                    if (stack.func_77960_j() == Short.MAX_VALUE) {
                        metadata = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
                    }
                    Block oreBlock = Block.func_149634_a((Item)stack.func_77973_b());
                    for (int metar : metadata) {
                        if (oreBlock == Blocks.field_150350_a) continue;
                        oreBlock.func_149711_c(hardness);
                    }
                }
                continue;
            }
            if (!ForgeRegistries.BLOCKS.containsKey(new ResourceLocation(blockName))) continue;
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName));
            block.func_149711_c(hardness);
        }
    }
}

