/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.bnbgamingcore.core.module.gen;

import com.bloodnbonesgaming.bnbgamingcore.core.module.IClassTransformerModule;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ASMAdditionRegistry;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ASMDebugHelper;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ASMUtils;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ObfNameHelper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import squeek.asmhelper.com.bloodnbonesgaming.bnbgamingcore.ASMHelper;

public class ModuleMapGenStructureClass
implements IClassTransformerModule {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (ASMUtils.doesClassEqualOrExtend(transformedName, ObfNameHelper.Classes.MAPGENSTRUCTURE, basicClass)) {
            String methodDesc;
            String methodName;
            boolean modified = false;
            ClassNode classNode = ASMHelper.readClassFromBytes(basicClass);
            MethodNode method = ASMHelper.findMethodNodeOfClass(classNode, methodName = ObfNameHelper.Methods.GENERATESTRUCTURE.getName(), methodDesc = ObfNameHelper.Methods.GENERATESTRUCTURE.getDescriptor());
            if (method != null) {
                ASMDebugHelper.logAttemptingTransform(methodName, transformedName);
                if (this.injectGenerateStructureDisableHook(method, transformedName)) {
                    modified = true;
                    ASMDebugHelper.logSuccessfulTransform(methodName, transformedName);
                }
            } else {
                ASMDebugHelper.logNotFound(methodName, transformedName);
            }
            if ((method = ASMHelper.findMethodNodeOfClass(classNode, methodName = ObfNameHelper.Methods.ISINSIDESTRUCTURE.getName(), methodDesc = ObfNameHelper.Methods.ISINSIDESTRUCTURE.getDescriptor())) != null) {
                ASMDebugHelper.logAttemptingTransform(methodName, transformedName);
                if (this.injectisInsideStructureDisableHook(method, transformedName)) {
                    modified = true;
                    ASMDebugHelper.logSuccessfulTransform(methodName, transformedName);
                }
            } else {
                ASMDebugHelper.logNotFound(methodName, transformedName);
            }
            if ((method = ASMHelper.findMethodNodeOfClass(classNode, methodName = ObfNameHelper.Methods.ISPOSITIONINSTRUCTURE.getName(), methodDesc = ObfNameHelper.Methods.ISPOSITIONINSTRUCTURE.getDescriptor())) != null) {
                ASMDebugHelper.logAttemptingTransform(methodName, transformedName);
                if (this.injectIsPositionInStructureDisableHook(method, transformedName)) {
                    modified = true;
                    ASMDebugHelper.logSuccessfulTransform(methodName, transformedName);
                }
            } else {
                ASMDebugHelper.logNotFound(methodName, transformedName);
            }
            if ((method = ASMHelper.findMethodNodeOfClass(classNode, methodName = ObfNameHelper.Methods.GETCLOSESTSTRONGHOLDPOS.getName(), methodDesc = ObfNameHelper.Methods.GETCLOSESTSTRONGHOLDPOS.getDescriptor())) != null) {
                ASMDebugHelper.logAttemptingTransform(methodName, transformedName);
                if (this.injectGetClosestStrongholdPosDisableHook(method, transformedName)) {
                    modified = true;
                    ASMDebugHelper.logSuccessfulTransform(methodName, transformedName);
                }
            } else {
                ASMDebugHelper.logNotFound(methodName, transformedName);
            }
            if (modified) {
                return ASMHelper.writeClassToBytes(classNode);
            }
        }
        return basicClass;
    }

    @Override
    public boolean canBeDisabled() {
        return true;
    }

    @Override
    public String[] getClassesToTransform() {
        return new String[]{"*"};
    }

    @Override
    public String getModuleName() {
        return "transformMapGenStructure";
    }

    @Override
    public void registerAdditions(ASMAdditionRegistry arg0) {
    }

    private boolean injectisInsideStructureDisableHook(MethodNode method, String transformedName) {
        AbstractInsnNode target = ASMHelper.findFirstInstruction(method);
        if (target == null) {
            ASMDebugHelper.unexpectedMethodInstructionPattern(method.name, transformedName);
            return false;
        }
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)ObfNameHelper.Fields.MAPGENSTRUCTURE_WORLD.toInsnNode(180));
        toInject.add((AbstractInsnNode)ObfNameHelper.Methods.ONISINSIDESTRUCTURE.toInsnNode(184));
        LabelNode label = new LabelNode();
        toInject.add((AbstractInsnNode)new JumpInsnNode(153, label));
        toInject.add((AbstractInsnNode)new InsnNode(3));
        toInject.add((AbstractInsnNode)new InsnNode(172));
        toInject.add((AbstractInsnNode)label);
        toInject.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        method.instructions.insertBefore(target, toInject);
        return true;
    }

    private boolean injectGenerateStructureDisableHook(MethodNode method, String transformedName) {
        AbstractInsnNode target = ASMHelper.findFirstInstruction(method);
        if (target == null) {
            ASMDebugHelper.unexpectedMethodInstructionPattern(method.name, transformedName);
            return false;
        }
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
        toInject.add((AbstractInsnNode)ObfNameHelper.Methods.ONGENERATESTRUCTURE.toInsnNode(184));
        LabelNode label = new LabelNode();
        toInject.add((AbstractInsnNode)new JumpInsnNode(153, label));
        toInject.add((AbstractInsnNode)new InsnNode(3));
        toInject.add((AbstractInsnNode)new InsnNode(172));
        toInject.add((AbstractInsnNode)label);
        toInject.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        method.instructions.insertBefore(target, toInject);
        return true;
    }

    private boolean injectIsPositionInStructureDisableHook(MethodNode method, String transformedName) {
        AbstractInsnNode target = ASMHelper.findFirstInstruction(method);
        if (target == null) {
            ASMDebugHelper.unexpectedMethodInstructionPattern(method.name, transformedName);
            return false;
        }
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
        toInject.add((AbstractInsnNode)ObfNameHelper.Methods.ONISPOSITIONINSTRUCTURE.toInsnNode(184));
        LabelNode label = new LabelNode();
        toInject.add((AbstractInsnNode)new JumpInsnNode(153, label));
        toInject.add((AbstractInsnNode)new InsnNode(3));
        toInject.add((AbstractInsnNode)new InsnNode(172));
        toInject.add((AbstractInsnNode)label);
        toInject.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        method.instructions.insertBefore(target, toInject);
        return true;
    }

    private boolean injectGetClosestStrongholdPosDisableHook(MethodNode method, String transformedName) {
        AbstractInsnNode target = ASMHelper.findFirstInstruction(method);
        if (target == null) {
            ASMDebugHelper.unexpectedMethodInstructionPattern(method.name, transformedName);
            return false;
        }
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
        toInject.add((AbstractInsnNode)ObfNameHelper.Methods.ONGETCLOSESTSTRONGHOLDPOS.toInsnNode(184));
        LabelNode label = new LabelNode();
        toInject.add((AbstractInsnNode)new JumpInsnNode(153, label));
        toInject.add((AbstractInsnNode)new InsnNode(1));
        toInject.add((AbstractInsnNode)new InsnNode(176));
        toInject.add((AbstractInsnNode)label);
        toInject.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        method.instructions.insertBefore(target, toInject);
        return true;
    }
}

