/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.network.tile.data;

import com.codetaylor.mc.athenaeum.inventory.IObservableStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.TileDataBase;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.BitSet;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.ItemStackHandler;

public class TileDataItemStackHandler<H extends ItemStackHandler>
extends TileDataBase {
    private H stackHandler;
    private BitSet dirtySlots;

    public TileDataItemStackHandler(H stackHandler) {
        this(stackHandler, 1);
        this.dirtySlots = new BitSet(stackHandler.getSlots());
    }

    public TileDataItemStackHandler(H stackHandler, int updateInterval) {
        super(updateInterval);
        this.stackHandler = stackHandler;
        ((IObservableStackHandler)this.stackHandler).addObserver((handler, slot) -> {
            this.setDirty(true);
            this.dirtySlots.set(slot);
        });
        this.setDirty(true);
    }

    public ItemStackHandler getStackHandler() {
        return this.stackHandler;
    }

    @Override
    public void setDirty(boolean dirty) {
        super.setDirty(dirty);
        if (!dirty) {
            this.dirtySlots.clear();
        }
    }

    @Override
    public void read(PacketBuffer buffer) throws IOException {
        int dirtyCount = buffer.readInt();
        for (int i = 0; i < dirtyCount; ++i) {
            int slot = buffer.readInt();
            boolean clear = buffer.readBoolean();
            if (clear) {
                this.stackHandler.setStackInSlot(slot, ItemStack.field_190927_a);
                continue;
            }
            this.stackHandler.setStackInSlot(slot, this.readItemStack(buffer));
        }
    }

    protected ItemStack readItemStack(PacketBuffer buffer) throws IOException {
        return new ItemStack((NBTTagCompound)Preconditions.checkNotNull((Object)buffer.func_150793_b()));
    }

    @Override
    public void write(PacketBuffer buffer) {
        int dirtyCount = this.dirtySlots.cardinality();
        buffer.writeInt(dirtyCount);
        if (dirtyCount > 0) {
            int i = this.dirtySlots.nextSetBit(0);
            while (i >= 0) {
                buffer.writeInt(i);
                ItemStack itemStack = this.stackHandler.getStackInSlot(i);
                buffer.writeBoolean(itemStack.func_190926_b());
                if (!itemStack.func_190926_b()) {
                    this.writeItemStack(buffer, itemStack);
                }
                i = this.dirtySlots.nextSetBit(i + 1);
            }
        }
    }

    protected void writeItemStack(PacketBuffer buffer, ItemStack itemStack) {
        buffer.func_150786_a(itemStack.serializeNBT());
    }
}

