/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.recipes.CountableIngredient;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.CutterRecipeBuilder;
import gregtech.api.recipes.builders.ImplosionRecipeBuilder;
import gregtech.api.recipes.builders.IntCircuitRecipeBuilder;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.MarkerMaterials;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.type.DustMaterial;
import gregtech.api.unification.material.type.GemMaterial;
import gregtech.api.unification.material.type.IngotMaterial;
import gregtech.api.unification.material.type.MarkerMaterial;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.material.type.SolidMaterial;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.api.util.GTUtility;
import gregtech.common.items.MetaItems;
import gregtech.common.items.behaviors.TurbineRotorBehavior;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;

public class PartsRecipeHandler {
    public static void register() {
        OrePrefix.stick.addProcessingHandler(DustMaterial.class, PartsRecipeHandler::processStick);
        OrePrefix.stickLong.addProcessingHandler(DustMaterial.class, PartsRecipeHandler::processLongStick);
        OrePrefix.plate.addProcessingHandler(DustMaterial.class, PartsRecipeHandler::processPlate);
        OrePrefix.plateDense.addProcessingHandler(IngotMaterial.class, PartsRecipeHandler::processPlateDense);
        OrePrefix.compressed.addProcessingHandler(IngotMaterial.class, PartsRecipeHandler::processCompressed);
        OrePrefix.turbineBlade.addProcessingHandler(IngotMaterial.class, PartsRecipeHandler::processTurbine);
        OrePrefix.rotor.addProcessingHandler(IngotMaterial.class, PartsRecipeHandler::processRotor);
        OrePrefix.bolt.addProcessingHandler(IngotMaterial.class, PartsRecipeHandler::processBolt);
        OrePrefix.screw.addProcessingHandler(IngotMaterial.class, PartsRecipeHandler::processScrew);
        OrePrefix.wireFine.addProcessingHandler(IngotMaterial.class, PartsRecipeHandler::processFineWire);
        OrePrefix.foil.addProcessingHandler(IngotMaterial.class, PartsRecipeHandler::processFoil);
        OrePrefix.lens.addProcessingHandler(GemMaterial.class, PartsRecipeHandler::processLens);
        OrePrefix.gear.addProcessingHandler(SolidMaterial.class, PartsRecipeHandler::processGear);
        OrePrefix.gearSmall.addProcessingHandler(SolidMaterial.class, PartsRecipeHandler::processGear);
        OrePrefix.ring.addProcessingHandler(IngotMaterial.class, PartsRecipeHandler::processRing);
        OrePrefix.springSmall.addProcessingHandler(IngotMaterial.class, PartsRecipeHandler::processSpringSmall);
    }

    public static void processBolt(OrePrefix boltPrefix, IngotMaterial material) {
        ItemStack boltStack = OreDictUnifier.get(boltPrefix, material);
        ItemStack ingotStack = OreDictUnifier.get(OrePrefix.ingot, material);
        ModHandler.addShapedRecipe(String.format("bolt_file_%s", material.toString()), boltStack, "fS", "S ", Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, material));
        ((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().input(OrePrefix.screw, material)).outputs(boltStack)).duration(20)).EUt(24)).buildAndRegister();
        if (!boltStack.func_190926_b() && !ingotStack.func_190926_b()) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().notConsumable(MetaItems.SHAPE_EXTRUDER_BOLT)).input(OrePrefix.ingot, material)).outputs(GTUtility.copyAmount(8, boltStack))).duration(15)).EUt(120)).buildAndRegister();
        }
    }

    public static void processScrew(OrePrefix screwPrefix, IngotMaterial material) {
        ItemStack screwStack = OreDictUnifier.get(screwPrefix, material);
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LATHE_RECIPES.recipeBuilder().input(OrePrefix.bolt, material)).outputs(screwStack)).duration((int)Math.max(1L, material.getAverageMass() / 8L))).EUt(4)).buildAndRegister();
        ModHandler.addShapedRecipe(String.format("screw_%s", material.toString()), screwStack, "fX", "X ", Character.valueOf('X'), new UnificationEntry(OrePrefix.bolt, material));
    }

    public static void processFoil(OrePrefix foilPrefix, IngotMaterial material) {
        ItemStack foilStack = OreDictUnifier.get(foilPrefix, material);
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.BENDER_RECIPES.recipeBuilder().input(OrePrefix.plate, material)).outputs(GTUtility.copyAmount(4, foilStack))).duration((int)material.getAverageMass())).EUt(24)).circuitMeta(0).buildAndRegister();
    }

    public static void processFineWire(OrePrefix fineWirePrefix, IngotMaterial material) {
        ItemStack fineWireStack = OreDictUnifier.get(fineWirePrefix, material);
        ModHandler.addShapelessRecipe(String.format("fine_wire_%s", material.toString()), fineWireStack, Character.valueOf('x'), new UnificationEntry(OrePrefix.foil, material));
        if (material.cableProperties != null) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.WIREMILL_RECIPES.recipeBuilder().input(OrePrefix.wireGtSingle, material)).outputs(OreDictUnifier.get(OrePrefix.wireFine, material, 4))).duration(200)).EUt(8)).buildAndRegister();
        } else {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.WIREMILL_RECIPES.recipeBuilder().input(OrePrefix.ingot, material)).outputs(OreDictUnifier.get(OrePrefix.wireFine, material, 8))).duration(400)).EUt(8)).buildAndRegister();
        }
    }

    public static void processGear(OrePrefix gearPrefix, SolidMaterial material) {
        ItemStack stack = OreDictUnifier.get(gearPrefix, material);
        if (gearPrefix == OrePrefix.gear && material instanceof IngotMaterial) {
            int voltageMultiplier = PartsRecipeHandler.getVoltageMultiplier(material);
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, material, 4)).notConsumable(MetaItems.SHAPE_EXTRUDER_GEAR)).outputs(OreDictUnifier.get(gearPrefix, material))).duration((int)material.getAverageMass() * 5)).EUt(8 * voltageMultiplier)).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ALLOY_SMELTER_RECIPES.recipeBuilder().input(OrePrefix.ingot, material, 8)).notConsumable(MetaItems.SHAPE_MOLD_GEAR)).outputs(OreDictUnifier.get(gearPrefix, material))).duration((int)material.getAverageMass() * 10)).EUt(2 * voltageMultiplier)).buildAndRegister();
        }
        if (material.shouldGenerateFluid()) {
            boolean isSmall = gearPrefix == OrePrefix.gearSmall;
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().notConsumable(isSmall ? MetaItems.SHAPE_MOLD_GEAR_SMALL : MetaItems.SHAPE_MOLD_GEAR)).fluidInputs(material.getFluid(144 * (isSmall ? 1 : 4)))).outputs(stack)).duration(isSmall ? 20 : 100)).EUt(8)).buildAndRegister();
        }
        if (material.hasFlag(DustMaterial.MatFlags.GENERATE_PLATE | SolidMaterial.MatFlags.GENERATE_ROD)) {
            if (gearPrefix == OrePrefix.gearSmall) {
                ModHandler.addShapedRecipe(String.format("small_gear_%s", material), stack, "h ", " P", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, material));
            } else {
                ModHandler.addShapedRecipe(String.format("gear_%s", material), stack, "RPR", "PdP", "RPR", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, material), Character.valueOf('R'), new UnificationEntry(OrePrefix.stick, material));
            }
        }
    }

    public static void processLens(OrePrefix lensPrefix, GemMaterial material) {
        ItemStack stack = OreDictUnifier.get(lensPrefix, material);
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LATHE_RECIPES.recipeBuilder().input(OrePrefix.plate, material)).outputs(stack, OreDictUnifier.get(OrePrefix.dustSmall, material))).duration((int)(material.getAverageMass() / 2L))).EUt(16)).buildAndRegister();
        EnumDyeColor dyeColor = GTUtility.determineDyeColor(material.materialRGB);
        MarkerMaterial colorMaterial = (MarkerMaterial)MarkerMaterials.Color.COLORS.get((Object)dyeColor);
        OreDictUnifier.registerOre(stack, OrePrefix.craftingLens, colorMaterial);
    }

    public static void processPlate(OrePrefix platePrefix, DustMaterial material) {
        if (material.shouldGenerateFluid()) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().notConsumable(MetaItems.SHAPE_MOLD_PLATE)).fluidInputs(material.getFluid(144))).outputs(OreDictUnifier.get(platePrefix, material))).duration(40)).EUt(8)).buildAndRegister();
        }
        if (material.hasFlag(SolidMaterial.MatFlags.MORTAR_GRINDABLE)) {
            ItemStack dustStack = OreDictUnifier.get(OrePrefix.dust, material);
            ModHandler.addShapedRecipe(String.format("plate_to_dust_%s", material), dustStack, "X", "m", Character.valueOf('X'), new UnificationEntry(OrePrefix.plate, material));
        }
    }

    public static void processCompressed(OrePrefix compressed, SolidMaterial material) {
        if (!material.hasFlag(DustMaterial.MatFlags.GENERATE_PLATE)) {
            return;
        }
        ItemStack compressedStack = OreDictUnifier.get(compressed, material);
        ((ImplosionRecipeBuilder)((ImplosionRecipeBuilder)RecipeMaps.IMPLOSION_RECIPES.recipeBuilder().input(OrePrefix.plank, material, 2)).explosivesAmount(2).outputs(compressedStack, OreDictUnifier.get(OrePrefix.dustTiny, Materials.DarkAsh))).buildAndRegister();
    }

    public static void processPlateDense(OrePrefix orePrefix, IngotMaterial material) {
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.BENDER_RECIPES.recipeBuilder().input(OrePrefix.plate, material, 9)).circuitMeta(2).outputs(OreDictUnifier.get(orePrefix, material))).duration((int)Math.max(material.getAverageMass() * 9L, 1L))).EUt(96)).buildAndRegister();
    }

    public static void processRing(OrePrefix ringPrefix, IngotMaterial material) {
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, material)).notConsumable(MetaItems.SHAPE_EXTRUDER_RING)).outputs(OreDictUnifier.get(ringPrefix, material, 4))).duration((int)material.getAverageMass() * 2)).EUt(6 * PartsRecipeHandler.getVoltageMultiplier(material))).buildAndRegister();
        if (!material.hasFlag(DustMaterial.MatFlags.NO_SMASHING)) {
            ModHandler.addShapedRecipe(String.format("ring_%s", material), OreDictUnifier.get(ringPrefix, material), "h ", " X", Character.valueOf('X'), new UnificationEntry(OrePrefix.stick, material));
        }
    }

    public static void processSpringSmall(OrePrefix springPrefix, IngotMaterial material) {
        if (material.cableProperties != null) {
            ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.BENDER_RECIPES.recipeBuilder().input(OrePrefix.wireGtSingle, material)).outputs(OreDictUnifier.get(OrePrefix.springSmall, material, 2))).duration(100)).EUt(8)).buildAndRegister();
        }
    }

    public static void processRotor(OrePrefix rotorPrefix, SolidMaterial material) {
        ItemStack stack = OreDictUnifier.get(rotorPrefix, material);
        ModHandler.addShapedRecipe(String.format("rotor_%s", material.toString()), stack, "PhP", "SRf", "PdP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, material), Character.valueOf('R'), new UnificationEntry(OrePrefix.ring, material), Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, material));
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.plate, material, 4)).input(OrePrefix.ring, material)).outputs(stack)).fluidInputs(Materials.SolderingAlloy.getFluid(32))).duration(240)).EUt(24)).buildAndRegister();
    }

    public static void processStick(OrePrefix stickPrefix, DustMaterial material) {
        if (material instanceof IngotMaterial) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, material)).notConsumable(MetaItems.SHAPE_EXTRUDER_ROD)).outputs(OreDictUnifier.get(OrePrefix.stick, material, 2))).duration((int)material.getAverageMass() * 2)).EUt(6 * PartsRecipeHandler.getVoltageMultiplier(material))).buildAndRegister();
        }
        if (material instanceof GemMaterial || material instanceof IngotMaterial) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LATHE_RECIPES.recipeBuilder().inputs(material instanceof GemMaterial ? CountableIngredient.from(OrePrefix.gem, material) : CountableIngredient.from(OrePrefix.ingot, material))).outputs(OreDictUnifier.get(stickPrefix, material), OreDictUnifier.get(OrePrefix.dustSmall, ((SolidMaterial)material).macerateInto, 2))).duration((int)Math.max(material.getAverageMass() * 5L, 1L))).EUt(16)).buildAndRegister();
        }
        if (material.hasFlag(IngotMaterial.MatFlags.GENERATE_BOLT_SCREW)) {
            ItemStack boltStack = OreDictUnifier.get(OrePrefix.bolt, material);
            ((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().input(stickPrefix, material)).outputs(GTUtility.copyAmount(4, boltStack))).duration((int)Math.max(material.getAverageMass() * 2L, 1L))).EUt(4)).buildAndRegister();
            ModHandler.addShapedRecipe(String.format("bolt_saw_%s", material.toString()), GTUtility.copyAmount(2, boltStack), "s ", " X", Character.valueOf('X'), new UnificationEntry(OrePrefix.stick, material));
        }
        if (!material.hasFlag(DustMaterial.MatFlags.NO_SMASHING) && material.hasFlag(SolidMaterial.MatFlags.GENERATE_LONG_ROD)) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FORGE_HAMMER_RECIPES.recipeBuilder().input(stickPrefix, material, 2)).outputs(OreDictUnifier.get(OrePrefix.stickLong, material))).duration((int)Math.max(material.getAverageMass(), 1L))).EUt(16)).buildAndRegister();
        }
    }

    public static void processLongStick(OrePrefix longStickPrefix, DustMaterial material) {
        ItemStack stack = OreDictUnifier.get(longStickPrefix, material);
        ItemStack stickStack = OreDictUnifier.get(OrePrefix.stick, material);
        if (!material.hasFlag(DustMaterial.MatFlags.NO_WORKING)) {
            ((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)((CutterRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().input(longStickPrefix, material)).outputs(GTUtility.copyAmount(2, stickStack))).duration((int)Math.max(material.getAverageMass(), 1L))).EUt(4)).buildAndRegister();
            ModHandler.addShapedRecipe(String.format("stick_long_%s", material.toString()), GTUtility.copyAmount(2, stickStack), "s", "X", Character.valueOf('X'), new UnificationEntry(OrePrefix.stickLong, material));
            ModHandler.addShapedRecipe(String.format("stick_long_gem_flawless_%s", material.toString()), stickStack, "sf", "G ", Character.valueOf('G'), new UnificationEntry(OrePrefix.gemFlawless, material));
            ModHandler.addShapedRecipe(String.format("stick_long_gem_exquisite_%s", material.toString()), GTUtility.copyAmount(2, stickStack), "sf", "G ", Character.valueOf('G'), new UnificationEntry(OrePrefix.gemExquisite, material));
        }
        if (!material.hasFlag(DustMaterial.MatFlags.NO_SMASHING)) {
            if (material.hasFlag(IngotMaterial.MatFlags.GENERATE_SPRING)) {
                ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.BENDER_RECIPES.recipeBuilder().input(longStickPrefix, material)).outputs(OreDictUnifier.get(OrePrefix.spring, material))).circuitMeta(1).duration(200)).EUt(16)).buildAndRegister();
            }
            ModHandler.addShapedRecipe(String.format("stick_long_stick_%s", material.toString()), stack, "ShS", Character.valueOf('S'), new UnificationEntry(OrePrefix.stick, material));
        }
    }

    public static void processTurbine(OrePrefix toolPrefix, IngotMaterial material) {
        ItemStack rotorStack = MetaItems.TURBINE_ROTOR.getStackForm();
        TurbineRotorBehavior.getInstanceFor(rotorStack).setPartMaterial(rotorStack, material);
        ((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)((IntCircuitRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.turbineBlade, material, 8)).input(OrePrefix.stickLong, Materials.Titanium)).outputs(rotorStack)).duration(320)).EUt(400)).buildAndRegister();
        ModHandler.addShapedRecipe(String.format("turbine_blade_%s", material), OreDictUnifier.get(toolPrefix, material), "PPP", "SPS", "fPd", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, material), Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, material));
    }

    private static int getVoltageMultiplier(Material material) {
        return material instanceof IngotMaterial && ((IngotMaterial)material).blastFurnaceTemperature >= 2800 ? 32 : 8;
    }
}

