/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.multipart;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.render.BlockRenderer;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.NormallyOccludedPart;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TNormalOcclusionPart;
import codechicken.multipart.TPartialOcclusionPart;
import codechicken.multipart.TileMultipart;
import com.google.common.collect.Lists;
import gregtech.api.GregTechAPI;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.ICoverable;
import gregtech.api.pipenet.PipeNet;
import gregtech.api.pipenet.WorldPipeNet;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.pipenet.block.IPipeType;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.pipenet.tile.PipeCoverableImplementation;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.stack.SimpleItemStack;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ParticleHandlerUtil;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class PipeMultiPart<PipeType extends Enum<PipeType>, NodeDataType>
extends TMultiPart
implements TNormalOcclusionPart,
TPartialOcclusionPart,
IPipeTile<PipeType, NodeDataType>,
ICapabilityProvider {
    private BlockPipe<PipeType, NodeDataType, ?> pipeBlock;
    private PipeType pipeType;
    private Material material;
    protected int insulationColor = 0x777777;
    private int blockedConnections;
    private int coverBlockedConnections;
    private NodeDataType cachedNodeData;
    private final PipeCoverableImplementation coverableImplementation = new PipeCoverableImplementation(this);
    protected int activeConnections;
    protected Cuboid6 centerBox;
    protected List<Cuboid6> sidedConnections = new ArrayList<Cuboid6>();
    protected boolean isBeingReplaced = false;

    protected PipeMultiPart() {
    }

    public PipeMultiPart(IPipeTile<PipeType, NodeDataType> sourceTile) {
        this.transferDataFrom(sourceTile);
    }

    protected abstract PipeMultiPart<PipeType, NodeDataType> toTickablePart();

    @Override
    public void transferDataFrom(IPipeTile<PipeType, NodeDataType> sourceTile) {
        this.insulationColor = sourceTile.getInsulationColor();
        this.pipeBlock = sourceTile.getPipeBlock();
        this.pipeType = sourceTile.getPipeType();
        this.material = sourceTile.getPipeMaterial();
        this.blockedConnections = sourceTile.getBlockedConnections();
        sourceTile.getCoverableImplementation().transferDataTo(this.getCoverableImplementation());
        if (sourceTile instanceof PipeMultiPart) {
            PipeMultiPart sourcePart = (PipeMultiPart)sourceTile;
            this.activeConnections = sourcePart.activeConnections;
            this.centerBox = sourcePart.centerBox;
            this.sidedConnections = sourcePart.sidedConnections;
        }
        this.reinitializeShape();
    }

    @Override
    public World getPipeWorld() {
        return this.tile().func_145831_w();
    }

    @Override
    public BlockPos getPipePos() {
        return this.tile().func_174877_v();
    }

    @Override
    public PipeCoverableImplementation getCoverableImplementation() {
        return this.coverableImplementation;
    }

    @Override
    public int getBlockedConnections() {
        return this.blockedConnections;
    }

    private int getMark() {
        return this.insulationColor == 0x777777 ? 0 : this.insulationColor;
    }

    @Override
    public int getInsulationColor() {
        return this.insulationColor;
    }

    @Override
    public Material getPipeMaterial() {
        return this.material;
    }

    @Override
    public void setPipeType(PipeType pipeType) {
        this.pipeType = pipeType;
    }

    @Override
    public void setPipeMaterial(Material pipeMaterial) {
        this.material = pipeMaterial;
    }

    public void setConnectionBlocked(EnumFacing side, boolean blocked) {
        this.coverBlockedConnections = blocked ? (this.coverBlockedConnections |= 1 << side.func_176745_a()) : (this.coverBlockedConnections &= ~(1 << side.func_176745_a()));
        this.updateBlockedConnections();
    }

    @Override
    public IPipeTile<PipeType, NodeDataType> setSupportsTicking() {
        if (this.supportsTicking()) {
            return this;
        }
        PipeMultiPart<PipeType, NodeDataType> newPart = this.toTickablePart();
        this.isBeingReplaced = true;
        newPart.isBeingReplaced = true;
        TileMultipart tileMultipart = this.tile();
        tileMultipart.remPart((TMultiPart)this);
        TileMultipart.addPart((World)tileMultipart.func_145831_w(), (BlockPos)tileMultipart.func_174877_v(), newPart);
        return newPart;
    }

    @Override
    public boolean canPlaceCoverOnSide(EnumFacing side) {
        Cuboid6 plateBox = ICoverable.getCoverPlateBox(side, this.getCoverableImplementation().getCoverPlateThickness(), true);
        NormallyOccludedPart part = new NormallyOccludedPart(plateBox);
        return this.tile().canReplacePart((TMultiPart)this, (TMultiPart)part);
    }

    @Override
    public void setInsulationColor(int color) {
        this.insulationColor = color;
        if (!this.world().field_72995_K) {
            this.sendDescUpdate();
            ((WorldPipeNet)((Object)this.pipeBlock.getWorldPipeNet(this.world()))).updateMark(this.pos(), this.getMark());
        }
    }

    @Override
    public BlockPipe<PipeType, NodeDataType, ?> getPipeBlock() {
        return this.pipeBlock;
    }

    @Override
    public PipeType getPipeType() {
        return this.pipeType;
    }

    @Override
    public NodeDataType getNodeData() {
        if (this.cachedNodeData == null) {
            this.cachedNodeData = this.getPipeBlock().createProperties(this);
        }
        return this.cachedNodeData;
    }

    @Override
    public <T> T getCapabilityInternal(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechCapabilities.CAPABILITY_COVERABLE) {
            return (T)GregtechCapabilities.CAPABILITY_COVERABLE.cast((Object)this.getCoverableImplementation());
        }
        return null;
    }

    @Override
    @Nullable
    public final <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        boolean isCoverable = capability == GregtechCapabilities.CAPABILITY_COVERABLE;
        CoverBehavior coverBehavior = facing == null ? null : this.getCoverableImplementation().getCoverAtSide(facing);
        T defaultValue = this.getCapabilityInternal(capability, facing);
        if (!isCoverable && facing != null) {
            if (coverBehavior != null) {
                return coverBehavior.getCapability(capability, defaultValue);
            }
            if ((this.blockedConnections & 1 << facing.func_176745_a()) > 0) {
                return null;
            }
        }
        return defaultValue;
    }

    public final boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    public boolean occlusionTest(TMultiPart part) {
        return NormalOcclusionTest.apply((TNormalOcclusionPart)this, (TMultiPart)part);
    }

    public Iterable<ItemStack> getDrops() {
        return Lists.newArrayList((Object[])new ItemStack[]{this.getDropStack()});
    }

    public ItemStack pickItem(CuboidRayTraceResult hit) {
        if (hit.cuboid6.data == null) {
            return this.getDropStack();
        }
        if (hit.cuboid6.data instanceof EnumFacing) {
            EnumFacing coverSide = (EnumFacing)hit.cuboid6.data;
            CoverBehavior coverBehavior = this.getCoverableImplementation().getCoverAtSide(coverSide);
            return coverBehavior == null ? ItemStack.field_190927_a : coverBehavior.getCoverDefinition().getDropItemStack();
        }
        return ItemStack.field_190927_a;
    }

    private ItemStack getDropStack() {
        return this.getPipeBlock().getDropItem(this);
    }

    private void reinitializeShape() {
        this.centerBox = BlockPipe.getSideBox(null, ((IPipeType)this.getPipeType()).getThickness());
        this.updateSidedConnections(false);
    }

    private void updateSidedConnections(boolean notify) {
        float thickness = ((IPipeType)this.getPipeType()).getThickness();
        this.sidedConnections.clear();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            int sideIndex = side.func_176745_a();
            if ((this.activeConnections & 1 << sideIndex) <= 0 || (this.blockedConnections & 1 << sideIndex) != 0) continue;
            this.sidedConnections.add(BlockPipe.getSideBox(side, thickness));
        }
        TileMultipart tileMultipart = this.tile();
        if (tileMultipart != null && notify) {
            tileMultipart.notifyPartChange((TMultiPart)this);
            tileMultipart.markRender();
        }
    }

    private void updateBlockedConnections() {
        TileMultipart tileMultipart = this.tile();
        if (tileMultipart == null || tileMultipart.func_145837_r()) {
            return;
        }
        float thickness = ((IPipeType)this.getPipeType()).getThickness();
        int lastBlockedConnections = this.blockedConnections;
        this.blockedConnections = 0;
        for (EnumFacing cableSide : EnumFacing.field_82609_l) {
            if ((this.coverBlockedConnections & 1 << cableSide.func_176745_a()) > 0) {
                this.blockedConnections |= 1 << cableSide.func_176745_a();
                continue;
            }
            Cuboid6 sideBox = BlockPipe.getSideBox(cableSide, thickness);
            NormallyOccludedPart part = new NormallyOccludedPart(sideBox);
            if (tileMultipart.canReplacePart((TMultiPart)this, (TMultiPart)part)) continue;
            this.blockedConnections |= 1 << cableSide.func_176745_a();
        }
        if (lastBlockedConnections != this.blockedConnections) {
            Object worldPipeNet = this.pipeBlock.getWorldPipeNet(this.world());
            for (EnumFacing side : EnumFacing.field_82609_l) {
                boolean wasBlocked;
                boolean isBlockedCurrently = (this.blockedConnections & 1 << side.func_176745_a()) > 0;
                boolean bl = wasBlocked = (lastBlockedConnections & 1 << side.func_176745_a()) > 0;
                if (isBlockedCurrently == wasBlocked) continue;
                ((WorldPipeNet)((Object)worldPipeNet)).updateBlockedConnections(this.pos(), side, isBlockedCurrently);
            }
            this.updateActualConnections();
        }
    }

    private void updateActualConnections() {
        int lastActualConnections = this.activeConnections;
        TileMultipart tileMultipart = this.tile();
        if (tileMultipart != null && !tileMultipart.func_145837_r()) {
            this.activeConnections = this.pipeBlock.getActualConnections(this, (IBlockAccess)tileMultipart.func_145831_w());
        }
        if (lastActualConnections != this.activeConnections) {
            this.updateSidedConnections(true);
        }
    }

    public void onAdded() {
        if (!this.isBeingReplaced) {
            this.updateBlockedConnections();
            this.updateActualConnections();
            this.isBeingReplaced = false;
            if (!this.world().field_72995_K) {
                ((WorldPipeNet)((Object)this.getPipeBlock().getWorldPipeNet(this.world()))).addNode(this.pos(), this.getNodeData(), this.getMark(), this.getBlockedConnections(), this.pipeBlock.getActiveNodeConnections((IBlockAccess)this.world(), this.pos()) > 0);
            }
        }
        this.reinitializeShape();
    }

    public boolean activate(EntityPlayer player, CuboidRayTraceResult hit, ItemStack item, EnumHand hand) {
        SimpleItemStack simpleItemStack;
        EnumFacing coverSide = ICoverable.traceCoverSide((RayTraceResult)hit);
        if (coverSide == null) {
            return false;
        }
        CoverBehavior coverBehavior = this.getCoverableImplementation().getCoverAtSide(coverSide);
        if (coverBehavior == null) {
            return false;
        }
        SimpleItemStack simpleItemStack2 = simpleItemStack = item.func_190926_b() ? null : new SimpleItemStack(item);
        if (simpleItemStack != null && GregTechAPI.screwdriverList.contains(simpleItemStack)) {
            if (GTUtility.doDamageItem(item, 2, true) && coverBehavior.onScrewdriverClick(player, hand, hit) == EnumActionResult.SUCCESS) {
                GTUtility.doDamageItem(item, 2, false);
                return true;
            }
            return false;
        }
        return coverBehavior.onRightClick(player, hand, hit) == EnumActionResult.SUCCESS;
    }

    public void click(EntityPlayer player, CuboidRayTraceResult hit, ItemStack item) {
        EnumFacing coverSide = ICoverable.traceCoverSide((RayTraceResult)hit);
        if (coverSide == null) {
            return;
        }
        CoverBehavior coverBehavior = this.getCoverableImplementation().getCoverAtSide(coverSide);
        if (coverBehavior == null) {
            return;
        }
        coverBehavior.onLeftClick(player, hit);
    }

    public void onRemoved() {
        if (!this.isBeingReplaced && !this.world().field_72995_K) {
            ((WorldPipeNet)((Object)this.pipeBlock.getWorldPipeNet(this.world()))).removeNode(this.pos());
            this.getCoverableImplementation().dropAllCovers();
        }
    }

    public void onPartChanged(TMultiPart part) {
        if (part != this) {
            this.scheduleTick(1);
        }
    }

    public void onNeighborChanged() {
        this.scheduleTick(1);
    }

    public void scheduledTick() {
        this.updateBlockedConnections();
        this.updateActualConnections();
        if (!this.world().field_72995_K) {
            this.getWriteStream().writeByte(1);
            this.updateActiveNodeStatus();
        }
    }

    public void updateActiveNodeStatus() {
        boolean changed;
        int activeConnections = this.pipeBlock.getActiveNodeConnections((IBlockAccess)this.world(), this.pos());
        boolean isActiveNode = (activeConnections &= ~this.getBlockedConnections()) > 0;
        Object pipeNet = ((WorldPipeNet)((Object)this.pipeBlock.getWorldPipeNet(this.world()))).getNetFromPos(this.pos());
        if (pipeNet != null && (changed = ((PipeNet)pipeNet).markNodeAsActive(this.pos(), isActiveNode))) {
            this.onModeChange(isActiveNode);
        }
    }

    protected void onModeChange(boolean isActiveNow) {
    }

    public void sendDescUpdate() {
        MCDataOutput writeStream = this.getWriteStream();
        writeStream.writeByte(0);
        this.writeDesc(writeStream);
    }

    public void save(NBTTagCompound tag) {
        tag.func_74778_a("PipeBlock", ((ResourceLocation)Block.field_149771_c.func_177774_c(this.pipeBlock)).toString());
        tag.func_74768_a("PipeType", ((Enum)this.pipeType).ordinal());
        tag.func_74778_a("PipeMaterial", this.material.toString());
        tag.func_74768_a("InsulationColor", this.insulationColor);
        tag.func_74768_a("ActiveConnections", this.activeConnections);
        if (this.blockedConnections > 0) {
            tag.func_74768_a("BlockedConnections", this.blockedConnections);
        }
        this.getCoverableImplementation().readFromNBT(tag);
    }

    public void load(NBTTagCompound tag) {
        ResourceLocation pipeBlockName = new ResourceLocation(tag.func_74779_i("PipeBlock"));
        this.pipeBlock = (BlockPipe)Block.field_149771_c.func_82594_a((Object)pipeBlockName);
        this.pipeType = ((Enum[])this.pipeBlock.getPipeTypeClass().getEnumConstants())[tag.func_74762_e("PipeType")];
        this.material = (Material)Material.MATERIAL_REGISTRY.func_82594_a(tag.func_74779_i("PipeMaterial"));
        this.insulationColor = tag.func_74762_e("InsulationColor");
        this.activeConnections = tag.func_74762_e("ActiveConnections");
        this.blockedConnections = tag.func_74762_e("BlockedConnections");
        this.getCoverableImplementation().writeToNBT(tag);
        this.reinitializeShape();
    }

    public void writeDesc(MCDataOutput packet) {
        packet.writeVarInt(Block.field_149771_c.func_148757_b(this.pipeBlock));
        packet.writeEnum(this.pipeType);
        packet.writeVarInt(Material.MATERIAL_REGISTRY.getIDForObject(this.material));
        packet.writeInt(this.insulationColor);
        packet.writeVarInt(this.activeConnections);
        packet.writeVarInt(this.blockedConnections);
        PacketBuffer packetBuffer = new PacketBuffer(Unpooled.buffer());
        this.getCoverableImplementation().writeInitialSyncData(packetBuffer);
        byte[] dataArray = packetBuffer.array();
        packet.writeVarInt(dataArray.length);
        packet.writeArray(dataArray);
    }

    public void readDesc(MCDataInput packet) {
        this.pipeBlock = (BlockPipe)Block.field_149771_c.func_148754_a(packet.readVarInt());
        this.pipeType = packet.readEnum(this.pipeBlock.getPipeTypeClass());
        this.material = Material.MATERIAL_REGISTRY.getObjectById(packet.readVarInt());
        this.insulationColor = packet.readInt();
        this.activeConnections = packet.readVarInt();
        this.blockedConnections = packet.readVarInt();
        byte[] dataArray = packet.readArray(packet.readVarInt());
        this.getCoverableImplementation().readInitialSyncData(new PacketBuffer(Unpooled.wrappedBuffer((byte[])dataArray)));
        this.reinitializeShape();
    }

    public void read(MCDataInput packet) {
        byte packetType = packet.readByte();
        if (packetType == 0) {
            this.readDesc(packet);
        } else if (packetType == 1) {
            this.updateActualConnections();
        } else if (packetType == 2) {
            int dataId = packet.readVarInt();
            byte[] payload = packet.readArray(packet.readVarInt());
            PacketBuffer buffer = new PacketBuffer(Unpooled.wrappedBuffer((byte[])payload));
            this.getCoverableImplementation().readCustomData(dataId, buffer);
        } else if (packetType == 3) {
            this.tile().markRender();
        }
        this.tile().markRender();
    }

    @Override
    public void writeCoverCustomData(int id, Consumer<PacketBuffer> writer) {
        MCDataOutput writeStream = this.getWriteStream();
        writeStream.writeByte(2);
        writeStream.writeVarInt(id);
        PacketBuffer packetBuffer = new PacketBuffer(Unpooled.buffer());
        writer.accept(packetBuffer);
        byte[] dataArray = packetBuffer.array();
        writeStream.writeVarInt(dataArray.length);
        writeStream.writeArray(dataArray);
    }

    public Iterable<IndexedCuboid6> getSubParts() {
        ArrayList<IndexedCuboid6> result = new ArrayList<IndexedCuboid6>();
        result.add(new IndexedCuboid6(null, this.centerBox));
        for (Cuboid6 sidedBox : this.sidedConnections) {
            result.add(new IndexedCuboid6(null, sidedBox));
        }
        this.getCoverableImplementation().addCoverCollisionBoundingBox(result, false);
        return result;
    }

    public Iterable<Cuboid6> getCollisionBoxes() {
        ArrayList<Cuboid6> result = new ArrayList<Cuboid6>();
        result.add(this.centerBox);
        result.addAll(this.sidedConnections);
        this.getCoverableImplementation().addCoverCollisionBoundingBox(result, false);
        return result;
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        ArrayList<Cuboid6> result = new ArrayList<Cuboid6>();
        result.add(this.centerBox);
        this.getCoverableImplementation().addCoverCollisionBoundingBox(result, true);
        return result;
    }

    public Iterable<Cuboid6> getPartialOcclusionBoxes() {
        ArrayList<Cuboid6> result = new ArrayList<Cuboid6>(this.sidedConnections);
        this.getCoverableImplementation().addCoverCollisionBoundingBox(result, false);
        return result;
    }

    public boolean allowCompleteOcclusion() {
        return true;
    }

    @Override
    public void notifyBlockUpdate() {
        this.tile().notifyTileChange();
        this.updateActiveNodeStatus();
        this.updateActualConnections();
        if (!this.world().field_72995_K) {
            this.getWriteStream().writeByte(1);
            this.updateActiveNodeStatus();
        }
    }

    @Override
    public void scheduleChunkForRenderUpdate() {
        this.tile().markRender();
    }

    @Override
    public boolean isValidTile() {
        return this.tile() != null && !this.tile().func_145837_r();
    }

    @Override
    public void markAsDirty() {
        this.tile().func_70296_d();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderBreaking(Vector3 pos, TextureAtlasSprite texture, CCRenderState ccrs) {
        ccrs.setPipeline(new IVertexOperation[]{pos.translation(), new IconTransformation(texture)});
        BlockRenderer.renderCuboid((CCRenderState)ccrs, (Cuboid6)this.centerBox, (int)0);
        for (Cuboid6 sidedConnection : this.sidedConnections) {
            BlockRenderer.renderCuboid((CCRenderState)ccrs, (Cuboid6)sidedConnection, (int)0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public abstract TextureAtlasSprite getParticleTexture();

    public void addHitEffects(CuboidRayTraceResult hit, ParticleManager manager) {
        ParticleHandlerUtil.addHitEffects(this.world(), hit, this.getParticleTexture(), manager);
    }

    public void addDestroyEffects(CuboidRayTraceResult hit, ParticleManager manager) {
        ParticleHandlerUtil.addBlockDestroyEffects(this.world(), hit, this.getParticleTexture(), manager);
    }
}

