/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.multipart;

import codechicken.lib.data.MCDataInput;
import codechicken.multipart.MultiPartRegistry;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.api.IDynamicPartFactory;
import codechicken.multipart.api.IPartConverter;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.pipenet.tile.TileEntityPipeBase;
import gregtech.common.multipart.CableMultiPart;
import gregtech.common.multipart.CableMultiPartTickable;
import gregtech.common.multipart.FluidPipeActiveMultiPart;
import gregtech.common.multipart.FluidPipeMultiPart;
import gregtech.common.multipart.PipeMultiPart;
import gregtech.common.pipelike.cable.BlockCable;
import gregtech.common.pipelike.fluidpipe.BlockFluidPipe;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class GTMultipartFactory
implements IDynamicPartFactory,
IPartConverter {
    public static final ResourceLocation CABLE_PART_KEY = new ResourceLocation("gregtech", "cable");
    public static final ResourceLocation CABLE_PART_TICKABLE_KEY = new ResourceLocation("gregtech", "cable_tickable");
    public static final ResourceLocation FLUID_PIPE_PART_KEY = new ResourceLocation("gregtech", "fluid_pipe");
    public static final ResourceLocation FLUID_PIPE_ACTIVE_PART_KEY = new ResourceLocation("gregtech", "fluid_pipe_active");
    public static final GTMultipartFactory INSTANCE = new GTMultipartFactory();
    private final Map<ResourceLocation, Supplier<TMultiPart>> partRegistry = new HashMap<ResourceLocation, Supplier<TMultiPart>>();
    private final Map<Predicate<Block>, BiFunction<IBlockState, TileEntity, TMultiPart>> converterRegistry = new HashMap<Predicate<Block>, BiFunction<IBlockState, TileEntity, TMultiPart>>();

    public void registerFactory() {
        this.registerPart(CABLE_PART_KEY, CableMultiPart::new);
        this.registerPart(CABLE_PART_TICKABLE_KEY, CableMultiPartTickable::new);
        this.registerPart(FLUID_PIPE_PART_KEY, FluidPipeMultiPart::new);
        this.registerPart(FLUID_PIPE_ACTIVE_PART_KEY, FluidPipeActiveMultiPart::new);
        this.registerPipeConverter(block -> block instanceof BlockCable, CableMultiPart::new, CableMultiPartTickable::new);
        this.registerPipeConverter(block -> block instanceof BlockFluidPipe, FluidPipeMultiPart::new, FluidPipeActiveMultiPart::new);
        MultiPartRegistry.registerParts((IDynamicPartFactory)this, this.partRegistry.keySet());
        MultiPartRegistry.registerConverter((IPartConverter)this);
    }

    private void registerPart(ResourceLocation identifier, Supplier<TMultiPart> supplier) {
        this.partRegistry.put(identifier, supplier);
    }

    private <T extends Enum<T>, E> void registerPipeConverter(Predicate<Block> block, Function<IPipeTile<T, E>, PipeMultiPart<T, E>> normalConverter, Function<IPipeTile<T, E>, PipeMultiPart<T, E>> tickableConverter) {
        this.registerConverter(block, (blockState, tileEntity) -> {
            TileEntityPipeBase pipeTileEntity = (TileEntityPipeBase)tileEntity;
            pipeTileEntity.setBeingConverted(true);
            if (pipeTileEntity.supportsTicking()) {
                return (TMultiPart)tickableConverter.apply(pipeTileEntity);
            }
            return (TMultiPart)normalConverter.apply(pipeTileEntity);
        });
    }

    private void registerConverter(Predicate<Block> block, BiFunction<IBlockState, TileEntity, TMultiPart> converter) {
        this.converterRegistry.put(block, converter);
    }

    public TMultiPart createPartServer(ResourceLocation identifier, NBTTagCompound compound) {
        return this.createPart(identifier);
    }

    public TMultiPart createPartClient(ResourceLocation identifier, MCDataInput packet) {
        return this.createPart(identifier);
    }

    public TMultiPart createPart(ResourceLocation identifier) {
        if (this.partRegistry.containsKey(identifier)) {
            Supplier<TMultiPart> supplier = this.partRegistry.get(identifier);
            return supplier.get();
        }
        return null;
    }

    private BiFunction<IBlockState, TileEntity, TMultiPart> findConverter(Block block) {
        return this.converterRegistry.entrySet().stream().filter(entry -> ((Predicate)entry.getKey()).test(block)).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    public boolean canConvert(World world, BlockPos pos, IBlockState state) {
        return this.findConverter(state.func_177230_c()) != null;
    }

    public TMultiPart convert(World world, BlockPos pos, IBlockState state) {
        BiFunction<IBlockState, TileEntity, TMultiPart> converter = this.findConverter(state.func_177230_c());
        if (converter != null) {
            TileEntity tileEntity = world.func_175625_s(pos);
            return converter.apply(state, tileEntity);
        }
        return null;
    }
}

