/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.steam.boiler;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.impl.FilteredFluidHandler;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.FluidContainerSlotWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.TankWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.recipes.ModHandler;
import gregtech.api.render.OrientedOverlayRenderer;
import gregtech.api.render.SimpleSidedCubeRenderer;
import gregtech.api.render.Textures;
import gregtech.api.util.GTUtility;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;

public abstract class SteamBoiler
extends MetaTileEntity {
    private static final EnumFacing[] STEAM_PUSH_DIRECTIONS = (EnumFacing[])ArrayUtils.add((Object[])EnumFacing.field_176754_o, (Object)EnumFacing.UP);
    public static final int BOILING_CYCLE_LENGTH = 25;
    public static final int HIGH_PRESSURE_BOILING_CYCLE_LENGTH = 10;
    public final TextureArea BRONZE_BACKGROUND_TEXTURE;
    public final TextureArea BRONZE_SLOT_BACKGROUND_TEXTURE;
    public final TextureArea SLOT_FURNACE_BACKGROUND;
    protected final boolean isHighPressure;
    protected final int baseSteamOutput;
    private final OrientedOverlayRenderer renderer;
    protected FluidTank waterFluidTank;
    protected FluidTank steamFluidTank;
    private int fuelBurnTimeLeft;
    private int fuelMaxBurnTime;
    private int currentTemperature;
    private boolean hasNoWater;
    private int timeBeforeCoolingDown;
    private boolean isBurning;
    private boolean wasBurningAndNeedsUpdate;
    private ItemStackHandler containerInventory;

    public SteamBoiler(ResourceLocation metaTileEntityId, boolean isHighPressure, OrientedOverlayRenderer renderer, int baseSteamOutput) {
        super(metaTileEntityId);
        this.renderer = renderer;
        this.isHighPressure = isHighPressure;
        this.baseSteamOutput = baseSteamOutput;
        this.BRONZE_BACKGROUND_TEXTURE = this.getGuiTexture("%s_gui");
        this.BRONZE_SLOT_BACKGROUND_TEXTURE = this.getGuiTexture("slot_%s");
        this.SLOT_FURNACE_BACKGROUND = this.getGuiTexture("slot_%s_furnace_background");
        this.containerInventory = new ItemStackHandler(2);
    }

    @SideOnly(value=Side.CLIENT)
    private SimpleSidedCubeRenderer getBaseRenderer() {
        if (this.isHighPressure) {
            return Textures.STEAM_BRICKED_CASING_STEEL;
        }
        return Textures.STEAM_BRICKED_CASING_BRONZE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getParticleTexture() {
        return this.getBaseRenderer().getSpriteOnSide(SimpleSidedCubeRenderer.RenderSide.TOP);
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        IVertexOperation[] colouredPipeline = (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering())));
        this.getBaseRenderer().render(renderState, translation, colouredPipeline);
        this.renderer.render(renderState, translation, pipeline, this.getFrontFacing(), this.isBurning());
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74768_a("FuelBurnTimeLeft", this.fuelBurnTimeLeft);
        data.func_74768_a("FuelMaxBurnTime", this.fuelMaxBurnTime);
        data.func_74768_a("CurrentTemperature", this.currentTemperature);
        data.func_74757_a("HasNoWater", this.hasNoWater);
        data.func_74782_a("ContainerInventory", (NBTBase)this.containerInventory.serializeNBT());
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.fuelBurnTimeLeft = data.func_74762_e("FuelBurnTimeLeft");
        this.fuelMaxBurnTime = data.func_74762_e("FuelMaxBurnTime");
        this.currentTemperature = data.func_74762_e("CurrentTemperature");
        this.hasNoWater = data.func_74767_n("HasNoWater");
        this.containerInventory.deserializeNBT(data.func_74775_l("ContainerInventory"));
        this.isBurning = this.fuelBurnTimeLeft > 0;
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.isBurning);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.isBurning = buf.readBoolean();
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == 100) {
            this.isBurning = buf.readBoolean();
            this.getHolder().scheduleChunkForRenderUpdate();
        }
    }

    public void setFuelMaxBurnTime(int fuelMaxBurnTime) {
        this.fuelMaxBurnTime = fuelMaxBurnTime;
        this.fuelBurnTimeLeft = fuelMaxBurnTime;
        if (!this.getWorld().field_72995_K) {
            this.markDirty();
        }
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K) {
            this.updateCurrentTemperature();
            this.generateSteam();
            if (this.getTimer() % 5L == 0L) {
                this.fillInternalTankFromFluidContainer((IItemHandlerModifiable)this.containerInventory, (IItemHandlerModifiable)this.containerInventory, 0, 1);
                this.pushFluidsIntoNearbyHandlers(STEAM_PUSH_DIRECTIONS);
            }
            if (this.fuelMaxBurnTime <= 0) {
                this.tryConsumeNewFuel();
                if (this.fuelBurnTimeLeft > 0) {
                    if (this.wasBurningAndNeedsUpdate) {
                        this.wasBurningAndNeedsUpdate = false;
                    } else {
                        this.setBurning(true);
                    }
                }
            }
            if (this.wasBurningAndNeedsUpdate) {
                this.wasBurningAndNeedsUpdate = false;
                this.setBurning(false);
            }
        }
    }

    private void updateCurrentTemperature() {
        if (this.fuelMaxBurnTime > 0) {
            if (this.getTimer() % 12L == 0L) {
                if (this.fuelBurnTimeLeft % 2 == 0 && this.currentTemperature < this.getMaxTemperate()) {
                    ++this.currentTemperature;
                }
                this.fuelBurnTimeLeft -= this.isHighPressure ? 2 : 1;
                if (this.fuelBurnTimeLeft == 0) {
                    this.fuelMaxBurnTime = 0;
                    this.timeBeforeCoolingDown = 40;
                    this.wasBurningAndNeedsUpdate = true;
                }
            }
        } else if (this.timeBeforeCoolingDown == 0) {
            if (this.currentTemperature > 0) {
                --this.currentTemperature;
            }
        } else {
            --this.timeBeforeCoolingDown;
        }
    }

    private void generateSteam() {
        if (this.currentTemperature >= 100 && this.getTimer() % (long)this.getBoilingCycleLength() == 0L) {
            int fillAmount = (int)((double)this.baseSteamOutput * ((double)this.currentTemperature / ((double)this.getMaxTemperate() * 1.0)));
            boolean hasDrainedWater = this.waterFluidTank.drain(1, true) != null;
            int filledSteam = 0;
            if (hasDrainedWater) {
                filledSteam = this.steamFluidTank.fill(ModHandler.getSteam(fillAmount), true);
            }
            if (this.hasNoWater && hasDrainedWater) {
                this.getWorld().func_175698_g(this.getPos());
                this.getWorld().func_72876_a(null, (double)this.getPos().func_177958_n() + 0.5, (double)this.getPos().func_177956_o() + 0.5, (double)this.getPos().func_177952_p() + 0.5, 2.0f, true);
            } else {
                boolean bl = this.hasNoWater = !hasDrainedWater;
            }
            if (filledSteam == 0 && hasDrainedWater) {
                this.getWorld().func_184148_a(null, (double)this.getPos().func_177958_n() + 0.5, (double)this.getPos().func_177956_o() + 0.5, (double)this.getPos().func_177952_p() + 0.5, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.steamFluidTank.drain(4000, true);
            }
        }
    }

    public boolean isBurning() {
        return this.isBurning;
    }

    public void setBurning(boolean burning) {
        this.isBurning = burning;
        if (!this.getWorld().field_72995_K) {
            this.markDirty();
            this.writeCustomData(100, buf -> buf.writeBoolean(burning));
        }
    }

    protected abstract void tryConsumeNewFuel();

    public int getMaxTemperate() {
        return this.isHighPressure ? 1000 : 500;
    }

    public double getTemperaturePercent() {
        return (double)this.currentTemperature / ((double)this.getMaxTemperate() * 1.0);
    }

    public double getFuelLeftPercent() {
        return this.fuelMaxBurnTime == 0 ? 0.0 : (double)this.fuelBurnTimeLeft / ((double)this.fuelMaxBurnTime * 1.0);
    }

    @Override
    protected FluidTankList createImportFluidHandler() {
        this.waterFluidTank = new FilteredFluidHandler(16000).setFillPredicate(ModHandler::isWater);
        return new FluidTankList(false, new IFluidTank[]{this.waterFluidTank});
    }

    @Override
    protected FluidTankList createExportFluidHandler() {
        this.steamFluidTank = new FluidTank(16000);
        return new FluidTankList(false, new IFluidTank[]{this.steamFluidTank});
    }

    protected TextureArea getGuiTexture(String pathTemplate) {
        String type = this.isHighPressure ? "steel" : "bronze";
        return TextureArea.fullImage(String.format("textures/gui/steam/%s/%s.png", type, pathTemplate.replace("%s", type)));
    }

    public ModularUI.Builder createUITemplate(EntityPlayer player) {
        return ModularUI.builder(this.BRONZE_BACKGROUND_TEXTURE, 176, 166).widget(new LabelWidget(6, 6, this.getMetaFullName(), new Object[0])).widget(new ProgressWidget(this::getTemperaturePercent, 95, 17, 11, 55).setProgressBar(this.getGuiTexture("bar_%s_empty"), this.getGuiTexture("bar_heat"), ProgressWidget.MoveType.VERTICAL)).widget(new TankWidget((IFluidTank)this.waterFluidTank, 82, 17, 11, 55).setBackgroundTexture(this.getGuiTexture("bar_%s_empty"))).widget(new TankWidget((IFluidTank)this.steamFluidTank, 69, 17, 11, 55).setBackgroundTexture(this.getGuiTexture("bar_%s_empty"))).widget(new FluidContainerSlotWidget((IItemHandlerModifiable)this.containerInventory, 0, 43, 18, true).setBackgroundTexture(this.BRONZE_SLOT_BACKGROUND_TEXTURE, this.getGuiTexture("overlay_%s_in"))).widget(new SlotWidget((IItemHandlerModifiable)this.containerInventory, 1, 43, 54, true, false).setBackgroundTexture(this.BRONZE_SLOT_BACKGROUND_TEXTURE, this.getGuiTexture("overlay_%s_out"))).widget(new ImageWidget(42, 35, 18, 18).setImage(this.getGuiTexture("overlay_%s_fluid_container"))).bindPlayerInventory(player.field_71071_by, this.BRONZE_SLOT_BACKGROUND_TEXTURE);
    }

    private int getBoilingCycleLength() {
        return this.isHighPressure ? 10 : 25;
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.steam_boiler.tooltip_produces", (Object[])new Object[]{this.baseSteamOutput, this.getBoilingCycleLength()}));
    }
}

