/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric.generator;

import gregtech.api.GTValues;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.FuelRecipeMapWorkableHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.multiblock.BlockPattern;
import gregtech.api.multiblock.FactoryBlockPattern;
import gregtech.api.multiblock.PatternMatchContext;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.machines.FuelRecipeMap;
import gregtech.api.render.ICubeRenderer;
import gregtech.api.render.Textures;
import gregtech.common.blocks.BlockTurbineCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.electric.multiblockpart.MetaTileEntityRotorHolder;
import gregtech.common.metatileentities.multi.electric.generator.FueledMultiblockController;
import gregtech.common.metatileentities.multi.electric.generator.LargeTurbineWorkableHandler;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class MetaTileEntityLargeTurbine
extends FueledMultiblockController {
    public static final MultiblockAbility<MetaTileEntityRotorHolder> ABILITY_ROTOR_HOLDER = new MultiblockAbility();
    private static final int MIN_DURABILITY_TO_WARN = 10;
    public final TurbineType turbineType;
    public IFluidHandler exportFluidHandler;

    public MetaTileEntityLargeTurbine(ResourceLocation metaTileEntityId, TurbineType turbineType) {
        super(metaTileEntityId, turbineType.recipeMap, GTValues.V[4]);
        this.turbineType = turbineType;
        this.reinitializeStructurePattern();
    }

    @Override
    protected FuelRecipeMapWorkableHandler createWorkable(long maxVoltage) {
        return new LargeTurbineWorkableHandler(this, this.recipeMap, () -> this.energyContainer, () -> this.importFluidHandler, maxVoltage);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(MetaTileEntityHolder holder) {
        return new MetaTileEntityLargeTurbine(this.metaTileEntityId, this.turbineType);
    }

    @Override
    protected void updateFormedValid() {
        if (this.isTurbineFaceFree()) {
            super.updateFormedValid();
        }
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        this.exportFluidHandler = new FluidTankList(true, this.getAbilities(MultiblockAbility.EXPORT_FLUIDS));
    }

    @Override
    public void invalidateStructure() {
        super.invalidateStructure();
        this.exportFluidHandler = null;
    }

    public boolean isActive() {
        return this.isTurbineFaceFree() && this.workableHandler.isActive() && this.workableHandler.isWorkingEnabled();
    }

    public boolean isTurbineFaceFree() {
        return this.isStructureFormed() && this.getAbilities(ABILITY_ROTOR_HOLDER).get(0).isFrontFaceFree();
    }

    @Override
    protected void addDisplayText(List<ITextComponent> textList) {
        if (this.isStructureFormed()) {
            MetaTileEntityRotorHolder rotorHolder = this.getAbilities(ABILITY_ROTOR_HOLDER).get(0);
            FluidStack fuelStack = ((LargeTurbineWorkableHandler)this.workableHandler).getFuelStack();
            int fuelAmount = fuelStack == null ? 0 : fuelStack.amount;
            TextComponentTranslation fuelName = new TextComponentTranslation(fuelAmount == 0 ? "gregtech.fluid.empty" : fuelStack.getUnlocalizedName(), new Object[0]);
            textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.turbine.fuel_amount", new Object[]{fuelAmount, fuelName}));
            if (rotorHolder.getRotorEfficiency() > 0.0) {
                textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.turbine.rotor_speed", new Object[]{rotorHolder.getCurrentRotorSpeed(), rotorHolder.getMaxRotorSpeed()}));
                textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.turbine.rotor_efficiency", new Object[]{(int)(rotorHolder.getRotorEfficiency() * 100.0)}));
                int rotorDurability = (int)(rotorHolder.getRotorDurability() * 100.0);
                if (rotorDurability > 10) {
                    textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.turbine.rotor_durability", new Object[]{rotorDurability}));
                } else {
                    textList.add(new TextComponentTranslation("gregtech.multiblock.turbine.low_rotor_durability", new Object[]{10, rotorDurability}).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                }
            }
        }
        super.addDisplayText(textList);
    }

    @Override
    protected BlockPattern createStructurePattern() {
        return this.turbineType == null ? null : FactoryBlockPattern.start().aisle("CCCC", "CHHC", "CCCC").aisle("CHHC", "R##D", "CHHC").aisle("CCCC", "CSHC", "CCCC").where('S', this.selfPredicate()).where('#', MetaTileEntityLargeTurbine.isAirPredicate()).where('C', MetaTileEntityLargeTurbine.statePredicate(this.getCasingState())).where('H', MetaTileEntityLargeTurbine.statePredicate(this.getCasingState()).or(MetaTileEntityLargeTurbine.abilityPartPredicate(this.getAllowedAbilities()))).where('R', MetaTileEntityLargeTurbine.abilityPartPredicate(ABILITY_ROTOR_HOLDER)).where('D', MetaTileEntityLargeTurbine.abilityPartPredicate(MultiblockAbility.OUTPUT_ENERGY)).build();
    }

    public MultiblockAbility[] getAllowedAbilities() {
        MultiblockAbility[] multiblockAbilityArray;
        if (this.turbineType.hasOutputHatch) {
            MultiblockAbility[] multiblockAbilityArray2 = new MultiblockAbility[2];
            multiblockAbilityArray2[0] = MultiblockAbility.IMPORT_FLUIDS;
            multiblockAbilityArray = multiblockAbilityArray2;
            multiblockAbilityArray2[1] = MultiblockAbility.EXPORT_FLUIDS;
        } else {
            MultiblockAbility[] multiblockAbilityArray3 = new MultiblockAbility[1];
            multiblockAbilityArray = multiblockAbilityArray3;
            multiblockAbilityArray3[0] = MultiblockAbility.IMPORT_FLUIDS;
        }
        return multiblockAbilityArray;
    }

    public IBlockState getCasingState() {
        return this.turbineType.casingState;
    }

    @Override
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return this.turbineType.casingRenderer;
    }

    public static enum TurbineType {
        STEAM(RecipeMaps.STEAM_TURBINE_FUELS, MetaBlocks.TURBINE_CASING.getState(BlockTurbineCasing.TurbineCasingType.STEEL_TURBINE_CASING), Textures.SOLID_STEEL_CASING, true),
        GAS(RecipeMaps.GAS_TURBINE_FUELS, MetaBlocks.TURBINE_CASING.getState(BlockTurbineCasing.TurbineCasingType.STAINLESS_TURBINE_CASING), Textures.CLEAN_STAINLESS_STEEL_CASING, false),
        PLASMA(RecipeMaps.PLASMA_GENERATOR_FUELS, MetaBlocks.TURBINE_CASING.getState(BlockTurbineCasing.TurbineCasingType.TUNGSTENSTEEL_TURBINE_CASING), Textures.ROBUST_TUNGSTENSTEEL_CASING, true);

        public final FuelRecipeMap recipeMap;
        public final IBlockState casingState;
        public final ICubeRenderer casingRenderer;
        public final boolean hasOutputHatch;

        private TurbineType(FuelRecipeMap recipeMap, IBlockState casingState, ICubeRenderer casingRenderer, boolean hasOutputHatch) {
            this.recipeMap = recipeMap;
            this.casingState = casingState;
            this.casingRenderer = casingRenderer;
            this.hasOutputHatch = hasOutputHatch;
        }
    }
}

