/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.common.items.behaviors.AbstractUsableBehaviour;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class LighterBehaviour
extends AbstractUsableBehaviour {
    public LighterBehaviour(int fuelAmount) {
        super(fuelAmount);
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (entity instanceof EntityCreeper) {
            ((EntityCreeper)entity).func_146079_cb();
            this.useItemDurability(player, EnumHand.MAIN_HAND, stack, ItemStack.field_190927_a);
            return true;
        }
        return false;
    }

    @Override
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_175151_a(pos, side, stack)) {
            return EnumActionResult.FAIL;
        }
        if (!this.tryIgniteBlock(world, pos.func_177972_a(side))) {
            return EnumActionResult.PASS;
        }
        this.useItemDurability(player, hand, stack, ItemStack.field_190927_a);
        return EnumActionResult.SUCCESS;
    }

    public boolean tryIgniteBlock(World world, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
            return true;
        }
        return false;
    }

    @Override
    public void addInformation(ItemStack itemStack, List<String> lines) {
        lines.add(I18n.func_135052_a((String)"behaviour.lighter.tooltip", (Object[])new Object[0]));
        if (this.totalUses > 1) {
            int fuelAmount = this.getUsesLeft(itemStack);
            lines.add(I18n.func_135052_a((String)"behaviour.lighter.uses", (Object[])new Object[]{fuelAmount}));
        }
    }
}

